/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.worklist.node.cookie;

import java.io.IOException;

import org.openide.cookies.SaveCookie;
import org.openide.loaders.DataObject;


/**
 * CookieDelegate which delegates to the cookies stored in DataObject.
 * One place where cookies can be added, so that all the nodes created will have these cookies.
 * 
 * @author skini
 *
 */

public class DataObjectCookieDelegate implements SaveCookie { //PrintProviderCookie {
    DataObject dobj;
    
    public DataObjectCookieDelegate(DataObject dobj) {
        this.dobj = dobj;
    }
    
    public void save() throws IOException {
        if (dobj != null) {
            SaveCookie cookie = dobj.getCookie(SaveCookie.class);
            if (cookie != null) {
                cookie.save();
            }
        }
    }
    
   
}
