package it.imolinfo.jbi4corba.netbeansplugin.wsdlextension.impl;

import it.imolinfo.jbi4corba.netbeansplugin.wsdlextension.CorbaAddress;
import it.imolinfo.jbi4corba.netbeansplugin.wsdlextension.CorbaComponent;
import it.imolinfo.jbi4corba.netbeansplugin.wsdlextension.CorbaQName;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.dom.Attribute;
import org.w3c.dom.Element;

public class CorbaAddressImpl extends CorbaComponentImpl
        implements CorbaAddress {

    private static final Attribute INDIRIZZO = new Attribute() {

        public Class getMemberType() {
            return null;
        }

        public String getName() {
            return ATTR_CORBA_INDIRIZZO;
        }

        public Class getType() {
            return String.class;
        }
    };

    public CorbaAddressImpl(WSDLModel model, Element e) {
        super(model, e);
    }

    public CorbaAddressImpl(WSDLModel model){
        this(model,
             createPrefixedElement(CorbaQName.ADDRESS.getQName(), model));
    }

    public void accept(CorbaComponent.Visitor visitor) {
        visitor.visit(this);
    }

    public String getIndirizzo() {
        return getAttribute(INDIRIZZO);
    }

    public void setIndirizzo(String indirizzo) {
        setAttribute(ATTR_CORBA_INDIRIZZO, INDIRIZZO, indirizzo);
    }
}
