/* *************************************************************************
 *
 *          Copyright (c) 2002, SeeBeyond Technology Corporation,
 *          All Rights Reserved
 *
 *          This program, and all the routines referenced herein,
 *          are the proprietary properties and trade secrets of
 *          SEEBEYOND TECHNOLOGY CORPORATION.
 *
 *          Except as provided for by license agreement, this
 *          program shall not be duplicated, used, or disclosed
 *          without  written consent signed by an officer of
 *          SEEBEYOND TECHNOLOGY CORPORATION.
 *
 ***************************************************************************/
package org.netbeans.modules.aspect.project.anttasks;

import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/**
 *
 * @author blu
 */
public class GenerateAsaArtifacts extends Task {

    private String mAspectMapFileLocation;
    private String mJbiDescriptorFileLocation;

    /** Creates a new instance of GenerateIEPASAArtifacts */
    public GenerateAsaArtifacts() {
    }

    /**
     * @return Returns the srcDirectoryLocation.
     */
    public String getAspectMapFileLocation() {
        return mAspectMapFileLocation;
    }
    /**
     * @param cacheMapFileLocation The cacheMapFileLocation to set.
     */
    public void setAspectMapFileLocation(String aspectMapFileLocation) {
        mAspectMapFileLocation = aspectMapFileLocation;
    }

    /**
     * @return Returns the portMapFileLocation.
     */
    public String getJbiDescriptorFileLocation() {
        return mJbiDescriptorFileLocation;
    }
    /**
     * @param portMapFileLocation The portMapFileLocation to set.
     */
    public void setJbiDescriptorFileLocation(String jbiDescriptorFileLocation) {
        mJbiDescriptorFileLocation = jbiDescriptorFileLocation;
    }

    public void execute() throws BuildException {
        File aspectMapFile = new File(mAspectMapFileLocation);
        if (!aspectMapFile.exists()) {
            throw new BuildException("File " + mAspectMapFileLocation + " does not exit.");
        }


        Map prefixTable = new HashMap(); // keyed by prefix
        Map nsTable = new HashMap(); // keyed by name space
        FileOutputStream fos = null;
        try {
            List aspectEntryList = AspectMapReader.parse(aspectMapFile);

            // Populate prefixTable
            int nsIndex = 1;
            for (int i = 0, I = aspectEntryList.size(); i < I; i++) {
                AspectMapEntry entry = (AspectMapEntry)aspectEntryList.get(i);
                String ns = entry.getPartnerLink().getNamespaceURI();
                if (ns != null && !ns.trim().equals("") && !nsTable.containsKey(ns)) {
                    nsTable.put(ns, "ns" + nsIndex);
                    prefixTable.put("ns" + nsIndex, ns);
                    nsIndex++;
                }

                ns = entry.getPortType().getNamespaceURI();
                if (ns != null && !ns.trim().equals("") && !nsTable.containsKey(ns)) {
                    nsTable.put(ns, "ns" + nsIndex);
                    prefixTable.put("ns" + nsIndex, ns);
                    nsIndex++;
                }

                if (entry.getType() == AspectMapEntry.OUTPUT_MESSAGE_TYPE) {
                    ns = entry.getPartnerLink().getNamespaceURI();
                    if (ns != null && !ns.trim().equals("") && !nsTable.containsKey(ns)) {
                        nsTable.put(ns, "ns" + nsIndex);
                        prefixTable.put("ns" + nsIndex, ns);
                        nsIndex++;
                    }

                    ns = entry.getPortType().getNamespaceURI();
                    if (ns != null && !ns.trim().equals("") && !nsTable.containsKey(ns)) {
                        nsTable.put(ns, "ns" + nsIndex);
                        prefixTable.put("ns" + nsIndex, ns);
                        nsIndex++;
                    }
                }
            }

            JBIWriter writer = new JBIWriter();            
                String content = writer.generateJBIString(prefixTable, nsTable, aspectEntryList);
                fos = new FileOutputStream(mJbiDescriptorFileLocation);
                IOUtil.copy(content.getBytes("UTF-8"), fos);
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                if (fos != null) {
                    try {
                        fos.close();
                    } catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
    }
}