/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.aspect.editor.property;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.netbeans.modules.aspect.editor.jaxbmodel.AdviceType;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.nodes.Children;
import org.openide.nodes.PropertySupport;
import org.netbeans.modules.aspect.editor.property.propBeans.throttling;
import org.openide.nodes.AbstractNode;
import org.openide.windows.WindowManager;


/**
 *
 * @author nk160297
 */
public class throttlingNode extends AbstractNode implements MouseListener {


    private AdviceType adviceType;
    
    public throttlingNode(AdviceType ad) {
        
        super(Children.LEAF);
        this.adviceType = ad;
        setDisplayName(ad.getType());
    }

    @Override
    public boolean canCopy() {
        return false;
    }
    
    @Override
    public boolean canRename() {
        return false;
    }
    
    @Override
    public boolean canCut() {
        return false;
    }
    
    @Override
    public boolean canDestroy() {
        return true;
    }
    
    public void mouseClicked(MouseEvent e) {
        //throw new UnsupportedOperationException("Not supported yet.");
    }

    public void mousePressed(MouseEvent e) {
        WindowManager.getDefault().getRegistry().getActivated().setActivatedNodes(new Node[]{this});
    }

    public void mouseReleased(MouseEvent e) {
        //throw new UnsupportedOperationException("Not supported yet.");
    }

    public void mouseEntered(MouseEvent e) {
        //throw new UnsupportedOperationException("Not supported yet.");
    }

    public void mouseExited(MouseEvent e) {
        //throw new UnsupportedOperationException("Not supported yet.");
    }
    
    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = sheet.createPropertiesSet();
        throttling obj = new throttling(this.adviceType);
        try {
            Property rateProp = new PropertySupport.Reflection(obj, String.class, "getRate", "setRate");
            Property queLenghtProp = new PropertySupport.Reflection(obj, String.class, "getQueLenght", "setQueLenght");
                    
            rateProp.setName("Throttle Rate");
            queLenghtProp.setName ("Throttle Queue length");
            
            set.put (rateProp);
            set.put (queLenghtProp);   
                        
        } catch (Exception ex) {
            ErrorManager.getDefault().notify(ex);
        }
        sheet.put(set);
        return sheet;
    }
   
  }
    

