/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.edm.editor.widgets.property;

import org.netbeans.modules.edm.editor.dataobject.MashupDataObject;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;

import org.netbeans.modules.sql.framework.model.SourceTable;


/**
 *
 * @author karthikeyan s
 */
public class SourceTableNode extends AbstractNode {
    
    private SourceTable srcTable;
    
    private MashupDataObject mObj; 
    
    public SourceTableNode(SourceTable obj) {
        super(Children.LEAF);
        srcTable = (SourceTable) obj;
    }
    
    @Override
    public boolean canCopy() {
        return false;
    }
    
    @Override
    public boolean canRename() {
        return false;
    }
    
    @Override
    public boolean canCut() {
        return false;
    }
    
    @Override
    public boolean canDestroy() {
        return true;
    }
    
    /** Creates a property sheet. */
    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.createPropertiesSet();
        Sheet.Set expset = sheet.createExpertSet();
        set.setDisplayName("Basic");
        set.setExpert(false);
        expset.setDisplayName("Expert");
        expset.setExpert(true);
        try { 
            PropertySupport.Reflection nameProp = new PropertySupport.Reflection(this.srcTable,
                    String.class, "getFullyQualifiedName", null);
            nameProp.setName("Table Name");
            set.put(nameProp);
             
            PropertySupport.Reflection databaseModelNameProp = new PropertySupport.Reflection(this.srcTable.getParent(),
                    String.class, "getModelName", null);
            databaseModelNameProp.setName("Database Model Name");
            set.put(databaseModelNameProp);
            
            PropertySupport.Reflection schemaProp = new PropertySupport.Reflection(this.srcTable,
                    String.class, "getSchema","setSchema");
            schemaProp.setName("Schema Name");
            set.put(schemaProp);   
            
            PropertySupport.Reflection catalogProp = new PropertySupport.Reflection(this.srcTable,
                    String.class, "getCatalog","setCatalog");
            catalogProp.setName("Catalog Name");
            set.put(catalogProp);  
          
            PropertySupport.Reflection distinctProp = new PropertySupport.Reflection(this.srcTable,
                    Boolean.class, "isSelectDistinct", "setSelectDistinct");
            distinctProp.setName("Is Distinct");
            set.put(distinctProp);              
            
            PropertySupport.Reflection aliasNameProp = new PropertySupport.Reflection(this.srcTable,
                    String.class, "getAliasName", "setAliasName");
            aliasNameProp.setName("Alias Name");
            expset.put(aliasNameProp); 
            
            PropertySupport.Reflection usrTblNameProp = new PropertySupport.Reflection(this.srcTable,
                    String.class,"getUserDefinedTableName" , "setUserDefinedTableName");
            usrTblNameProp.setName("User Defined Table Name");
            expset.put(usrTblNameProp); 
            
            PropertySupport.Reflection usrSchemaNameProp = new PropertySupport.Reflection(this.srcTable,
                    String.class,"getUserDefinedSchemaName" , "setUserDefinedSchemaName");
            usrSchemaNameProp.setName("User Defined Schema Name");
            expset.put(usrSchemaNameProp); 
            
            PropertySupport.Reflection usrCatalogNameProp = new PropertySupport.Reflection(this.srcTable,
                    String.class,"getUserDefinedCatalogName" , "setUserDefinedCatalogName");
            usrCatalogNameProp.setName("User Defined Catalog Name");
            expset.put(usrCatalogNameProp); 
            
            PropertySupport.Reflection isFullyQualProp = new PropertySupport.Reflection(this.srcTable,
                    Boolean.class,"isUsingFullyQualifiedName" , "setSelectDistinct");
            isFullyQualProp.setName("Use Fully Qualified Name");
            expset.put(isFullyQualProp);  
            
            PropertySupport.Reflection srcTblPrefixProp = new PropertySupport.Reflection(this.srcTable,
                    String.class,"getTablePrefix" , "setTablePrefix");
            srcTblPrefixProp.setName("Source Table Prefix");
            expset.put(srcTblPrefixProp); 
            
            PropertySupport.Reflection stagingTblNameProp = new PropertySupport.Reflection(this.srcTable,
                    String.class,"getStagingTableName" , "setStagingTableName");
            stagingTblNameProp.setName("Staging Table Name");
            expset.put(stagingTblNameProp); 
            
            PropertySupport.Reflection dropStagingTblProp = new PropertySupport.Reflection(this.srcTable,
                    Boolean.class,"isDropStagingTable" , "setSelectDistinct");
            dropStagingTblProp.setName("Drop Staging Table");
            expset.put(dropStagingTblProp); 
            
            PropertySupport.Reflection truncateStagingTblProp = new PropertySupport.Reflection(this.srcTable,
                    Boolean.class,"isTruncateStagingTable" , "setSelectDistinct");
            truncateStagingTblProp.setName("Truncate Staging Table");
            expset.put(truncateStagingTblProp); 
            
            PropertySupport.Reflection batchSizeProp = new PropertySupport.Reflection(this.srcTable,
                    Integer.class,"getBatchSize" , null);
            batchSizeProp.setName("Batch Size");
            expset.put(batchSizeProp);                        
        } catch (Exception ex) {
            ErrorManager.getDefault().notify(ex);
        }
        sheet.put(set);
        sheet.put(expset);
        return sheet;
    }
    
     public SourceTable getSourceTable() {
        return this.srcTable;
    }
    
    public MashupDataObject getMashupDataObject() {
        return mObj;
    }
  
}
