/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.sun.manager.jbi.nodes;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/**
 *
 * @author jqian
 */
public abstract class JBIArtifactValidator {
    
    private static ComponentValidator serviceEngineValidator;
    private static ComponentValidator bindingComponentValidator;
    private static SharedLibraryValidator sharedLibraryValidator;
    private static ServiceAssemblyValidator serviceAssemblyValidator;
        
    public static JBIArtifactValidator getServiceEngineValidator(String name) {
        if (serviceEngineValidator == null) {
            serviceEngineValidator = new ServiceEngineValidator();
        }
        serviceEngineValidator.setComponentName(name);
        
        return serviceEngineValidator;
    }
    
    public static JBIArtifactValidator getBindingComponentValidator(String name) {
        if (bindingComponentValidator == null) {
            bindingComponentValidator = new BindingComponentValidator();
        }
        bindingComponentValidator.setComponentName(name);
        
        return bindingComponentValidator;
    }
    
    public static JBIArtifactValidator getSharedLibraryValidator() {
        if (sharedLibraryValidator == null) {
            sharedLibraryValidator = new SharedLibraryValidator();
        }
        
        return sharedLibraryValidator;
    }
    
    public static JBIArtifactValidator getServiceAssemblyValidator() {
        if (serviceAssemblyValidator == null) {
            serviceAssemblyValidator = new ServiceAssemblyValidator();
        }
        
        return serviceAssemblyValidator;
    }

    public boolean validate(File zipFile) {
        boolean isRightType = false;

        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = factory.newDocumentBuilder();
        } catch (ParserConfigurationException ex) {
            ex.printStackTrace();
        }

        if (docBuilder != null) {
            JarFile jf = null;
            try {
                jf = new JarFile(zipFile);
                JarEntry je = (JarEntry) jf.getEntry("META-INF/jbi.xml"); // NOI18N
                if (je != null) {
                    InputStream is = jf.getInputStream(je);
                    Document doc = docBuilder.parse(is);
                    isRightType = validate(doc); // very basic type checking
                }
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                if (jf != null) {
                    try {
                        jf.close();
                    } catch (IOException e) {
                    }
                }
            }
        }

        return isRightType;
    }

    protected abstract boolean validate(Document jbiDoc);
    
    
    //==========================================================================

    private static class ComponentValidator extends JBIArtifactValidator {

        private String componentType;
        private String componentName;
        
        ComponentValidator(String componentType) {
            this.componentType = componentType;
        }
        
        public void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        protected boolean validate(Document jbiDoc) {
            NodeList ns = jbiDoc.getElementsByTagName("component"); // NOI18N
            if (ns.getLength() > 0) {
                Element e = (Element) ns.item(0);
                String type = e.getAttribute("type"); // NOI18N
                if (type != null && type.equals(componentType)) {
                    if (componentName == null) {
                        return true;
                    } else {
                        String name = null;
                        NodeList ids = e.getElementsByTagName("identification"); // NOI18N
                        if (ids.getLength() > 0) {
                            Element id = (Element) ids.item(0);
                            NodeList names = id.getElementsByTagName("name"); // NOI18N
                            if (names.getLength() > 0) {
                                Element n = (Element) names.item(0);
                                name = n.getFirstChild().getNodeValue();
                            }
                        }
                        if (componentName.equals(name)) {
                            return true;
                        }
                    }
                }
            }
            return false;
        }
    }
    
    private static class ServiceEngineValidator extends ComponentValidator {
        ServiceEngineValidator() {
            super("service-engine"); // NOI18N
        }
    }

    private static class BindingComponentValidator extends ComponentValidator {
        BindingComponentValidator() {
            super("binding-component"); // NOI18N
        }
    }

    private static class SharedLibraryValidator extends JBIArtifactValidator {
        
        protected boolean validate(Document jbiDoc) {
            NodeList ns = jbiDoc.getElementsByTagName("shared-library"); // NOI18N
            return ns.getLength() > 0;
        }
    }
    
    private static class ServiceAssemblyValidator extends JBIArtifactValidator {
                
        protected boolean validate(Document jbiDoc) {
            NodeList ns = jbiDoc.getElementsByTagName("service-assembly"); // NOI18N
            return ns.getLength() == 1;
        }
    }
}