/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.palette;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.netbeans.modules.soa.mapper.common.ui.palette.IPaletteCategory;
import org.netbeans.modules.soa.mapper.common.ui.palette.IPaletteItem;
import org.netbeans.modules.soa.mapper.common.ui.palette.IPaletteManager;
import org.netbeans.modules.soa.mapper.common.basicmapper.exception.MapperException;
import org.netbeans.modules.soa.mapper.common.basicmapper.BasicMapperFactory;


/**
 * BPEL PaletteManager, this is a singleton class created to manage BPEL
 * functoid palette. It extends from the PaletteManager class and adds BPEL
 * specific functions.
 *
 * @author Tientien Li
 * @version 
 */
public class XpathPaletteManager {
//         extends PaletteManager {
    
    /**
     * Field BPEL_PALETTE_FOLDER_NAME
     */
    private static final String BPEL_PALETTE_FOLDER_NAME = "BPELPalette";   // NOI18N
    
    private static XpathPaletteManager mInstance;
    
    /**
     * categories
     */
    private IPaletteCategory[] mCategories = null;
    
    /**
     * items within a category
     */
    private  IPaletteItem[][] mItems = null;
    
    /**
     * The instance of BPEL PaletteManager (singleton).
     */
    private  IPaletteManager mPaletteManager;
    
    /**
     * The log4j logger
     */
    private  final Logger mLogger =
            Logger.getLogger(XpathPaletteManager.class.getName());
    
    private  Map mXpathPaletteItemInfoMap = new HashMap();
    
    private  Map mXpathPaletteItemMap = new HashMap();
    
    /**
     * Creates a new instance of XpathPaletteManager
     */
    private XpathPaletteManager() {
        synchronized (this) {
            if (mPaletteManager == null) {
                
                try {
                    mPaletteManager = BasicMapperFactory.
                            createPaletteManager(BPEL_PALETTE_FOLDER_NAME);
                } catch (MapperException m) {
                    mLogger.log(Level.SEVERE, "", m);   // NOI18N
                }
            }
            
            initPaletteDB();
        }
        
    }
    
    
    /**
     * Getter for singleton instance of XpathPaletteManager
     *
     *
     * @return the palette manager
     */
    public static XpathPaletteManager getDefault() {
        if(mInstance == null) {
            mInstance = new XpathPaletteManager();
        }
        return mInstance;
    }
    
    public synchronized IPaletteManager getPaletteManager() {
        return this.mPaletteManager;
    }
    
    /**
     * Get paletteItem by name
     *
     * @param name the name of palette item
     * @return the named palette item if found.
     */
    public synchronized IPaletteItem getItemByMethodName(String name) {
        initPaletteDB();
        return (IPaletteItem) mXpathPaletteItemMap.get(name);
    }
    
    /**
     * Get paletteItemInfo by name
     *
     * @param name the name of the palette item
     * @return the palette item information associated with the palette
     */
    public synchronized XpathPaletteItemInfo  getItemInfoByMethodName(String name) {
        initPaletteDB();
        return (XpathPaletteItemInfo) mXpathPaletteItemInfoMap.get(name);
    }
    
    /**
     * Initialize Palette data base
     *
     */
    private void initPaletteDB() {
        if (mXpathPaletteItemMap.size() != 0) {
            return;
        }
        mCategories = mPaletteManager.getAllCategories();
        
        int mCat = mCategories.length;
        mItems = new IPaletteItem[mCat][];
        for (int i = 0; i < mCat; i++) {
            mItems[i] = mPaletteManager.getCategoryItems(mCategories[i]);
            if (mItems [i] != null) {
                for (int j = 0; j < mItems[i].length; j++) {
                    IPaletteItem item = mItems[i][j];
                    String methodName = (String) mItems[i][j].getItemAttribute("Method");   // NOI18N
                    //put palette item in a map for quick retrieval
                    if (methodName != null && !methodName.trim().equals("") && item != null) {
                        mXpathPaletteItemMap.put(methodName, item);
                        //put palette item info in a map for quick rerieval
                        XpathPaletteItemInfo paletteItemInfo = new XpathPaletteItemInfo(mCategories[i], mItems[i][j]);
                        mXpathPaletteItemInfoMap.put(methodName, paletteItemInfo);
                    }
                }
            }
        }
    }
    
}
