/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.output;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.io.ObjectStreamException;
import java.lang.ref.WeakReference;
import java.util.Map;

import javax.accessibility.AccessibleContext;
import javax.swing.JTree;

import org.netbeans.modules.bpel.core.BPELDataEditorSupport;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.openide.actions.FindAction;
import org.openide.awt.UndoRedo;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/**
 *
 * @author radval
 */
public final class ResultWindow extends TopComponent {
    
    /** unique ID of <code>TopComponent</code> (singleton) */
    private static final String ID = "mapperTC";              //NOI18N

    /**
     * instance/singleton of this class
     *
     * @see  #getInstance
     */
    private static ResultWindow mInstance = null;
    
    private static transient DesignContextChangeListener mDesignContextListener;
    private Component view;
    private Map topCompMethodsMap;
    
    private WeakReference mCurrentModelReference;
    private MapperUndoRedo mMapperUndoRedo;
    

    /**
     * Returns a singleton of this class.
     *
     * @return  singleton of this class
     */
    public static synchronized ResultWindow getInstance() {
        ResultWindow window = null;
        if (WindowManager.getDefault().findTopComponent(ID) instanceof ResultWindow) {
            window = (ResultWindow) WindowManager.getDefault().findTopComponent(ID);
        }
        if (window == null) {
            window = getDefault();
        }
        return window;
    }
    
    /**
     * Singleton accessor reserved for the window system only.
     * The window system calls this method to create an instance of this
     * <code>TopComponent</code> from a <code>.settings</code> file.
     * <p>
     * <em>This method should not be called anywhere except from the window
     * system's code.</em>
     *
     * @return  singleton - instance of this class
     */
    public static synchronized ResultWindow getDefault() {
        if (mInstance == null) {
            return new ResultWindow();
        }
        return mInstance;
    }

    
    /** Creates a new instance of ResultWindow */
    public ResultWindow() {
        super();
        
        setName(ID);
        
        setLayout(new BorderLayout());
        
        setDisplayName(getTitleBase());      //NOI18N
        setIcon(Utilities.loadImage(
                "org/netbeans/modules/bpel/xpath/view/resources/images/mapper.png",//NOI18N
                true));
        
        AccessibleContext accessibleContext = getAccessibleContext();
        accessibleContext.setAccessibleName(
                NbBundle.getMessage(getClass(), "ACSN_MapperResults"));   //NOI18N
        accessibleContext.setAccessibleDescription(
                NbBundle.getMessage(getClass(), "ACSN_MapperResults"));   //NOI18N
        
        if (mInstance != null) {
            TopComponent.getRegistry().removePropertyChangeListener(
                    mInstance.getDesignContextChangeListener());
        }
        TopComponent.getRegistry().addPropertyChangeListener(getDesignContextChangeListener());

        // Install our own actions.
        CallbackSystemAction globalFindAction =
                (CallbackSystemAction) SystemAction.get(FindAction.class);
        getActionMap().put(globalFindAction.getActionMapKey(), new MapperFindAction());
        
        mInstance = this;
    }
    
    
    public static String getTitleBase() {
        return NbBundle.getMessage(ResultWindow.class, "TITLE_MAPPER_WINDOW");  // NOI18N
    }
    
    protected void componentOpened() {
        assert EventQueue.isDispatchThread();
        super.componentOpened();
        
        getDesignContextChangeListener().getDesignContextChanger().reloadEditor();
    }
    
    protected void componentClosed() {
        assert EventQueue.isDispatchThread();
        super.componentClosed();
    }
    
    protected void componentActivated() {
        assert EventQueue.isDispatchThread();
        super.componentActivated();
        
        // not sure that we need to add undo manager each time when 
        // component is activated, but calling method addUndoManager() more
        // than once is not a problem.
        addUndoManager();

        // request focus

        boolean clearFocus = true;

        if (view != null) {
            if (!isFocusInside(view)) {
                Component focusable = getFocusableDescendant(view);
                if (focusable != null) {
                    focusable.requestFocusInWindow();
                    clearFocus = false;
                }
            }
        }

        if (clearFocus) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager()
                    .clearGlobalFocusOwner();
        }
    }


    private boolean isFocusInside(Component container) {
        Component focusOwner = KeyboardFocusManager
                .getCurrentKeyboardFocusManager().getFocusOwner();
        for (Component c = focusOwner; c != null; c = c.getParent()) {
            if (c == container) {
                return true;
            }
        }

        return false;
    }


    private Component getFocusableDescendant(Component ancestor) {
        if (ancestor instanceof JTree) {
            return ancestor;
        }

        Component result = null;

        if (ancestor instanceof Container) {
            Container container = (Container) ancestor;
            for (int i = container.getComponentCount() - 1; i >= 0; i--) {
                result = getFocusableDescendant(container.getComponent(i));
                if (result != null) break;
            }
        }

        return result;
    }

    
    protected void componentDeactivated() {
        assert EventQueue.isDispatchThread();
        super.componentDeactivated();
    }
    
    protected void componentShowing() {
        assert EventQueue.isDispatchThread();
        super.componentShowing();
        
        addUndoManager();
    }
    
    protected void componentHidden() {
        assert EventQueue.isDispatchThread();
        super.componentHidden();
    }
   
    public void addDisplayComponent(Component displayComp) {
        assert EventQueue.isDispatchThread();
        removeAll();
        addView(displayComp);
    }
    
    private void addView(final Component view) {
        assert EventQueue.isDispatchThread();
        this.view = view;
        add(view);
    }
    
    private boolean isActivated() {
        return TopComponent.getRegistry().getActivated() == this;
    }
    
    void promote() {
        assert EventQueue.isDispatchThread();
        open();
        requestVisible();
        requestActive();
    }
    
    protected String preferredID() {
        return ID;
    }
    
    public HelpCtx getHelpCtx() {
        return new HelpCtx(getClass());
    }
    
    public int getPersistenceType() {
        return TopComponent.PERSISTENCE_ALWAYS;
    }
    
    public void setSynchronizationListenerEnable(boolean isEnabled) {
        mDesignContextListener.setSynchronizationListenerEnable(isEnabled);
    }
    
    public DesignContextChangeListener getDesignContextChangeListener() {
        if (mDesignContextListener == null) {
            mDesignContextListener = new DesignContextChangeListener();
        }
        return mDesignContextListener;
    }
    
    public void setCurrentBpelModel(BpelModel model) {
        mCurrentModelReference = new WeakReference(model);
    }

    public BpelModel getCurrentBpelModel() {
        if (mCurrentModelReference != null) {
            return (BpelModel) mCurrentModelReference.get();
        }
        return null;
    }
    
    public UndoRedo getUndoRedo() {
        if (mMapperUndoRedo == null) {
            mMapperUndoRedo = new MapperUndoRedo(super.getUndoRedo());
        }
        return mMapperUndoRedo;
    }
    
    /**
     * Resolves to the {@linkplain #getDefault default instance} of this class.
     *
     * This method is necessary for correct functinality of window system's
     * mechanism of persistence of top components.
     */
    private Object readResolve() throws ObjectStreamException {
        return mInstance;
    }
    
    /**
     * Adds the undo/redo manager to the bpel model as an undoable
     * edit listener, so it receives the edits onto the queue.
     */
    private void addUndoManager() {
        BpelModel bpelModel = getCurrentBpelModel();
        if (bpelModel != null) {
            BPELDataEditorSupport editorSupport = 
                    ((MapperUndoRedo) getUndoRedo()).getEditorSupport();
            if (editorSupport != null) {
                editorSupport.addUndoManagerToModel( editorSupport.getUndoManager() );
            }
        }
    }

}
