/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.output;

import java.lang.ref.WeakReference;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.events.ArrayUpdateEvent;
import org.netbeans.modules.bpel.model.api.events.ChangeEventListener;
import org.netbeans.modules.bpel.model.api.events.EntityInsertEvent;
import org.netbeans.modules.bpel.model.api.events.EntityRemoveEvent;
import org.netbeans.modules.bpel.model.api.events.EntityUpdateEvent;
import org.netbeans.modules.bpel.model.api.events.PropertyRemoveEvent;
import org.netbeans.modules.bpel.model.api.events.PropertyUpdateEvent;
import org.netbeans.modules.bpel.xpath.view.AbstractBPELElementExpressionView;
import org.netbeans.modules.xml.xam.Model.State;

/**
 *
 * @author jsandusky
 */
public class DesignContextSynchronizationListener implements ChangeEventListener {
    
    private WeakReference mView;
    private WeakReference mCurrentModel;
    private boolean mIsEnabled;
    private DesignContextChanger mDesignContextChanger;
    
    
    /** Creates a new instance of DesignContextSynchronizationListener */
    public DesignContextSynchronizationListener(DesignContextChanger contextChanger) {
        mIsEnabled = true;
        mDesignContextChanger = contextChanger;
    }
    
    
    public void setSynchronization(AbstractBPELElementExpressionView view, BpelModel model) {
        mView = new WeakReference(view);
        if (mCurrentModel != null && mCurrentModel.get() != null) {
            BpelModel oldModel = (BpelModel) mCurrentModel.get();
            oldModel.removeEntityChangeListener(this);
        }
        if (model != null) {
            mCurrentModel = new WeakReference(model);
            model.addEntityChangeListener(this);
        }
    }
    
    public void setEnabled(boolean isEnabled) {
        mIsEnabled = isEnabled;
    }
    
    public boolean isEnabled() {
        return mIsEnabled;
    }
    
    public void notifyPropertyUpdated(PropertyUpdateEvent event) {
        handleChangeEvent(event.getParent(), event.getNewValue());
    }
    
    public void notifyArrayUpdated(ArrayUpdateEvent event) {
    }
    
    public void notifyEntityInserted(EntityInsertEvent event) {
        handleChangeEvent(event.getParent(), event.getValue());
    }
    
    public void notifyEntityRemoved(EntityRemoveEvent event) {
        handleChangeEvent(event.getParent(), event.getOldValue());
    }
    
    public void notifyEntityUpdated(EntityUpdateEvent event) {
        handleChangeEvent(event.getParent(), event.getNewValue());
    }
    
    public void notifyPropertyRemoved(PropertyRemoveEvent event) {
        handleChangeEvent(event.getParent(), event.getOldValue());
    }
    
    
    private void handleChangeEvent(final BpelEntity parent, 
            final Object newValue) 
    {
        Runnable runnable = new Runnable() {
            public void run() {
                if (!mIsEnabled) {
                    return;
                }

                if (!hasView()) {
                    return;
                }

                if (parent != null && parent.getBpelModel().getState()
                        .equals(State.NOT_WELL_FORMED)) {
                    // If our model has become invalid, disable the mapper.
                    mDesignContextChanger.designContextChanged(null);
                }

                if (newValue != null && hasView()) {
                    mDesignContextChanger.updateTitle();
                    AbstractBPELElementExpressionView view 
                            = (AbstractBPELElementExpressionView) mView.get();
                    view.synchronizeExpressionView(parent, newValue);
                }
            }
        };
        
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(runnable);
        } else {
            runnable.run();
        }
    }
    
    private boolean hasView() {
        if (mView != null) {
            AbstractBPELElementExpressionView view = (AbstractBPELElementExpressionView) mView.get();
            if (view != null && ResultWindow.getInstance().isShowing()) {
                return true;
            }
        }
        return false;
    }
}
