/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.expression.impl;

import javax.swing.JTree;
import org.netbeans.modules.bpel.xpath.model.nodes.CanvasNode;
import org.netbeans.modules.bpel.xpath.model.nodes.Node;
import org.netbeans.modules.soa.mapper.common.IMapperGroupNode;

import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapper;
import org.netbeans.modules.soa.mapper.common.IMapperLink;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import org.netbeans.modules.soa.mapper.common.IMapperViewModel;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IFieldNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

/**
 *
 * @author radval
 *
 */
public class MapperUtil {
    
    public static void registerListeners(BpelMapper mapper) {
        
        JTree leftTree = mapper.getMapperViewManager().
                getSourceView().getTree();
        JTree rightTree = mapper.getMapperViewManager().
                getDestView().getTree();
        
        SourceTreeHelper sHelper = new SourceTreeHelper(mapper);
        TargetTreeHelper tHelper = new TargetTreeHelper(mapper);
        
        leftTree.addTreeExpansionListener(sHelper.getTreeExpansionListener());
        leftTree.addTreeSelectionListener(sHelper.getTreeSelectionListener());
        rightTree.addTreeExpansionListener(tHelper.getTreeExpansionListener());
        rightTree.addTreeSelectionListener(tHelper.getTreeSelectionListener());
        
        leftTree.addMouseListener(sHelper.getMouseListener());
        rightTree.addMouseListener(tHelper.getMouseListener());
        leftTree.setScrollsOnExpand(true);
        rightTree.setScrollsOnExpand(true);
        
        leftTree.setAutoscrolls(true);
        rightTree.setAutoscrolls(true);
    }
    
    
    /** checks if the strin gis null or empty in length */
    public static final boolean isEmpty(String val) {
        return ((null == val) || (val.trim().length() == 0));
    }
    
    
    public static void createLinkWithoutMapperEvents(IMapperLink link, IBasicMapper mapper) {
        IMapperNode startNode = link.getStartNode();
        IMapperNode endNode = link.getEndNode();
        
        if ((mapper.getMapperViewManager().getMapperModel() != null)
        && (mapper.getMapperViewManager().getMapperModel().getSelectedViewModel() != null)) {
            IMapperViewModel viewModel = mapper.getMapperViewManager().getMapperModel().getSelectedViewModel();
            
            if (startNode != null) {
                IMapperNode groupNode = startNode;
                
                while (groupNode.getGroupNode() != null) {
                    groupNode = groupNode.getGroupNode();
                }
                
                if (!(viewModel.containsNode(groupNode))) {
                    mapper.addNode(groupNode);
                }
            }
            
            if (endNode != null) {
                IMapperNode groupNode = endNode;
                
                while (groupNode.getGroupNode() != null) {
                    groupNode = groupNode.getGroupNode();
                }
                
                if (!(viewModel.containsNode(groupNode))) {
                    mapper.addNode(groupNode);
                }
            }
        }
        
        mapper.connectLink(link);
    }
    
    
    /**
     * Describe <code>displayErrorPane</code> method here.
     *
     * @param errorString a <code>String</code> value
     */
    public static final void displayErrorPane(String errorString) {
        displayPane(errorString, NotifyDescriptor.ERROR_MESSAGE);
    }
    
    
    /**
     * Describe <code>displayErrorPane</code> method here.
     *
     * @param errorString a <code>String</code> value
     */
    public static final void displayWarningPane(String errorString) {
        displayPane(errorString, NotifyDescriptor.WARNING_MESSAGE);
    }
    
    
    /**
     * Describe <code>displayErrorPane</code> method here.
     *
     * @param errorString a <code>String</code> value
     * @param type message type
     */
    public static final void displayPane(String errorString, int type) {
        
        NotifyDescriptor d = new NotifyDescriptor.
                Message(errorString.toString(), type);
        DialogDisplayer.getDefault().notify(d);
        return;
    }
    
    public static final Node getMapperNodeObject(IMapperNode mapperNode) {
        if (mapperNode instanceof IFieldNode) {
            return getFieldNodeObject((IFieldNode) mapperNode);
        }
        return (Node) mapperNode.getNodeObject();
    }

    public static final CanvasNode getFieldNodeObject(IFieldNode fieldNode) {
        IMapperGroupNode groupNode = fieldNode.getGroupNode();
        return (CanvasNode) groupNode.getNodeObject();
    }
    
    public static int findFieldIndex(IMapperGroupNode groupNode, IFieldNode fieldNode) {
        IMapperNode node = groupNode.getFirstNode();
        int index = 0;
        while (node != null) {
            if(node.equals(fieldNode)) {
                break;
            }
            node = groupNode.getNextNode(node);
            index++;
        }
        return index;
    }
}
