/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.model.nodes.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.bpel.model.api.Catch;

import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.model.api.references.SchemaReference;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.xpath.model.node.visitor.NodeVisitor;
import org.netbeans.modules.bpel.xpath.model.nodes.NodeFactory;
import org.netbeans.modules.bpel.xpath.model.nodes.PartNode;
import org.netbeans.modules.bpel.xpath.model.nodes.TreeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.VariableNode;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Part;

/**
 * 
 * @author radval
 *
 */
public class VariableNodeImpl extends AbstractTreeNode implements VariableNode {

	private VariableDeclaration mVariableDeclaration;
        
	
	public VariableNodeImpl(Variable variable) {
		super(variable);
		this.mVariableDeclaration = variable;
	}
        
        
        public VariableNodeImpl(Catch theCatch) {
            super(theCatch);
            this.mVariableDeclaration = theCatch;
        }
        

	public VariableDeclaration getVariableDeclaration() {
            return this.mVariableDeclaration;
	}
	

	public String getName() {
            return (mVariableDeclaration instanceof Catch) 
                    ? ((Catch) mVariableDeclaration).getFaultVariable()
                    : ((Variable) mVariableDeclaration).getName();
	}
	
	
	public PartNode getPartNode(String partName) {
		if(partName == null) {
			return null;
		}
		PartNode partNode = null;
		
		List children = getChildren();
		Iterator it = children.iterator();
                
		while(it.hasNext()) {
			partNode = (PartNode) it.next();
			if(partName.equals(partNode.getName())) {
				break;
			}
		}
		
		return partNode;
	}


	protected void lazyLoadChildren() {
		WSDLReference<Message> messageRef = mVariableDeclaration
                        .getMessageType();
                SchemaReference<GlobalElement> elementRef = mVariableDeclaration
                        .getElement();
                SchemaReference<GlobalType> typeRef = mVariableDeclaration
                        .getType();
                
                if (!mVariableDeclaration.isInDocumentModel()) {
                    // This may be a dummy variable for mapping purposes,
                    // in which case there would be no children of this variable.
                    return;
                }
                
		if(messageRef != null) {
                        Message message = messageRef.get();
                        if(message != null) {
                            Collection parts = message.getParts();
                            if(parts != null) {
                                    Iterator it = parts.iterator();
                                    while(it.hasNext()) {
                                            Part part = (Part) it.next();
                                            TreeNode node = (TreeNode) NodeFactory.getInstance().createNode(part);
                                            if(node != null) {
                                                    this.addChild(node);
                                            }
                                    }
                            }
                        }
			
		} else if(elementRef != null){
                        GlobalElement element = elementRef.get();
                        if(element != null)  {
                            //variable node directly points to element and contains element children
                            TreeNode tempElementNode = (TreeNode) NodeFactory.getInstance().createNode(element);
                            if(tempElementNode != null) {
                                    List elementChildren = tempElementNode.getChildren();
                                    Iterator it = elementChildren.iterator();
                                    while(it.hasNext()) {
                                            TreeNode node = (TreeNode) it.next();
                                            this.addChild(node);
                                    }
                            }
                        }
		} else if(typeRef != null) {
                    GlobalType type = typeRef.get();
                    if (type != null) {
                        // variable node directly points to type and contains type's children
                        TreeNode tempTypeNode = (TreeNode) NodeFactory.getInstance().createNode(type);
                        if(tempTypeNode != null) {
                                List typeChildren = tempTypeNode.getChildren();
                                Iterator it = typeChildren.iterator();
                                while(it.hasNext()) {
                                        TreeNode node = (TreeNode) it.next();
                                        this.addChild(node);
                                }
                        }
                    }
		}
		
	}


	public void accept(NodeVisitor visitor) {
		visitor.visit(this);
	}
}
