/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.bpel.model.validation;

import java.util.HashSet;
import java.util.List;
import org.netbeans.modules.bpel.model.api.Activity;
import org.netbeans.modules.bpel.model.api.BpelContainer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.Catch;
import org.netbeans.modules.bpel.model.api.CatchAll;
import org.netbeans.modules.bpel.model.api.CompensationHandler;
import org.netbeans.modules.bpel.model.api.CompletionCondition;
import org.netbeans.modules.bpel.model.api.Copy;
import org.netbeans.modules.bpel.model.api.Correlation;
import org.netbeans.modules.bpel.model.api.CorrelationContainer;
import org.netbeans.modules.bpel.model.api.CorrelationSet;
import org.netbeans.modules.bpel.model.api.CorrelationSetContainer;
import org.netbeans.modules.bpel.model.api.Documentation;
import org.netbeans.modules.bpel.model.api.Else;
import org.netbeans.modules.bpel.model.api.ElseIf;
import org.netbeans.modules.bpel.model.api.EventHandlers;
import org.netbeans.modules.bpel.model.api.ExtensibleAssign;
import org.netbeans.modules.bpel.model.api.Extension;
import org.netbeans.modules.bpel.model.api.ExtensionActivity;
import org.netbeans.modules.bpel.model.api.ExtensionContainer;
import org.netbeans.modules.bpel.model.api.FaultHandlers;
import org.netbeans.modules.bpel.model.api.From;
import org.netbeans.modules.bpel.model.api.FromPartContainer;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.Link;
import org.netbeans.modules.bpel.model.api.LinkContainer;
import org.netbeans.modules.bpel.model.api.Literal;
import org.netbeans.modules.bpel.model.api.MessageExchange;
import org.netbeans.modules.bpel.model.api.MessageExchangeContainer;
import org.netbeans.modules.bpel.model.api.OnAlarmEvent;
import org.netbeans.modules.bpel.model.api.OnAlarmPick;
import org.netbeans.modules.bpel.model.api.OnEvent;
import org.netbeans.modules.bpel.model.api.OnMessage;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.PartnerLinkContainer;
import org.netbeans.modules.bpel.model.api.PatternedCorrelation;
import org.netbeans.modules.bpel.model.api.PatternedCorrelationContainer;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.Query;
import org.netbeans.modules.bpel.model.api.ServiceRef;
import org.netbeans.modules.bpel.model.api.Source;
import org.netbeans.modules.bpel.model.api.SourceContainer;
import org.netbeans.modules.bpel.model.api.Target;
import org.netbeans.modules.bpel.model.api.TargetContainer;
import org.netbeans.modules.bpel.model.api.TerminationHandler;
import org.netbeans.modules.bpel.model.api.To;
import org.netbeans.modules.bpel.model.api.ToPartContainer;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.VariableContainer;

import org.openide.util.NbBundle;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.bpel.model.api.support.BpelModelVisitorAdaptor;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.netbeans.modules.xml.xam.spi.Validator.ResultItem;
import org.netbeans.modules.xml.xam.spi.Validator.ResultType;

/**
 * @author ads
 */
public abstract class ValidationVisitorImpl extends BpelModelVisitorAdaptor 
        implements ValidationVisitor {

    private HashSet<ResultItem> myResultItems;
    
    public HashSet<ResultItem> getResultItems() {
      return myResultItems;
    }
    
    protected void init(){
      myResultItems = new HashSet<ResultItem>();
    }

    protected void visitChildren(BpelContainer parent) {
        List<BpelEntity> children = parent.getChildren();
        for (BpelEntity entity : children) {
            entity.accept(this);
        }
    }
    
    protected final void addWarning(String key, Validator validator, Component component) {
      addMessage(key, ResultType.WARNING, validator, component);
    }

    protected final void addError(String key, Validator validator, Component component) {
      addMessage(key, ResultType.ERROR, validator, component);
    }

    private void addMessage(String key, ResultType type, Validator validator, Component component) {
      String message = NbBundle.getMessage(getClass(), key);
      ResultItem item = new ResultItem(validator, type, component, message);
      getResultItems().add(item);
    }

    protected void visit( Activity activity ) {
        visitChildren((BpelContainer)activity);
    }
    
    //--------------------------------------------------------------------------
    
    public void visit( Process process ) {
        visitChildren(process);
    }

    public void visit( PartnerLinkContainer container ) {
        visitChildren(container);
    }

    public void visit( PartnerLink link ) {
        visitChildren(link);
    }

    public void visit( FaultHandlers handlers ) {
        visitChildren(handlers);
    }

    public void visit( Catch catc ) {
        visitChildren(catc);
    }

    public void visit( EventHandlers handlers ) {
        visitChildren(handlers);
    }

    public void visit( OnMessage message ) {
        visitChildren(message);
    }

    public void visit( CompensationHandler handler ) {
        visitChildren(handler);
    }

    public void visit( VariableContainer container ) {
        visitChildren(container);
    }

    public void visit( Variable variable ) {
        visitChildren(variable);
    }

    public void visit( CorrelationSetContainer container ) {
        visitChildren(container);
    }

    public void visit( CorrelationSet set ) {
        visitChildren(set);
    }

    public void visit( Source source ) {
        visitChildren(source);
    }

    public void visit( Target target ) {
        visitChildren(target);
    }

    public void visit( CorrelationContainer container ) {
            visitChildren(container);
    }

    public void visit( Correlation correlation ) {
        visitChildren(correlation);
    }

    public void visit( PatternedCorrelation correlation ) {
        visitChildren(correlation);
    }

    public void visit( PatternedCorrelationContainer container ) {
        visitChildren(container);
    }

    public void visit( To to ) {
        visitChildren(to);
    }

    public void visit( From from ) {
        visitChildren(from);
    }

    public void visit( LinkContainer container ) {
        visitChildren(container);
    }

    public void visit( Link link ) {
        visitChildren(link);
    }

    public void visit( Copy copy ) {
        visitChildren(copy);
    }

    public void visit( CatchAll holder ) {
        visitChildren(holder);
    }

//    public void visit( BooleanExpr expr ) {
//        visitChildren(expr);
//    }
//
//    public void visit( Branches branches ) {
//        visitChildren(branches);
//    }

    public void visit( CompletionCondition condition ) {
        visitChildren(condition);
    }

//    public void visit( Condition condition ) {
//        visitChildren(condition);
//    }
//
//    public void visit( DeadlineExpression expression ) {
//        visitChildren(expression);
//    }

    public void visit( Documentation documentation ) {
        visitChildren(documentation);
    }

    public void visit( Else els ) {
        visitChildren(els);
    }

    public void visit( ElseIf elseIf ) {
        visitChildren(elseIf);
    }

    public void visit( ExtensibleAssign assign ) {
        visitChildren(assign);
    }

    public void visit( ExtensionActivity activity ) {
        visitChildren(activity);
    }

//    public void visit( ToPart toPart ) {
//        visitChildren(toPart);
//    }

    public void visit( TerminationHandler handler ) {
        visitChildren(handler);
    }

    public void visit( TargetContainer container ) {
        visitChildren(container);
    }

//    public void visit( StartCounterValue value ) {
//        visitChildren(value);
//    }

    public void visit( SourceContainer container ) {
        visitChildren(container);
    }

//    public void visit( RepeatEvery repeatEvery ) {
//        visitChildren(repeatEvery);
//    }

    public void visit( OnEvent event ) {
        visitChildren(event);
    }

    public void visit( OnAlarmPick alarmPick ) {
        visitChildren(alarmPick);
    }

    public void visit( OnAlarmEvent alarmEvent ) {
        visitChildren(alarmEvent);
    }

    public void visit( ExtensionContainer container ) {
        visitChildren(container);
    }

    public void visit( Extension extension ) {
        visitChildren(extension);
    }

//    public void visit( FinalCounterValue value ) {
//        visitChildren(value);
//    }

    public void visit( Literal literal ) {
        visitChildren(literal);
    }

    public void visit( Import imp ) {
        visitChildren(imp);
    }

//    public void visit( FromPart fromPart ) {
//        visitChildren(fromPart);
//    }
//
//    public void visit( For fo ) {
//        visitChildren(fo);
//    }

    public void visit( MessageExchangeContainer container ) {
        visitChildren(container);
    }

    public void visit( MessageExchange exchange ) {
        visitChildren(exchange);
    }

    public void visit( ServiceRef ref ) {
        visitChildren(ref);
    }

//    public void visit( ExtensionEntity entity ) {
//        visitChildren(entity);
//    }
    
    public void visit( ToPartContainer toPartContainer ) {
        visitChildren(toPartContainer);
    }

    public void visit( FromPartContainer fromPartContainer ) {
        visitChildren(fromPartContainer);
    }
    
    public void visit( Query query ) {
        visitChildren(query);
    }

}
