/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/**
 *
 */
package org.netbeans.modules.bpel.model.api;

/**
 * @author ads
 *         <p>
 *         Java class for tExtensions complex type.
 *         <p>
 *         The following schema fragment specifies the expected content
 *         contained within this class.
 *
 * <pre>
 *   &lt;xsd:element name="extensions" type="tExtensions"/>
 *   &lt;xsd:complexType name="tExtensions">
 *       &lt;xsd:complexContent>
 *           &lt;xsd:extension base="tExtensibleElements">
 *               &lt;xsd:sequence>
 *                   &lt;xsd:element ref="extension" minOccurs="1" maxOccurs="unbounded"/>
 *               &lt;/xsd:sequence>
 *           &lt;/xsd:extension>
 *       &lt;/xsd:complexContent>
 *   &lt;/xsd:complexType>
 * </pre>
 */
public interface ExtensionContainer extends ExtensibleElements {

    /**
     * @return Children array of Extensions.
     */
    Extension[] getExtensions();

    /**
     * Returns <code>i</code>-th Extension child element.
     * 
     * @param i
     *            Index in Extensions children array.
     * @return <code>i</code>-th child Extension.
     */
    Extension getExtension( int i );

    /**
     * Removes <code>i</code>-th Extension child element.
     * 
     * @param i
     *            Index in Extensions children array.
     */
    void removeExtension( int i );

    /**
     * Add new Extension element to the end Extensions children array.
     * 
     * @param extension New Extension element. 
     */
    void addExtension( Extension extension );

    /**
     * Set New Extension element to the <code>i</code>-th position.
     * 
     * @param extension
     *            New Extension element.
     * @param i
     *            Index in Extensions children array.
     */
    void setExtension( Extension extension, int i );

    /**
     * Insert New Extension element to the <code>i</code>-th position.
     * 
     * @param extension
     *            New Extension element.
     * @param i
     *            Index in Extensions children array.
     */
    void insertExtension( Extension extension, int i );

    /**
     * Set new children array of Extensions.
     * 
     * @param extensions New array of extansions chldren. 
     */
    void setExtensions( Extension[] extensions );

    /**
     * @return size of children array of Extensions.
     */
    int sizeOfExtensions();
}
