/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */


package org.netbeans.modules.cnd.repository.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.repository.api.Repository;
import org.netbeans.modules.cnd.repository.disk.DiskRepositoryManager;
import org.netbeans.modules.cnd.repository.disk.StorageAllocator;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryListener;
import org.netbeans.modules.cnd.repository.testbench.Stats;
import org.netbeans.modules.cnd.repository.util.SoftHashMap;

/**
 * not thread safe repository, sync should be done in derived class
 * @author Sergey Grinev
 */
public abstract class SoftRefRepository implements Repository {
    
    private final Repository diskRepository;
    private final Map<Key, Persistent> sfMap;
    private       Map<Key, Persistent> monitoredKeys;

    protected SoftRefRepository() {
        sfMap = new SoftHashMap<Key, Persistent>();
        diskRepository = DiskRepositoryManager.getInstance();
        if (Stats.rememberKeys) {
            monitoredKeys = new HashMap<Key, Persistent>();
        }
    }
    
    public void hang(Key id, Persistent obj) {
        put(id, obj);
    }
   
    public void put(final Key key, final Persistent obj) {
        if (Stats.verbosePut) {
            System.err.println("Writing key: " + key);
        }
        
        sfMap.put(key, obj);
        if (key.getPersistentFactory().canWrite(obj)) {
            diskRepository.put(key, obj);
            
            if (Stats.rememberKeys) {
                monitoredKeys.put(key, obj);
            }
            
            if (Stats.validatePut) {
                Persistent p = null;
                p = diskRepository.get(key);
                System.err.println("Validating key " + key);
                
                if (p==null) {
                    System.err.println("failed");
                    System.err.println("put: " + obj);
                    System.err.println("got: null" );
                }
            }
        }
        
        ++Stats.debugPut;
    }

    public Persistent tryGet(Key key) {
	return sfMap.get(key);
    }
    
    public Persistent get(Key key) {
        Persistent data = sfMap.get(key);
        if (data == null)
        {
            if (Stats.verbosePut)
                System.err.println("Read from disk: " + key + " - NULL");

            data = diskRepository.get(key);
            
            if (data!=null) {
		sfMap.put(key, data);
                ++Stats.debugReadFromFile;
            } else {
                ++Stats.debugNotFound;
                Stats.log("reading '" + key + "' failed"); //NOI18N
                if (Stats.rememberKeys) {
                    Persistent p = monitoredKeys.get(key);
                    if (p == null) {
                        System.err.println("Such key never were put into repository");
                    } else {
                        System.err.println("Object was lost: " + p );
                    }
                }
            }
        }
        else
        {
            ++Stats.debugGot;
            //System.out.println("get [" + debugGot + "]:" + key); //NOI18N
        }
        return data;
    }

    public void remove(Key key) {
        if (Stats.verbosePut) System.err.println("removing " + key);
        sfMap.remove(key);
        diskRepository.remove(key);
    }

    public void debugClear() {
        // debug method to ensure our debug routines 
        // wouldn't start read prior to last write
        diskRepository.debugClear();
        sfMap.clear();
    }
    
    public void shutdown() {
        diskRepository.shutdown();
    }

    public void openUnit(String unitName) {
	// do nothing
    }
    
    public void closeUnit(String unitName, boolean cleanRepository, Set<String> requiredUnits) {
        Set<Key> keys = new HashSet<Key>(sfMap.keySet());
        for (Key key : keys) {
            if (unitName.equals(key.getUnit())) {
                sfMap.remove(key);
            }
        }
        diskRepository.closeUnit(unitName, cleanRepository, null);
    }
    
    public void removeUnit(String unitName) {
    }

    protected int size() {
        return sfMap.size();
    }
   
    public void cleanCaches() {
        StorageAllocator.getInstance().cleanRepositoryCaches();
    }    
    
    public void registerRepositoryListener(RepositoryListener aListener) {
        // do nothing
    }

    public void unregisterRepositoryListener(RepositoryListener aListener) {
        // do nothing
    }
    
    public void startup(int version) {
        // do nothing
    }
}
