/*
* Copyright 2005 Sun Microsystems, Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* - Redistributions of source code must retain the above copyright
*   notice, this list of conditions and the following disclaimer.
*
* - Redistribution in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in
*   the documentation and/or other materials provided with the
*   distribution.
*
* Neither the name of Sun Microsystems, Inc. or the names of
* contributors may be used to endorse or promote products derived
* from this software without specific prior written permission.
*
* This software is provided "AS IS," without a warranty of any
* kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
* WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
* EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
* OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
* FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
* PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
* LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
* EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
* You acknowledge that Software is not designed, licensed or intended
* for use in the design, construction, operation or maintenance of
* any nuclear facility.
*/

package com.sun.j2ee.blueprints.opc.invoice;

import java.util.*;
import java.text.*;
import java.io.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;
import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.stream.*;

public class Invoice implements Serializable {

    protected String invoiceId;
    protected String opcPoId;
    protected String supplierId;
    protected String status;

    // Constructor
    public Invoice() {}

    public Invoice(String invoiceId, String opcPoId, String supplier,
       String status) {
  this.invoiceId = invoiceId;
  this.opcPoId = opcPoId;
  this.supplierId = supplier;
  this.status = status;
    }

    // getter methods
    public String getInvoiceId() {
  return invoiceId;
    }

    public String getOpcPoId() {
  return opcPoId;
    }

    public String getSupplierId() {
  return supplierId;
    }

    public String getStatus() {
  return status;
    }

    // setter methods
    public void setInvoiceId(String invoiceId) {
  this.invoiceId = invoiceId;
    }

    public void setOpcPoId(String id) {
  this.opcPoId = id;
    }

    public void setSupplierId(String id) {
  this.supplierId = id;
    }

    public void setStatus(String stat) {
  this.status = stat;
    }

    //XML deserialization methods
  
    public static Invoice fromXML(String invDoc) throws XMLException {
  Invoice invObj = null;
  try { 
          
      InputSource source = new InputSource(new StringReader(invDoc));
      DocumentBuilderFactory docBuilderFactory = 
    DocumentBuilderFactory.newInstance();
      docBuilderFactory.setNamespaceAware(true);
      DocumentBuilder docBuilder = 
    docBuilderFactory.newDocumentBuilder();

      //parse the source doc and extract details
      Document doc = docBuilder.parse(source);   
      Element elem = (Element)doc.getDocumentElement().getFirstChild();
      invObj = new Invoice();
      invObj.setInvoiceId(((Text)(elem.getFirstChild())).getData());
      elem =  getNextSibling(elem);
      invObj.setOpcPoId(((Text)(elem.getFirstChild())).getData());
      elem =  getNextSibling(elem);
      invObj.setSupplierId(((Text)(elem.getFirstChild())).getData());
      elem = getNextSibling(elem); 
      invObj.setStatus(((Text)(elem.getFirstChild())).getData());
  } catch(Exception exe){
      throw new XMLException("Invoice XML Exception");
  }
  return invObj;   
    }

    public static Element getNextSibling(Element elem) {
  for(Node sib=elem.getNextSibling(); sib!=null; 
      sib=sib.getNextSibling()){
      if(sib.getNodeType() == Node.ELEMENT_NODE){
    return (Element) sib;
      }            
  }
  return null;     
    }
}
