/*
* Copyright 2005 Sun Microsystems, Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* - Redistributions of source code must retain the above copyright
*   notice, this list of conditions and the following disclaimer.
*
* - Redistribution in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in
*   the documentation and/or other materials provided with the
*   distribution.
*
* Neither the name of Sun Microsystems, Inc. or the names of
* contributors may be used to endorse or promote products derived
* from this software without specific prior written permission.
*
* This software is provided "AS IS," without a warranty of any
* kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
* WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
* EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
* OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
* FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
* PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
* LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
* EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
* You acknowledge that Software is not designed, licensed or intended
* for use in the design, construction, operation or maintenance of
* any nuclear facility.
*/

package com.sun.j2ee.blueprints.consumerwebsite;

import com.sun.j2ee.blueprints.waf.controller.web.util.WebKeys;
/**
 * This interface contains all the keys that are used to
 * store data in the different scopes of web-tier. These
 * values are the same as those used in the JSP
 * pages (useBean tags).
 */
public class AdventureKeys extends WebKeys {

    private AdventureKeys() {} //prevent instanciation
    // JSP accessible web keys
    public static final String CART = "cart";
    public static final String CUSTOMER_BEAN = "customerBean";
    public static final String CHECKOUT_BEAN = "checkoutBean";
    public static final String CART_BEAN = "cartBean";
    public static final String MISSING_FORM_DATA_EXCEPTION_KEY = "missingFormData";
    public static final String SIGN_ON_TEMP_USERNAME = "com.sun.j2ee.blueprints.adventure.SIGN_ON_TEMP_USERNAME";
    public static final String SIGN_ON_TEMP_PASSWORD = "com.sun.j2ee.blueprints.adventure.SIGN_ON_TEMP_PASSWORD";
    public static final String SIGN_ON_FACADE = "com.sun.j2ee.blueprints.adventure.SIGN_ON_FACADE";
    public static final String CUSTOMER_FACADE = "com.sun.j2ee.blueprints.adventure.CUSTOMER_FACADE";
    public static final String CATALOG_FACADE = "com.sun.j2ee.blueprints.adventure.CATALOG_FACADE";
    
    // internal keys
    public static final String PO_SERVICE = 
         "java:comp/env/service/OpcPurchaseOrderService";
}

