/*
* Copyright 2005 Sun Microsystems, Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* - Redistributions of source code must retain the above copyright
*   notice, this list of conditions and the following disclaimer.
*
* - Redistribution in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in
*   the documentation and/or other materials provided with the
*   distribution.
*
* Neither the name of Sun Microsystems, Inc. or the names of
* contributors may be used to endorse or promote products derived
* from this software without specific prior written permission.
*
* This software is provided "AS IS," without a warranty of any
* kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
* WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
* EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
* OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
* FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
* PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
* LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
* EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
* You acknowledge that Software is not designed, licensed or intended
* for use in the design, construction, operation or maintenance of
* any nuclear facility.
*/

package com.sun.j2ee.blueprints.activitysupplier.purchaseorder.ejb;

import javax.ejb.*;
import java.util.*;

import com.sun.j2ee.blueprints.activitysupplier.powebservice.*;
import com.sun.j2ee.blueprints.activitysupplier.*;
import com.sun.j2ee.blueprints.servicelocator.*;
import com.sun.j2ee.blueprints.servicelocator.ejb.*;

/**
 * Implementation class for the  ActivityPurchaseOrderBean .
 * ActivityPurchaseOrderBean is a CMP Entity Bean representing
 * a purchase order . It has a  1:MANY  relationship with 
 * ActivityDetailsBean
 **/

public abstract class ActivityPurchaseOrderBean implements EntityBean {

    private EntityContext entityContext = null;

    public String ejbCreate(ActivityOrder po) throws CreateException {
  setPoId(po.getOrderId());
  return null;
    }

    public void ejbPostCreate(ActivityOrder po) throws CreateException {

  try {
      ServiceLocator sl = new ServiceLocator();
     
      //set activities
      if(po != null){
    ActivityDetailsLocalHome alh = (ActivityDetailsLocalHome)
        sl.getLocalHome(JNDINames.ACTIVITY_DETAILS_EJB);
    ArrayList activities = po.getActivities();      
    for(int i=0; i < activities.size(); i++) {
        ActivityDetails act = (ActivityDetails) activities.get(i);
        ActivityDetailsLocal al = (ActivityDetailsLocal) 
      alh.create(act.getActivityId(), act.getStartDate(),
           act.getEndDate(), act.getHeadCount());
        addActivity(al);
    }
      }
  } catch (ServiceLocatorException se) {
      throw new CreateException("Exception saving Activity PO:" +
              se.getMessage());
  }
    }
    
    //getters and setters for CMP  fields
    public abstract void setPoId(String poId);

    public abstract String getPoId();
    
    public abstract void setActivities(Collection activities);

    public abstract Collection getActivities();

    public void addActivity(ActivityDetailsLocal activity) {
  getActivities().add(activity);
    }

    public void ejbRemove() throws RemoveException {}

    public void ejbLoad() {}

    public void ejbStore() {}

    public void ejbActivate() {}

    public void ejbPassivate() {}

    public void unsetEntityContext() {
  this.entityContext = null;
    }

    public void setEntityContext(EntityContext entityContext) {
  this.entityContext = entityContext;
    }
}
