/*
* Copyright 2005 Sun Microsystems, Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* - Redistributions of source code must retain the above copyright
*   notice, this list of conditions and the following disclaimer.
*
* - Redistribution in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in
*   the documentation and/or other materials provided with the
*   distribution.
*
* Neither the name of Sun Microsystems, Inc. or the names of
* contributors may be used to endorse or promote products derived
* from this software without specific prior written permission.
*
* This software is provided "AS IS," without a warranty of any
* kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
* WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
* EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
* OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
* FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
* PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
* LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
* EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
* You acknowledge that Software is not designed, licensed or intended
* for use in the design, construction, operation or maintenance of
* any nuclear facility.
*/

package com.sun.j2ee.blueprints.activitysupplier.powebservice;

import javax.ejb.*;
import java.rmi.*;
import javax.jms.*;
import com.sun.j2ee.blueprints.activitysupplier.JNDINames;
import com.sun.j2ee.blueprints.servicelocator.*;
import com.sun.j2ee.blueprints.servicelocator.ejb.*;

/**
 *  This class is the entry point for purchase orders submitted 
 *  by OPC to the activity suppliers;
 */
public class ActivityPOEndpointBean implements SessionBean {

    private SessionContext sc;
 
    public ActivityPOEndpointBean(){}
    
    public void ejbCreate() throws CreateException {}

    /**
     * Receive an order, preprocess the request, submit request to workflow
     * and return the order id so that the caller can have a correlation id
     * for the order
     */
    public String submitActivityReservationDetails(String xmlPO)
         throws InvalidOrderException, OrderSubmissionException,
                                                   RemoteException {

  // Do Interaction layer processing
  ActivityOrder order = preProcessInput(xmlPO);

  // Submit request thro JMS Queue
  submitRequest(order);

  // Return reference id - dummy ID for now
  return("ACT1234");
    }

    private ActivityOrder preProcessInput(String po)
                        throws InvalidOrderException {
  // XML doc should be ideally validated against its schema here;
  // Similar scenario already shown in OPC module;
  // Here it is skipped in this sample - we will convert doc to obj
  return(ActivityOrder.fromXML(po));
    }

    private void submitRequest(ActivityOrder act)
                        throws OrderSubmissionException {

  ConnectionFactory jmsConnectionFactory = null;
  Destination jmsDest = null;
  Connection jmsConnection = null;
  Session jmsSession = null;
  MessageProducer jmsSender = null;

  try {
      ServiceLocator sl = new ServiceLocator();
      jmsConnectionFactory = (ConnectionFactory)
      sl.getJMSConnectionFactory(JNDINames.ACT_QUEUECONNECTIONFACTORY);
      jmsDest = sl.getJMSDestination(JNDINames.ACT_QUEUE);
      jmsConnection = jmsConnectionFactory.createConnection();
      jmsSession = jmsConnection.createSession(true,
        Session.AUTO_ACKNOWLEDGE);
      jmsSender = jmsSession.createProducer(jmsDest);

      ObjectMessage message = jmsSession.createObjectMessage();
      message.setObject(act);
      jmsSender.send(message);
  } catch (ServiceLocatorException se) {
      throw new OrderSubmissionException("Error while sending a message:"
            + se.getMessage());
  } catch (JMSException e) {
      throw new OrderSubmissionException("Error while sending a message:"
            + e.getMessage());
  } finally {
      // close all JMS resources
      if (jmsSender != null) {
    try {
        jmsSender.close();
    } catch (JMSException e) {
        throw new OrderSubmissionException("Error sender close");
    }
      }
      if (jmsSession != null) {
    try {
        jmsSession.close();
    } catch (JMSException e) {
        throw new OrderSubmissionException("Error session close");
    }
      }
      if (jmsConnection != null) {
    try {
        jmsConnection.close();
    } catch (JMSException e) {
        throw new OrderSubmissionException("Error Connection close");
    }
      }
  }
    }

    public void setSessionContext(SessionContext sc) {
        this.sc = sc;
    }
    
    public void ejbRemove() throws RemoteException {}
    
    //empty for Stateless EJBs
    public void ejbActivate() {}

    //empty for Stateless EJBs
    public void ejbPassivate() {}
}
