/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.JGoControl;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoText;
import com.nwoods.jgo.JGoView;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.text.JTextComponent;

public class JGoTextEdit
extends JGoControl {
    private boolean myMultiline;
    private String myOriginalText;
    private int myStyle;
    private JGoText myTextObject;

    public JGoTextEdit() {
        this.myOriginalText = "";
        this.myMultiline = false;
        this.myTextObject = null;
    }

    public JGoTextEdit(Point location, Dimension size, String origText, boolean multiline, JGoText obj) {
        super(location, size);
        this.myOriginalText = origText;
        this.myTextObject = obj;
        this.myMultiline = multiline;
    }

    public JGoTextEdit(Rectangle rect, String origText, boolean multiline, JGoText obj) {
        super(rect);
        this.myOriginalText = origText;
        this.myTextObject = obj;
        this.myMultiline = multiline;
    }

    public JGoObject copyObject(JGoCopyEnvironment env) {
        JGoTextEdit newobj = (JGoTextEdit)super.copyObject(env);
        if (newobj != null) {
            newobj.myMultiline = this.myMultiline;
            newobj.myOriginalText = this.myOriginalText;
            newobj.myTextObject = (JGoText)env.get(this.myTextObject);
            newobj.myStyle = this.myStyle;
        }
        return newobj;
    }

    public JGoText getTextObject() {
        return this.myTextObject;
    }

    public void setTextObject(JGoText obj) {
        this.myTextObject = obj;
    }

    public JComponent createComponent(JGoView view) {
        JTextComponent textc = this.myMultiline ? new JGoJTextArea(this.myOriginalText, this, view) : new JGoJTextField(this.myOriginalText, this, view);
        return textc;
    }

    public void paint(Graphics2D g, JGoView view) {
        JComponent comp = this.getComponent(view);
        if (comp != null) {
            Font oldfont = this.getTextObject().getFont();
            if (Math.abs(view.getScale() - 1.0) >= 0.01) {
                String facename = oldfont.getFontName();
                int size = oldfont.getSize();
                int style = oldfont.getStyle();
                oldfont = new Font(facename, style, (int)((double)size * view.getScale()));
            }
            comp.setFont(oldfont);
            Rectangle rect = view.getTempRectangle();
            Rectangle b = this.getBoundingRect();
            rect.x = b.x - 4;
            rect.y = b.y - 1;
            rect.width = b.width + 12;
            rect.height = b.height + 4;
            view.convertDocToView(rect);
            comp.setBounds(rect);
            comp.repaint();
        }
    }

    public boolean setEditedText(String newtext, JGoView view) {
        return this.getTextObject().doEdit(view, this.getTextObject().getText(), newtext);
    }

    public void doEndEdit() {
        this.getTextObject().doEndEdit();
    }

    class JGoJTextArea
    extends JTextArea {
        JGoTextEdit myTextEdit;
        JGoView myView;

        JGoJTextArea(String s, JGoTextEdit obj, JGoView view) {
            super(s);
            this.myTextEdit = obj;
            this.myView = view;
            this.setBorder(new CompoundBorder(new EtchedBorder(1), new BevelBorder(1)));
            this.enableEvents(12L);
            this.setLineWrap(this.myTextEdit.getTextObject().isWrapping());
        }

        protected void processKeyEvent(KeyEvent e) {
            JGoTextEdit editor = this.myTextEdit;
            if (e.getID() == 401 && e.getKeyCode() == 10 && editor != null && this.getLineWrap()) {
                this.myTextEdit = null;
                if (editor.setEditedText(this.getText(), this.myView)) {
                    editor.doEndEdit();
                } else {
                    this.myTextEdit = editor;
                }
                return;
            }
            if (e.getID() == 401 && e.getKeyCode() == 27 && editor != null) {
                this.myTextEdit = null;
                editor.doEndEdit();
                return;
            }
            super.processKeyEvent(e);
        }

        protected void processFocusEvent(FocusEvent e) {
            JGoTextEdit editor = this.myTextEdit;
            if (e.getID() == 1005 && editor != null) {
                this.myTextEdit = null;
                if (editor.setEditedText(this.getText(), this.myView)) {
                    editor.doEndEdit();
                } else {
                    this.myTextEdit = editor;
                }
            }
            super.processFocusEvent(e);
        }

        public void scrollRectToVisible(Rectangle contentRect) {
        }
    }

    class JGoJTextField
    extends JTextField {
        JGoTextEdit myTextEdit;
        JGoView myView;

        JGoJTextField(String s, JGoTextEdit obj, JGoView view) {
            super(s);
            this.myTextEdit = obj;
            this.myView = view;
            this.enableEvents(12L);
            switch (obj.getTextObject().getAlignment()) {
                case 1: {
                    this.setHorizontalAlignment(2);
                    break;
                }
                case 2: {
                    this.setHorizontalAlignment(0);
                    break;
                }
                case 3: {
                    this.setHorizontalAlignment(4);
                }
            }
        }

        protected void processKeyEvent(KeyEvent e) {
            JGoTextEdit editor = this.myTextEdit;
            if (e.getID() == 401 && e.getKeyCode() == 10 && editor != null) {
                this.myTextEdit = null;
                if (editor.setEditedText(this.getText(), this.myView)) {
                    editor.doEndEdit();
                } else {
                    this.myTextEdit = editor;
                }
                return;
            }
            if (e.getID() == 401 && e.getKeyCode() == 27 && editor != null) {
                this.myTextEdit = null;
                editor.doEndEdit();
                return;
            }
            super.processKeyEvent(e);
        }

        protected void processFocusEvent(FocusEvent e) {
            JGoTextEdit editor = this.myTextEdit;
            if (e.getID() == 1005 && editor != null) {
                this.myTextEdit = null;
                if (editor.setEditedText(this.getText(), this.myView)) {
                    editor.doEndEdit();
                } else {
                    this.myTextEdit = editor;
                }
            }
            super.processFocusEvent(e);
        }
    }
}

