/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.usm;

import com.sun.jdmk.defaults.Utils;
import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpEncryptionPair;
import com.sun.management.internal.snmp.SnmpTools;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.usm.SnmpUsmAlgorithmImpl;
import com.sun.management.snmp.usm.SnmpUsmException;
import com.sun.management.snmp.usm.SnmpUsmKey;
import com.sun.management.snmp.usm.SnmpUsmPrivAlgorithm;
import com.sun.management.snmp.usm.SnmpUsmPrivException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;

public class SnmpUsmDesAlgorithm
extends SnmpUsmAlgorithmImpl
implements SnmpUsmPrivAlgorithm {
    private long random = -1L;
    private String properties_decrypt = null;
    private String properties_encrypt = null;
    public static final String DES_PRIV = "usmDESPrivProtocol";
    private Cipher cipher_encrypt = null;
    private Cipher cipher_decrypt = null;
    private SnmpEngine engine = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpUsmDesAlgorithm");
    String dbgTag = "SnmpUsmDesAlgorithm";

    private synchronized long getRandom() {
        ++this.random;
        return this.random;
    }

    public SnmpUsmDesAlgorithm(SnmpEngine snmpEngine) throws SnmpUsmException {
        super(DES_PRIV);
        this.engine = snmpEngine;
        this.random = System.currentTimeMillis();
        this.properties_encrypt = "DES/CBC/NoPadding";
        this.properties_decrypt = "DES/CBC/NoPadding";
        try {
            this.cipher_encrypt = Cipher.getInstance(this.properties_encrypt);
            this.cipher_decrypt = Cipher.getInstance(this.properties_decrypt);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            throw new SnmpUsmPrivException("NoSuchAlgorithmException");
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            noSuchPaddingException.printStackTrace();
            throw new SnmpUsmPrivException("NoSuchPaddingException");
        }
    }

    public SnmpUsmDesAlgorithm(SnmpEngine snmpEngine, String string, String string2) throws SnmpUsmException {
        super(DES_PRIV);
        this.properties_encrypt = string;
        this.properties_decrypt = string2;
        this.engine = snmpEngine;
        try {
            this.cipher_encrypt = Cipher.getInstance(string);
            this.cipher_decrypt = Cipher.getInstance(string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (logger.finestOn()) {
                logger.finest("SnmpUsmDesAlgorithm", "No such algorithm: " + noSuchAlgorithmException);
            }
            throw new SnmpUsmPrivException("No such algorithm: " + noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            if (logger.finestOn()) {
                logger.finest("SnmpUsmDesAlgorithm", "No such padding: " + noSuchPaddingException);
            }
            throw new SnmpUsmPrivException("No such padding: " + noSuchPaddingException);
        }
    }

    public int getKeySize() {
        return 16;
    }

    public int getDeltaSize() {
        return 16;
    }

    public String getOid() {
        return "1.3.6.1.6.3.10.1.2.2";
    }

    private byte[] genDesKey(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        byArray2[7] = 0;
        for (int i = 6; i >= 0; --i) {
            int n = 6 - i;
            byArray2[i] = byArray[i + 1];
            byArray2[i] = (byte)(byArray2[i] >>> 1);
            byArray2[i] = (byte)(byArray2[i] & 0x7F);
            for (int j = n; j > 0; --j) {
                byte by = (byte)(byArray2[i] & 1);
                byArray2[i] = (byte)(byArray2[i] >>> 1);
                byArray2[i] = (byte)(byArray2[i] & 0x7F);
                by = (byte)(by << 8 - j);
                byArray2[i + 1] = (byte)(byArray2[i + 1] | by);
            }
        }
        byArray2[0] = (byte)(byArray2[0] | byArray[0] & 0xFE);
        return byArray2;
    }

    public synchronized SnmpEncryptionPair encrypt(byte[] byArray, byte[] byArray2, int n) throws SnmpUsmException {
        int n2 = n % 8;
        int n3 = 0;
        byte[] byArray3 = byArray2;
        int n4 = n;
        if (n2 != 0) {
            n3 = 8 - n2;
            if (logger.finestOn()) {
                logger.finest("encrypt", " Padding, must add : " + n3);
            }
            byArray3 = new byte[n + n3];
            n4 = byArray3.length;
            for (int i = 0; i < n; ++i) {
                byArray3[i] = byArray2[i];
            }
        }
        if (logger.finestOn()) {
            logger.finest("encrypt", "encrypt using :\t" + this.properties_encrypt + "\tkey length :" + byArray.length + "\tkey :" + SnmpTools.binary2ascii(byArray) + "\tdata length :" + n4 + "\tstart time:" + System.currentTimeMillis());
        }
        SnmpEncryptionPair snmpEncryptionPair = new SnmpEncryptionPair();
        int n5 = this.engine.getEngineBoots();
        long l = this.getRandom();
        if (byArray.length != 16) {
            throw new SnmpUsmPrivException("Invalid key size :" + byArray.length);
        }
        if (logger.finestOn()) {
            logger.finest("encrypt", "encrypt using :\t" + this.properties_encrypt + "\tGen key start time:" + System.currentTimeMillis());
        }
        DESKeySpec dESKeySpec = null;
        try {
            dESKeySpec = new DESKeySpec(byArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            if (logger.finestOn()) {
                logger.finest("decrypt :", "Invalid key: " + invalidKeyException);
            }
            throw new SnmpUsmPrivException("Invalid key: " + invalidKeyException);
        }
        if (logger.finestOn()) {
            logger.finest("encrypt", "encrypt using :\t" + this.properties_encrypt);
        }
        byte[] byArray4 = new byte[8];
        if (logger.finestOn()) {
            logger.finest("encrypt", "encrypt using :\t" + this.properties_encrypt + "\tGen key start time:" + System.currentTimeMillis());
        }
        byte[] byArray5 = new byte[]{(byte)(n5 & 0xFF000000), (byte)(n5 & 0xFF0000), (byte)(n5 & 0xFF00), (byte)(n5 & 0xFF), (byte)(l & 0xFFFFFFFFFF000000L), (byte)(l & 0xFF0000L), (byte)(l & 0xFF00L), (byte)(l & 0xFFL)};
        for (int i = 0; i < 8; ++i) {
            byArray4[i] = byArray[i + 8];
            int n6 = i;
            byArray4[n6] = (byte)(byArray4[n6] ^ byArray5[i]);
        }
        if (logger.finestOn()) {
            logger.finest("encrypt", "encrypt using :\t" + this.properties_encrypt + "\tSalt end time:" + System.currentTimeMillis());
        }
        snmpEncryptionPair.parameters = byArray5;
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray4);
        try {
            this.cipher_encrypt.init(1, (Key)new SnmpUsmKey(dESKeySpec.getKey()), ivParameterSpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SnmpUsmPrivException("Invalid key: " + invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            if (logger.finestOn()) {
                logger.finest("encrypt :", "Invalid algorithm parameter: " + invalidAlgorithmParameterException);
            }
            throw new SnmpUsmPrivException("Invalid algorithm parameter: " + invalidAlgorithmParameterException);
        }
        try {
            snmpEncryptionPair.encryptedData = this.cipher_encrypt.doFinal(byArray3, 0, n4);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            if (logger.finestOn()) {
                logger.finest("encrypt :", "Illegal block size: " + illegalBlockSizeException);
            }
            throw new SnmpUsmPrivException("Illegal block size: " + illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            if (logger.finestOn()) {
                logger.finest("encrypt :", "Bad padding: " + badPaddingException);
            }
            throw new SnmpUsmPrivException("Bad padding: " + badPaddingException);
        }
        catch (Exception exception) {
            if (logger.finestOn()) {
                logger.finest("encrypt :", "Unexpected exception: " + exception);
            }
            SnmpUsmPrivException snmpUsmPrivException = new SnmpUsmPrivException("Unexpected exception: " + exception);
            Utils.initCause(snmpUsmPrivException, exception);
            throw snmpUsmPrivException;
        }
        if (logger.finestOn()) {
            logger.finest("encrypt", "Over params length :" + snmpEncryptionPair.parameters.length + " encrypted data length :" + snmpEncryptionPair.encryptedData.length);
        }
        if (logger.finestOn()) {
            logger.finest("encrypt", "encrypt using :\t" + this.properties_encrypt + "\tENCRYPT end time:" + System.currentTimeMillis());
        }
        if (logger.finestOn()) {
            logger.finest("encrypt", "Encryption input :" + SnmpTools.binary2ascii(byArray3, n4));
            logger.finest("encrypt", "Encryption output :" + SnmpTools.binary2ascii(snmpEncryptionPair.encryptedData));
        }
        return snmpEncryptionPair;
    }

    public synchronized byte[] decrypt(byte[] byArray, SnmpEncryptionPair snmpEncryptionPair) throws SnmpUsmException {
        Object object;
        if (logger.finestOn()) {
            logger.finest("decrypt", "decrypt using :\t" + this.properties_decrypt + "\tkey length :" + byArray.length + "\tdata length :" + snmpEncryptionPair.encryptedData.length + "\t priv parameters : " + SnmpTools.binary2ascii(snmpEncryptionPair.parameters));
        }
        if (snmpEncryptionPair.encryptedData == null) {
            if (logger.finestOn()) {
                logger.finest("decrypt :", "encrypted data is null, error.");
            }
            throw new SnmpUsmPrivException("Invalid encrypted data.");
        }
        int n = snmpEncryptionPair.encryptedData.length % 8;
        if (n != 0) {
            if (logger.finestOn()) {
                logger.finest("decrypt :", "encrypted data length is not OK, error.");
            }
            throw new SnmpUsmPrivException("Invalid encrypted data length.");
        }
        DESKeySpec dESKeySpec = null;
        byte[] byArray2 = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray2[i] = byArray[i + 8];
            int n2 = i;
            byArray2[n2] = (byte)(byArray2[n2] ^ snmpEncryptionPair.parameters[i]);
        }
        try {
            dESKeySpec = new DESKeySpec(byArray);
            object = new IvParameterSpec(byArray2);
            this.cipher_decrypt.init(2, (Key)new SnmpUsmKey(dESKeySpec.getKey()), (AlgorithmParameterSpec)object);
        }
        catch (InvalidKeyException invalidKeyException) {
            if (logger.finestOn()) {
                logger.finest("decrypt :", "Invalid key: " + invalidKeyException);
            }
            throw new SnmpUsmPrivException("Invalid key: " + invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            if (logger.finestOn()) {
                logger.finest("decrypt :", "Invalid algorithm parameter: " + invalidAlgorithmParameterException);
            }
            throw new SnmpUsmPrivException("Invalid algorithm parameter: " + invalidAlgorithmParameterException);
        }
        object = null;
        try {
            object = this.cipher_decrypt.doFinal(snmpEncryptionPair.encryptedData);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            if (logger.finestOn()) {
                logger.finest("decrypt :", "Illegal block size: " + illegalBlockSizeException);
            }
            throw new SnmpUsmPrivException("Illegal block size: " + illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            if (logger.finestOn()) {
                logger.finest("decrypt :", "Bad padding: " + badPaddingException);
            }
            throw new SnmpUsmPrivException("Bad padding: " + badPaddingException);
        }
        catch (Exception exception) {
            if (logger.finestOn()) {
                logger.finest("decrypt :", "Unexpected exception: " + exception);
            }
            SnmpUsmPrivException snmpUsmPrivException = new SnmpUsmPrivException("Unexpected Exception: " + exception);
            Utils.initCause(snmpUsmPrivException, exception);
            throw snmpUsmPrivException;
        }
        if (logger.finestOn()) {
            logger.finest("decrypt :", " Decryption input : " + SnmpTools.binary2ascii(snmpEncryptionPair.encryptedData));
            logger.finest("decrypt :", " Decryption output : " + SnmpTools.binary2ascii((byte[])object));
        }
        return object;
    }
}

