/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.mpm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpDecryptedPdu;
import com.sun.management.internal.snmp.SnmpIncomingResponse;
import com.sun.management.internal.snmp.SnmpSecurityCache;
import com.sun.management.internal.snmp.SnmpSecuritySubSystem;
import com.sun.management.snmp.SnmpMsg;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpPduFactory;
import com.sun.management.snmp.SnmpSecurityException;
import com.sun.management.snmp.SnmpSecurityParameters;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpUnknownSecModelException;
import com.sun.management.snmp.mpm.SnmpMsgTranslator;
import java.net.InetAddress;

class SnmpIncomingResponseImpl
implements SnmpIncomingResponse {
    SnmpMsg resp = null;
    SnmpSecuritySubSystem secureSubSys = null;
    SnmpMsgTranslator translator = null;
    SnmpSecurityParameters params = null;
    SnmpSecurityCache cache = null;
    SnmpPduFactory factory = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpIncomingResponseImpl");
    String dbgTag = "SnmpIncomingResponseImpl";

    public SnmpIncomingResponseImpl(SnmpSecuritySubSystem snmpSecuritySubSystem, SnmpPduFactory snmpPduFactory, SnmpMsg snmpMsg, SnmpMsgTranslator snmpMsgTranslator) {
        this.secureSubSys = snmpSecuritySubSystem;
        this.resp = snmpMsg;
        this.translator = snmpMsgTranslator;
        this.factory = snmpPduFactory;
    }

    public InetAddress getAddress() {
        return this.resp.address;
    }

    public int getPort() {
        return this.resp.port;
    }

    public void setSecurityCache(SnmpSecurityCache snmpSecurityCache) {
        this.cache = snmpSecurityCache;
    }

    public int getSecurityLevel() {
        return this.translator.getSecurityLevel(this.resp);
    }

    public int getSecurityModel() {
        return this.translator.getMsgSecurityModel(this.resp);
    }

    public byte[] getContextName() {
        return this.translator.getContextName(this.resp);
    }

    public SnmpSecurityParameters getSecurityParameters() {
        return this.params;
    }

    public int getRequestId(byte[] byArray) throws SnmpStatusException {
        return this.resp.getRequestId(byArray);
    }

    public SnmpMsg decodeMessage(byte[] byArray, int n, InetAddress inetAddress, int n2) throws SnmpStatusException, SnmpSecurityException {
        this.resp.address = inetAddress;
        this.resp.port = n2;
        this.resp.decodeMessage(byArray, n);
        SnmpDecryptedPdu snmpDecryptedPdu = new SnmpDecryptedPdu();
        try {
            this.params = this.secureSubSys.processIncomingResponse(this.cache, this.resp.version, this.translator.getMsgId(this.resp), this.translator.getMsgMaxSize(this.resp), this.translator.getMsgFlags(this.resp), this.translator.getMsgSecurityModel(this.resp), this.translator.getFlatSecurityParameters(this.resp), this.translator.getContextEngineId(this.resp), this.translator.getContextName(this.resp), this.resp.data, this.translator.getEncryptedPdu(this.resp), snmpDecryptedPdu);
            this.secureSubSys.releaseSecurityCache(this.translator.getMsgSecurityModel(this.resp), this.cache);
        }
        catch (SnmpUnknownSecModelException snmpUnknownSecModelException) {
            if (logger.finestOn()) {
                logger.finest("decodeMessage", snmpUnknownSecModelException.toString() + "\n Will fail in timeout!!!");
            }
            return null;
        }
        if (snmpDecryptedPdu.data != null) {
            this.resp.data = snmpDecryptedPdu.data;
            this.translator.setContextName(this.resp, snmpDecryptedPdu.contextName);
            this.translator.setContextEngineId(this.resp, snmpDecryptedPdu.contextEngineId);
        }
        return this.resp;
    }

    public SnmpPdu decodeSnmpPdu() throws SnmpStatusException {
        return this.factory.decodeSnmpPdu(this.resp);
    }

    public String printMessage() {
        return this.resp.printMessage();
    }
}

