/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.agent;

import com.sun.management.snmp.SnmpOid;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class SnmpIndex
implements Serializable {
    private static final long serialVersionUID = -8516937092825243248L;
    private Vector oids = new Vector();
    private int size = 0;

    public SnmpIndex(SnmpOid[] snmpOidArray) {
        this.size = snmpOidArray.length;
        for (int i = 0; i < this.size; ++i) {
            this.oids.addElement(snmpOidArray[i]);
        }
    }

    public SnmpIndex(SnmpOid snmpOid) {
        this.oids.addElement(snmpOid);
        this.size = 1;
    }

    public int getNbComponents() {
        return this.size;
    }

    public Vector getComponents() {
        return this.oids;
    }

    public boolean equals(SnmpIndex snmpIndex) {
        if (this.size != snmpIndex.getNbComponents()) {
            return false;
        }
        Vector vector = snmpIndex.getComponents();
        for (int i = 0; i < this.size; ++i) {
            SnmpOid snmpOid;
            SnmpOid snmpOid2 = (SnmpOid)this.oids.elementAt(i);
            if (snmpOid2.equals(snmpOid = (SnmpOid)vector.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public int compareTo(SnmpIndex snmpIndex) {
        int n = snmpIndex.getNbComponents();
        Vector vector = snmpIndex.getComponents();
        for (int i = 0; i < this.size; ++i) {
            SnmpOid snmpOid;
            if (i > n) {
                return 1;
            }
            SnmpOid snmpOid2 = (SnmpOid)this.oids.elementAt(i);
            int n2 = snmpOid2.compareTo(snmpOid = (SnmpOid)vector.elementAt(i));
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.oids.elements();
        while (enumeration.hasMoreElements()) {
            SnmpOid snmpOid = (SnmpOid)enumeration.nextElement();
            stringBuffer.append("//" + snmpOid.toString());
        }
        return stringBuffer.toString();
    }
}

