/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.internal.snmp;

import com.sun.jdmk.defaults.DefaultPaths;
import com.sun.jdmk.internal.BackupFileHandler;
import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpLcd;
import com.sun.management.snmp.SnmpEngineId;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;

public class SnmpJdmkLcd
extends SnmpLcd {
    String engineId = null;
    File file = null;
    int engineBoots = -1;
    private String header = "\n# #####APPENDED PROPERTY####\n";
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpJdmkLcd");
    String dbgTag = "SnmpJdmkLcd";

    public SnmpJdmkLcd(String string) throws IllegalArgumentException {
        this.handleSecurityFileLocation(string);
    }

    private void handleSecurityFileLocation(String string) throws IllegalArgumentException {
        String string2 = null;
        if (string == null) {
            string2 = System.getProperty("jdmk.security.file");
            if (string2 == null) {
                if (logger.finestOn()) {
                    logger.finest("constructor", "Security file not found. Use default one.");
                }
                string2 = DefaultPaths.getEtcDir("conf" + File.separator + "jdmk.security");
                this.file = new File(string2);
                if (!this.file.exists()) {
                    this.file = null;
                    if (logger.finerOn()) {
                        logger.finer("SnmpJdmkLcd", "The default file [" + string2 + "] doesn't exist.");
                    }
                    return;
                }
            } else {
                this.file = new File(string2);
                if (!this.file.exists() && logger.finerOn()) {
                    logger.finer("handleSecurityFileLocation", "The specified file [" + this.file + "] doesn't exist, no configuration loaded");
                    throw new IllegalArgumentException("The specified file [" + this.file + "] doesn't exist, no configuration loaded");
                }
            }
        } else {
            this.file = new File(string);
            if (!this.file.exists() && logger.finerOn()) {
                logger.finer("handleSecurityFileLocation", "The specified file [" + this.file + "] doesn't exist, no configuration loaded");
                throw new IllegalArgumentException("The specified file [" + this.file + "] doesn't exist, no configuration loaded");
            }
        }
    }

    File getFile() {
        return this.file;
    }

    public void storeEngineBoots(int n) {
        if (this.getFile() == null) {
            return;
        }
        String string = "localEngineBoots";
        this.flushProperty(string, String.valueOf(n));
    }

    public void storeEngineId(SnmpEngineId snmpEngineId) {
        if (this.getFile() == null) {
            return;
        }
        String string = "localEngineID";
        this.flushProperty(string, snmpEngineId.getReadableId() == null ? snmpEngineId.toString() : snmpEngineId.getReadableId());
    }

    public int getEngineBoots() {
        String string;
        if (this.getFile() == null) {
            return -1;
        }
        if (this.engineBoots == -1 && (string = this.getProperty("localEngineBoots")) != null) {
            this.engineBoots = Integer.parseInt(string);
        }
        return this.engineBoots;
    }

    public String getEngineId() {
        if (this.getFile() == null) {
            return null;
        }
        if (this.engineId == null) {
            this.engineId = this.getProperty("localEngineID");
        }
        return this.engineId;
    }

    private String getProperty(String string) {
        String string2 = null;
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        if (!this.file.exists()) {
            if (logger.finerOn()) {
                logger.finer("getProperty", "The specified file [" + this.file + "] doesn't exist, the property " + string + "] can't be loaded.");
            }
            return null;
        }
        try {
            fileReader = new FileReader(this.file);
            bufferedReader = new BufferedReader(fileReader);
        }
        catch (IOException iOException) {
            if (logger.finestOn()) {
                logger.finest("getProperty", "The specified file was not found, no configuration loaded");
            }
            return null;
        }
        try {
            string2 = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            if (logger.finerOn()) {
                logger.finer("getProperty", iOException.toString());
            }
            return null;
        }
        while (string2 != null) {
            try {
                if (string2.startsWith(string + "=")) {
                    bufferedReader.close();
                    int n = string2.indexOf("=");
                    if (n == string2.length() - 1) {
                        return null;
                    }
                    return string2.substring(n + 1);
                }
                string2 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                if (!logger.finestOn()) continue;
                logger.finest("getProperty", iOException);
            }
        }
        try {
            bufferedReader.close();
            fileReader.close();
        }
        catch (IOException iOException) {
            if (logger.finestOn()) {
                logger.finest("getProperty", iOException);
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void writeFile(File file, String string, String string2) throws Exception {
        block49: {
            Exception exception2222;
            InputStreamReader inputStreamReader;
            FileWriter fileWriter;
            BufferedReader bufferedReader;
            BufferedWriter bufferedWriter;
            block41: {
                block40: {
                    block39: {
                        block38: {
                            String string3;
                            String string4 = null;
                            boolean bl = false;
                            boolean bl2 = false;
                            bufferedWriter = null;
                            bufferedReader = null;
                            fileWriter = null;
                            inputStreamReader = null;
                            fileWriter = new FileWriter(this.file);
                            bufferedWriter = new BufferedWriter(fileWriter);
                            inputStreamReader = new FileReader(file);
                            bufferedReader = new BufferedReader(inputStreamReader);
                            string4 = bufferedReader.readLine();
                            while (string4 != null) {
                                string3 = string4;
                                if (!bl2 && string4.startsWith(string + "=")) {
                                    if (logger.finestOn()) {
                                        logger.finest("flushProperty", "Found property [" + string + "], new value [" + string2 + "]");
                                    }
                                    string3 = string + "=" + string2;
                                    bl2 = true;
                                }
                                bufferedWriter.write(string3, 0, string3.length());
                                bufferedWriter.newLine();
                                string4 = bufferedReader.readLine();
                            }
                            if (bl2) break block38;
                            string3 = string + "=" + string2;
                            if (logger.finestOn()) {
                                logger.finest("flushProperty", "Property not found!");
                            }
                            bufferedWriter.write(this.header, 0, this.header.length());
                            bufferedWriter.write(string3, 0, string3.length());
                        }
                        Object var13_13 = null;
                        if (bufferedWriter == null) break block39;
                        try {
                            bufferedWriter.close();
                        }
                        catch (Exception exception2222) {
                            if (!logger.finestOn()) break block39;
                            logger.finest("flushProperty", exception2222);
                        }
                    }
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Exception exception2222) {
                            if (!logger.finestOn()) break block40;
                            logger.finest("flushProperty", exception2222);
                        }
                    }
                }
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (Exception exception2222) {
                        if (!logger.finestOn()) break block41;
                        logger.finest("flushProperty", exception2222);
                    }
                }
            }
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (Exception exception2222) {
                    if (logger.finestOn()) {
                        logger.finest("flushProperty", exception2222);
                    }
                }
            }
            break block49;
            {
                catch (Exception exception3) {
                    Exception exception42222;
                    block44: {
                        block43: {
                            block42: {
                                if (logger.finestOn()) {
                                    logger.finest("flushProperty", exception3);
                                }
                                Object var13_14 = null;
                                if (bufferedWriter != null) {
                                    try {
                                        bufferedWriter.close();
                                    }
                                    catch (Exception exception42222) {
                                        if (!logger.finestOn()) break block42;
                                        logger.finest("flushProperty", exception42222);
                                    }
                                }
                            }
                            if (bufferedReader != null) {
                                try {
                                    bufferedReader.close();
                                }
                                catch (Exception exception42222) {
                                    if (!logger.finestOn()) break block43;
                                    logger.finest("flushProperty", exception42222);
                                }
                            }
                        }
                        if (inputStreamReader != null) {
                            try {
                                inputStreamReader.close();
                            }
                            catch (Exception exception42222) {
                                if (!logger.finestOn()) break block44;
                                logger.finest("flushProperty", exception42222);
                            }
                        }
                    }
                    if (fileWriter != null) {
                        try {
                            fileWriter.close();
                        }
                        catch (Exception exception42222) {
                            if (logger.finestOn()) {
                                logger.finest("flushProperty", exception42222);
                            }
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block48: {
                    Exception exception52222;
                    block47: {
                        block46: {
                            block45: {
                                Object var13_15 = null;
                                if (bufferedWriter != null) {
                                    try {
                                        bufferedWriter.close();
                                    }
                                    catch (Exception exception52222) {
                                        if (!logger.finestOn()) break block45;
                                        logger.finest("flushProperty", exception52222);
                                    }
                                }
                            }
                            if (bufferedReader != null) {
                                try {
                                    bufferedReader.close();
                                }
                                catch (Exception exception52222) {
                                    if (!logger.finestOn()) break block46;
                                    logger.finest("flushProperty", exception52222);
                                }
                            }
                        }
                        if (inputStreamReader != null) {
                            try {
                                inputStreamReader.close();
                            }
                            catch (Exception exception52222) {
                                if (!logger.finestOn()) break block47;
                                logger.finest("flushProperty", exception52222);
                            }
                        }
                    }
                    if (fileWriter != null) {
                        try {
                            fileWriter.close();
                        }
                        catch (Exception exception52222) {
                            if (!logger.finestOn()) break block48;
                            logger.finest("flushProperty", exception52222);
                        }
                    }
                }
                throw throwable;
            }
        }
    }

    private void resetFile() throws Exception {
        try {
            this.file.delete();
            this.file.createNewFile();
        }
        catch (Exception exception) {
            if (logger.finestOn()) {
                logger.finest("resetFile", exception);
            }
            if (logger.finestOn()) {
                logger.finest("resetFile", "File reset failed.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushProperty(String string, String string2) {
        File file = BackupFileHandler.createBackupFile(this.file, null);
        if (file == null) {
            if (logger.finestOn()) {
                logger.finest("flushProperty", "Unable to create backup file for " + this.file + "Property " + string + " not flushed");
            }
            return;
        }
        if (logger.finestOn()) {
            logger.finest("flushProperty", this.file + " backup file created : " + file + ".");
        }
        try {
            this.writeFile(file, string, string2);
        }
        catch (Exception exception) {
            if (logger.finestOn()) {
                logger.finest("resetFile", exception);
            }
            if (logger.finestOn()) {
                logger.finest("resetFile", "File reset failed.Check " + file + " file.");
            }
        }
        finally {
            BackupFileHandler.deleteBackupFile(file);
        }
    }
}

