/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.HttpBody;
import com.sun.jdmk.comm.MalformedHttpException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

abstract class HttpMessage {
    String httpVersion = null;
    static final String CRLF = "\r\n";
    static final String[] KNOWN_HEADERS = new String[]{"Content-Length", "Content-Type", "Date", "Connection", "WWW-Authenticate", "Authorization"};
    static final int CONTENT_LENGTH_HEADER = 0;
    static final int CONTENT_TYPE_HEADER = 1;
    static final int DATE_HEADER = 2;
    static final int CONNECTION_HEADER = 3;
    static final int WWW_AUTHENTICATE_HEADER = 4;
    static final int AUTHORIZATION_HEADER = 5;
    private String[] headers = new String[KNOWN_HEADERS.length];
    private HttpBody body;

    HttpMessage(HttpBody httpBody) {
        if (httpBody == null) {
            throw new IllegalArgumentException("HttpBody cannot be null");
        }
        this.body = httpBody;
        this.setContentLength();
    }

    boolean hasKeepAliveFlag() {
        String string = this.getHeader(3);
        if (string == null) {
            return false;
        }
        return string.toLowerCase().equals("keep-alive");
    }

    abstract void readFrom(InputStream var1) throws IOException, MalformedHttpException;

    abstract void writeTo(OutputStream var1) throws IOException;

    void setHeader(int n, String string) {
        this.headers[n] = string;
    }

    String getHeader(int n) {
        return this.headers[n];
    }

    void writeHeadersAndBodyTo(OutputStream outputStream, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(CRLF);
        for (int i = 0; i < KNOWN_HEADERS.length; ++i) {
            String string2 = this.getHeader(i);
            if (string2 == null) continue;
            stringBuffer.append(KNOWN_HEADERS[i]).append(": ").append(string2).append(CRLF);
        }
        stringBuffer.append(CRLF);
        outputStream.write(stringBuffer.toString().getBytes());
        this.body.writeTo(outputStream);
    }

    void readBodyFrom(InputStream inputStream, int n) throws IOException {
        this.body.readFrom(inputStream, n);
        this.setContentLength();
    }

    int getContentLength() {
        return this.body.getByteCount();
    }

    byte[] getContentBytes() {
        return this.body.getBytes();
    }

    private void setContentLength() {
        int n = this.body.getByteCount();
        String string = n > 0 ? Integer.toString(n) : null;
        this.setHeader(0, string);
    }
}

