/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.OperationContext;
import com.sun.jdmk.ProxyMBeanInstantiationException;
import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.AuthSchemeInfo;
import com.sun.jdmk.comm.BASE64Decoder;
import com.sun.jdmk.comm.BASE64Encoder;
import com.sun.jdmk.comm.ClientNotificationDispatcher;
import com.sun.jdmk.comm.ClientNotificationHandlerInternal;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.DefaultMapper;
import com.sun.jdmk.comm.GenericHttpConnectorAddress;
import com.sun.jdmk.comm.GenericHttpNotificationReceiver;
import com.sun.jdmk.comm.GenericHttpSocketFactory;
import com.sun.jdmk.comm.HeartBeatClientHandler;
import com.sun.jdmk.comm.HeartBeatClientHandlerImpl;
import com.sun.jdmk.comm.HeartBeatInternalClientHandler;
import com.sun.jdmk.comm.Mapper;
import com.sun.jdmk.comm.RemoteMBeanServer;
import com.sun.jdmk.comm.UnauthorizedSecurityException;
import com.sun.jdmk.internal.ClassLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;

public abstract class GenericHttpConnectorClient
implements RemoteMBeanServer,
HeartBeatClientHandler,
Serializable {
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.comm", "GenericHttpConnectorClient");
    private OperationContext operationContext = null;
    transient Hashtable authSchemeInfoList = null;
    transient GenericHttpConnectorAddress httpConnAddr = null;
    transient GenericHttpSocketFactory factory = null;
    private transient boolean connected = false;
    private transient boolean supportsOperationContext = false;
    private String mbeanServerId = null;
    private transient Mapper mapper = null;
    private transient Mapper defaultMapper = null;
    private transient ClassLoader classloader = null;
    private transient Hashtable proxyHandles = new Hashtable();
    private transient Hashtable genericHandles = new Hashtable();
    private GenericHttpNotificationReceiver notificationReceiver = null;
    private ClientNotificationDispatcher notificationClientHandler = null;
    private HeartBeatClientHandlerImpl heartbeatClientHandler = null;
    private String localHost = null;

    abstract GenericHttpSocketFactory getSocketFactory();

    abstract GenericHttpNotificationReceiver getNotificationReceiver(GenericHttpConnectorClient var1, ClientNotificationDispatcher var2);

    public void setOperationContext(OperationContext operationContext) {
        try {
            if (operationContext != null) {
                operationContext = (OperationContext)operationContext.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CommunicationException(cloneNotSupportedException);
        }
        this.operationContext = operationContext;
    }

    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    public GenericHttpConnectorClient() {
        if (System.getProperty("jdmk.hostname") != null) {
            this.localHost = System.getProperty("jdmk.hostname");
        } else {
            try {
                this.localHost = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                this.localHost = "localhost";
            }
        }
        if (logger.finerOn()) {
            logger.finer("GenericHttpConnectorClient", "localHost=" + this.localHost);
        }
        this.Initialize();
    }

    public GenericHttpConnectorClient(InetAddress inetAddress) {
        try {
            this.localHost = inetAddress == null ? (System.getProperty("jdmk.hostname") != null ? System.getProperty("jdmk.hostname") : InetAddress.getLocalHost().getHostAddress()) : inetAddress.getHostAddress();
        }
        catch (Exception exception) {
            this.localHost = "localhost";
        }
        if (logger.finerOn()) {
            logger.finer("GenericHttpConnectorClient", "localHost=" + this.localHost);
        }
        this.Initialize();
    }

    public GenericHttpConnectorClient(String string) {
        if (string != null) {
            this.localHost = string;
        } else {
            try {
                this.localHost = System.getProperty("jdmk.hostname") != null ? System.getProperty("jdmk.hostname") : InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception exception) {
                this.localHost = "localhost";
            }
        }
        if (logger.finerOn()) {
            logger.finer("GenericHttpConnectorClient", "localHost=" + this.localHost);
        }
        this.Initialize();
    }

    private void Initialize() {
        this.factory = this.getSocketFactory();
        this.mapper = this.defaultMapper = new DefaultMapper();
        this.notificationClientHandler = new ClientNotificationDispatcher(new NotificationHandlerInternal(this));
        this.heartbeatClientHandler = new HeartBeatClientHandlerImpl(new HeartBeatInternalClientHandlerImpl(this), this.notificationClientHandler);
    }

    private String HMAC_MD5(byte[] byArray, byte[] byArray2) {
        int n;
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        if (byArray2.length > 64) {
            byArray2 = messageDigest.digest(byArray2);
        }
        byte[] byArray3 = new byte[64];
        byte[] byArray4 = new byte[64];
        for (n = 0; n < 64; ++n) {
            while (n < byArray2.length) {
                byArray3[n] = byArray2[n];
                byArray4[n] = byArray2[n];
                ++n;
            }
            byArray3[n] = 0;
            byArray4[n] = 0;
        }
        n = 0;
        while (n < 64) {
            int n2 = n;
            byArray3[n2] = (byte)(byArray3[n2] ^ 0x36);
            int n3 = n++;
            byArray4[n3] = (byte)(byArray4[n3] ^ 0x5C);
        }
        messageDigest.update(byArray3);
        messageDigest.update(byArray);
        byte[] byArray5 = messageDigest.digest();
        messageDigest.update(byArray4);
        messageDigest.update(byArray5);
        byArray5 = messageDigest.digest();
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < byArray5.length; ++n) {
            if ((byArray5[n] & 0xFF) < 16) {
                stringBuffer.append("0" + Integer.toHexString(byArray5[n] & 0xFF));
                continue;
            }
            stringBuffer.append(Integer.toHexString(byArray5[n] & 0xFF));
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream sendHttp(Object[] objectArray, boolean bl) throws Exception {
        Object object;
        Object object4;
        Object object2;
        Object object5;
        Object object3;
        if (this.authSchemeInfoList != null) {
            if (this.authSchemeInfoList.get(Thread.currentThread()) == null) {
                this.authSchemeInfoList.put(Thread.currentThread(), new AuthSchemeInfo("CRAM-MD5"));
            }
            if ((object3 = (AuthSchemeInfo)this.authSchemeInfoList.get(Thread.currentThread())) != null && (object5 = ((AuthSchemeInfo)object3).getChallenge()) != null) {
                object2 = "";
                try {
                    object5 = ((String)object5).substring((((AuthSchemeInfo)object3).getAuthScheme() + " ").length());
                    byte[] byArray = new BASE64Decoder().decodeBuffer((String)object5);
                    object4 = this.httpConnAddr.getAuthInfo().getLogin();
                    byte[] byArray2 = this.httpConnAddr.getAuthInfo().getPassword().getBytes();
                    object = this.HMAC_MD5(byArray, byArray2);
                    String string = (String)object4 + " " + (String)object;
                    String string2 = null;
                    int n = string.length() / 57;
                    int n2 = string.length() % 57;
                    for (int i = 0; i < n; ++i) {
                        string2 = string.substring(i * 57, (i + 1) * 57);
                        object2 = (String)object2 + new BASE64Encoder().encode(string2.getBytes());
                    }
                    if (n2 > 0) {
                        string2 = string.substring(n * 57);
                        object2 = (String)object2 + new BASE64Encoder().encode(string2.getBytes());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ((AuthSchemeInfo)object3).setResponse(((AuthSchemeInfo)object3).getAuthScheme() + " " + (String)object2);
                ((AuthSchemeInfo)object3).setChallenge(null);
            }
        }
        object3 = null;
        try {
            try {
                object5 = new ByteArrayOutputStream();
                object2 = new ObjectOutputStream((OutputStream)object5);
                if (this.operationContext != null && this.supportsOperationContext) {
                    ((ObjectOutputStream)object2).writeObject(this.operationContext);
                }
                for (int i = 0; i < objectArray.length; ++i) {
                    ((ObjectOutputStream)object2).writeObject(objectArray[i]);
                }
                try {
                    object3 = this.factory.createSocket(this.httpConnAddr.getHost(), this.httpConnAddr.getPort(), this);
                }
                catch (SocketException socketException) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    object3 = this.factory.createSocket(this.httpConnAddr.getHost(), this.httpConnAddr.getPort(), this);
                }
                OutputStream outputStream = ((Socket)object3).getOutputStream();
                outputStream.write(((ByteArrayOutputStream)object5).toByteArray());
                outputStream.flush();
                object4 = new PushbackInputStream(((Socket)object3).getInputStream());
                int n = ((PushbackInputStream)object4).read();
                if (n >= 0) {
                    ((PushbackInputStream)object4).unread(n);
                }
                object = object4;
                Object var17_22 = null;
                if (object3 == null) return object;
            }
            catch (UnauthorizedSecurityException unauthorizedSecurityException) {
                if (this.authSchemeInfoList == null) throw unauthorizedSecurityException;
                if (bl) {
                    throw unauthorizedSecurityException;
                }
                object2 = this.sendHttp(objectArray, true);
                Object var17_23 = null;
                if (object3 == null) return object2;
                try {
                    try {
                        ((Socket)object3).close();
                        object3 = null;
                        return object2;
                    }
                    catch (IOException iOException) {
                        object3 = null;
                        return object2;
                    }
                }
                catch (Throwable throwable) {
                    object3 = null;
                    throw throwable;
                }
            }
        }
        catch (Throwable throwable) {
            Object var17_24 = null;
            if (object3 == null) throw throwable;
            try {}
            catch (Throwable throwable2) {
                object3 = null;
                throw throwable2;
            }
            try {}
            catch (IOException iOException) {
                object3 = null;
                throw throwable;
            }
            ((Socket)object3).close();
            object3 = null;
            throw throwable;
        }
        try {}
        catch (Throwable throwable) {
            object3 = null;
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            object3 = null;
            return object;
        }
        ((Socket)object3).close();
        object3 = null;
        return object;
    }

    public String connect(ConnectorAddress connectorAddress) {
        if (logger.finerOn()) {
            logger.finer("connect", "connect");
        }
        if (connectorAddress == null) {
            throw new IllegalArgumentException("mbeanServerAddress cannot be null");
        }
        if (!(connectorAddress instanceof GenericHttpConnectorAddress)) {
            throw new IllegalArgumentException("mbeanServerAddress must be an instance of GenericHttpConnectorAddress");
        }
        if (this.connected) {
            throw new CommunicationException("ConnectorClient already connected to RemoteMBeanServer");
        }
        this.httpConnAddr = (GenericHttpConnectorAddress)((GenericHttpConnectorAddress)connectorAddress).clone();
        AuthInfo authInfo = this.httpConnAddr.getAuthInfo();
        if (authInfo != null) {
            if (authInfo.getLogin() == null || authInfo.getPassword() == null) {
                throw new IllegalArgumentException("Login/Password cannot be null");
            }
            this.authSchemeInfoList = new Hashtable();
        }
        this.supportsOperationContext = this.supports("OperationContext");
        String string = null;
        try {
            string = this.getMBeanServerId2();
        }
        catch (UnauthorizedSecurityException unauthorizedSecurityException) {
            throw unauthorizedSecurityException;
        }
        catch (CommunicationException communicationException) {
            throw communicationException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception, "Connection failed");
        }
        if (this.mbeanServerId != null) {
            if (!this.mbeanServerId.equals(string)) {
                throw new IllegalArgumentException("ConnectorClient trying to connect to a different RemoteMBeanServer");
            }
        } else {
            this.mbeanServerId = string;
        }
        this.connected = true;
        this.heartbeatClientHandler.notifyConnectionEstablished();
        this.heartbeatClientHandler.startPinging();
        return this.mbeanServerId;
    }

    public void disconnect() {
        this.disconnect(false);
    }

    public void disconnect(boolean bl) {
        if (logger.finerOn()) {
            logger.finer("disconnect", "disconnect");
        }
        if (this.connected) {
            this.notificationClientHandler.stopListening(bl);
            this.heartbeatClientHandler.stopPinging(-1, bl);
            this.heartbeatClientHandler.notifyConnectionTerminated();
            this.httpConnAddr = null;
            this.authSchemeInfoList = null;
            this.connected = false;
        }
    }

    public boolean isConnected() {
        if (logger.finerOn()) {
            logger.finer("isConnected", "isConnected");
        }
        return this.connected;
    }

    public ConnectorAddress getMBeanServerAddress() {
        if (logger.finerOn()) {
            logger.finer("getMBeanServerAddress", "getMBeanServerAddress");
        }
        if (!this.connected) {
            return null;
        }
        return this.httpConnAddr;
    }

    public String getMBeanServerId() {
        if (logger.finerOn()) {
            logger.finer("getMBeanServerId", "getMBeanServerId");
        }
        return this.mbeanServerId;
    }

    private String getMBeanServerId2() {
        Object[] objectArray = new Object[]{"getMBeanServerId"};
        return (String)this.invokeRemoteOperationNoExceptions(objectArray);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        Object[] objectArray = new Object[]{"createMBean", string, objectName};
        return this.createMBeanWithoutLoader(objectArray);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        Object[] objectArray = new Object[]{"createMBeanLoader", string, objectName, objectName2};
        return this.createMBeanWithLoader(objectArray);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        Object[] objectArray2 = new Object[]{"createMBeanParams", string, objectName, objectArray, stringArray};
        return this.createMBeanWithoutLoader(objectArray2);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        Object[] objectArray2 = new Object[]{"createMBeanLoaderParams", string, objectName, objectName2, objectArray, stringArray};
        return this.createMBeanWithLoader(objectArray2);
    }

    private ObjectInstance createMBeanWithoutLoader(Object[] objectArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        try {
            return (ObjectInstance)this.invokeRemoteOperation(objectArray);
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            throw instanceAlreadyExistsException;
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw mBeanRegistrationException;
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw notCompliantMBeanException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
    }

    private ObjectInstance createMBeanWithLoader(Object[] objectArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        try {
            return (ObjectInstance)this.invokeRemoteOperation(objectArray);
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            throw instanceAlreadyExistsException;
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw mBeanRegistrationException;
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw notCompliantMBeanException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"unregisterMBean", objectName};
        try {
            this.invokeRemoteOperation(objectArray);
            this.proxyHandles.remove(objectName);
            this.genericHandles.remove(objectName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw mBeanRegistrationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"queryNames", objectName, queryExp};
        return (Set)this.invokeRemoteOperationNoExceptions(objectArray);
    }

    public Set queryMBeans(ObjectName objectName, QueryExp queryExp) {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"queryMBeans", objectName, queryExp};
        return (Set)this.invokeRemoteOperationNoExceptions(objectArray);
    }

    public boolean isRegistered(ObjectName objectName) {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"isRegistered", objectName};
        Boolean bl = (Boolean)this.invokeRemoteOperationNoExceptions(objectArray);
        return bl;
    }

    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"getAttribute", objectName, string};
        try {
            return this.invokeRemoteOperation(objectArray);
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw attributeNotFoundException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"getAttributes", objectName, stringArray};
        return (AttributeList)this.invokeRemoteOperationOnInstance(objectArray);
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"setAttribute", objectName, attribute};
        try {
            this.invokeRemoteOperation(objectArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw attributeNotFoundException;
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw invalidAttributeValueException;
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"setAttributes", objectName, attributeList};
        return (AttributeList)this.invokeRemoteOperationOnInstance(objectArray);
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray2 = new Object[]{"invoke", objectName, string, objectArray, stringArray};
        try {
            return this.invokeRemoteOperation(objectArray2);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"getMBeanInfo", objectName};
        try {
            return (MBeanInfo)this.invokeRemoteOperation(objectArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (IntrospectionException introspectionException) {
            throw introspectionException;
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"getObjectInstance", objectName};
        return (ObjectInstance)this.invokeRemoteOperationOnInstance(objectArray);
    }

    public Integer getMBeanCount() {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"getMBeanCount"};
        return (Integer)this.invokeRemoteOperationNoExceptions(objectArray);
    }

    public String getDefaultDomain() {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"getDefaultDomain"};
        return (String)this.invokeRemoteOperationNoExceptions(objectArray);
    }

    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"isInstanceOf", objectName, string};
        Boolean bl = (Boolean)this.invokeRemoteOperationOnInstance(objectArray);
        return bl;
    }

    public boolean supports(String string) {
        Object[] objectArray = new Object[]{"supports", string};
        try {
            Boolean bl = (Boolean)this.invokeRemoteOperationNoExceptions(objectArray);
            return bl;
        }
        catch (CommunicationException communicationException) {
            return false;
        }
    }

    public String getClassForProxyMBean(ObjectInstance objectInstance) throws ProxyMBeanInstantiationException {
        if (logger.finerOn()) {
            logger.finer("getClassForProxyMBean", "getClassForProxyMBean");
        }
        if (objectInstance == null) {
            throw new IllegalArgumentException("ObjectInstance cannot be null");
        }
        return this.mapper.getClassForProxyMBean(objectInstance);
    }

    public void setMode(int n) throws IllegalArgumentException {
        if (logger.finerOn()) {
            logger.finer("setMode", "setMode");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.setMode(n);
    }

    public int getMode() {
        if (logger.finerOn()) {
            logger.finer("getMode", "getMode");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.getMode();
    }

    public void getNotifications() {
        if (logger.finerOn()) {
            logger.finer("getNotifications", "getNotifications");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.getNotifications();
    }

    public void setPeriod(int n) {
        if (logger.finerOn()) {
            logger.finer("setPeriod", "setPeriod");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.setPeriod(n);
    }

    public int getPeriod() {
        if (logger.finerOn()) {
            logger.finer("getPeriod", "getPeriod");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.getPeriod();
    }

    public void clearCache() {
        if (logger.finerOn()) {
            logger.finer("clearCache", "clearCache");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.clearCache();
    }

    public int setCacheSize(int n, boolean bl) throws JMRuntimeException {
        if (logger.finerOn()) {
            logger.finer("setCacheSize", "setCacheSize");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.setCacheSize(n, bl);
    }

    public int getCacheSize() {
        if (logger.finerOn()) {
            logger.finer("getCacheSize", "getCacheSize");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.getCacheSize();
    }

    public void setOverflowCount(int n) {
        if (logger.finerOn()) {
            logger.finer("setOverflowCount", "setOverflowCount");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.setOverflowCount(n);
    }

    public int getOverflowCount() {
        if (logger.finerOn()) {
            logger.finer("getOverflowCount", "getOverflowCount");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.getOverflowCount();
    }

    public void setOverflowMode(int n) throws IllegalArgumentException {
        if (logger.finerOn()) {
            logger.finer("setOverflowMode", "setOverflowMode");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.setOverflowMode(n);
    }

    public int getOverflowMode() {
        if (logger.finerOn()) {
            logger.finer("getOverflowMode", "getOverflowMode");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.getOverflowMode();
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        if (logger.finerOn()) {
            logger.finer("addNotificationListener", "addNotificationListener");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.addNotificationListener(objectName, notificationListener, notificationFilter, object);
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        if (logger.finerOn()) {
            logger.finer("removeNotificationListener", "removeNotificationListener");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.removeNotificationListener(objectName, notificationListener);
    }

    Object[] remoteRequest(int n, Object[] objectArray) throws Exception {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray2 = new Object[]{"remoteRequest", new Integer(n), objectArray};
        try {
            return (Object[])this.invokeRemoteOperation(objectArray2);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            throw listenerNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
    }

    ConnectorAddress startPush() {
        if (logger.finerOn()) {
            logger.finer("startPush", "startPush");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        if (this.notificationReceiver == null) {
            try {
                if (logger.finestOn()) {
                    logger.finest("startPush", "Create new NotificationReceiver");
                }
                this.notificationReceiver = this.getNotificationReceiver(this, this.notificationClientHandler);
            }
            catch (CommunicationException communicationException) {
                throw communicationException;
            }
            catch (Exception exception) {
                throw new CommunicationException(exception);
            }
        }
        if (logger.finestOn()) {
            logger.finest("startPush", "Start receiving events");
        }
        this.notificationReceiver.startListening();
        return this.notificationReceiver.getConnectorAddress();
    }

    void stopPush() {
        if (logger.finerOn()) {
            logger.finer("stopPush", "stopPush");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        if (this.notificationReceiver != null) {
            this.notificationReceiver.stopListening();
        }
    }

    public int getHeartBeatPeriod() {
        if (logger.finerOn()) {
            logger.finer("getHeartBeatPeriod", "getHeartBeatPeriod");
        }
        return this.heartbeatClientHandler.getHeartBeatPeriod();
    }

    public void setHeartBeatPeriod(int n) {
        if (logger.finerOn()) {
            logger.finer("setHeartBeatPeriod", "setHeartBeatPeriod");
        }
        this.heartbeatClientHandler.setHeartBeatPeriod(n);
    }

    public int getHeartBeatRetries() {
        if (logger.finerOn()) {
            logger.finer("getHeartBeatRetries", "getHeartBeatRetries");
        }
        return this.heartbeatClientHandler.getHeartBeatRetries();
    }

    public void setHeartBeatRetries(int n) {
        if (logger.finerOn()) {
            logger.finer("setHeartBeatRetries", "setHeartBeatRetries");
        }
        this.heartbeatClientHandler.setHeartBeatRetries(n);
    }

    public void addHeartBeatNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        if (logger.finerOn()) {
            logger.finer("addHeartBeatNotificationListener", "addHeartBeatNotificationListener");
        }
        this.heartbeatClientHandler.addHeartBeatNotificationListener(notificationListener, notificationFilter, object);
    }

    public void removeHeartBeatNotificationListener(NotificationListener notificationListener) {
        if (logger.finerOn()) {
            logger.finer("removeHeartBeatNotificationListener", "removeHeartBeatNotificationListener");
        }
        this.heartbeatClientHandler.removeHeartBeatNotificationListener(notificationListener);
    }

    String pingHeartBeatServer(String string, int n, int n2, Long l) {
        Object[] objectArray = new Object[]{"pingHeartBeatServer", string, new Integer(n), new Integer(n2), l};
        return (String)this.invokeRemoteOperationNoExceptions(objectArray);
    }

    String getHost() {
        return this.localHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeRemoteOperation(Object[] objectArray) throws Exception {
        Object object;
        if (logger.finerOn()) {
            object = (String)objectArray[0];
            logger.finer("invokeRemoteOperation", (String)object);
        }
        object = this.sendHttp(objectArray, false);
        try {
            Object object2 = this.readObjectValue((InputStream)object);
            return object2;
        }
        finally {
            ((InputStream)object).close();
        }
    }

    private Object invokeRemoteOperationNoExceptions(Object[] objectArray) {
        try {
            return this.invokeRemoteOperationOnInstance(objectArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new CommunicationException(instanceNotFoundException);
        }
    }

    private Object invokeRemoteOperationOnInstance(Object[] objectArray) throws InstanceNotFoundException {
        try {
            return this.invokeRemoteOperation(objectArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
    }

    private Object readObjectValue(InputStream inputStream) throws Exception {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        String string = (String)objectInputStream.readObject();
        if (logger.finestOn()) {
            logger.finest("readObjectValue", "Received object of type " + string);
        }
        Object object = objectInputStream.readObject();
        if (logger.finestOn()) {
            logger.finest("readObjectValue", "Received object [" + object + "]");
        }
        if (object instanceof Exception && string.equals("Exception")) {
            if (logger.finestOn()) {
                logger.finest("readObjectValue", "Throw exception :" + object);
            }
            throw (Exception)object;
        }
        if (logger.finestOn()) {
            logger.finest("readObjectValue", "Return value : " + object);
        }
        return object;
    }

    private class HeartBeatInternalClientHandlerImpl
    implements HeartBeatInternalClientHandler {
        private GenericHttpConnectorClient connector;

        public HeartBeatInternalClientHandlerImpl(GenericHttpConnectorClient genericHttpConnectorClient2) {
            this.connector = genericHttpConnectorClient2;
        }

        public RemoteMBeanServer getRemoteMBeanServer() {
            return this.connector;
        }

        public String pingHeartBeatServer(String string, int n, int n2, Long l) {
            return this.connector.pingHeartBeatServer(string, n, n2, l);
        }
    }

    private class NotificationHandlerInternal
    implements ClientNotificationHandlerInternal {
        private GenericHttpConnectorClient connector;

        public NotificationHandlerInternal(GenericHttpConnectorClient genericHttpConnectorClient2) {
            this.connector = genericHttpConnectorClient2;
        }

        public Object[] remoteRequest(int n, Object[] objectArray) throws Exception {
            return this.connector.remoteRequest(n, objectArray);
        }

        public ConnectorAddress startPush() {
            return this.connector.startPush();
        }

        public void stopPush(ConnectorAddress connectorAddress) {
            this.connector.stopPush();
        }
    }
}

