/*
 * Decompiled with CFR 0.152.
 */
package spec.reporter;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.logging.Level;
import spec.jbb.JBButil;
import spec.reporter.ReportProps;
import spec.reporter.TextBlock;
import spec.reporter.TextColumn;
import spec.reporter.TextMetrics;

public class TextiReport {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2000-2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,Copyright (c) 2000-2005 Hewlett-Packard,All rights reserved,Copyright (c) 1997-2005 Sun Microsystems, Inc.All rights reserved,Licensed Materials - Property of SPEC";
    public String hardware;
    public String metric;
    public String software;
    public String base;
    private TextColumn columnTitle;
    private TextColumn columnValue;
    public String issue;
    private String memory;
    private String memoryDescription;
    public TextMetrics metrics;
    private static final int pageWidth = 120;
    public ReportProps results = new ReportProps();
    public boolean SPECInternalUse;

    public TextiReport(String string, String string2, boolean bl) {
        this.issue = string;
        this.SPECInternalUse = bl;
        try {
            if (string2 == null) {
                this.results.load(new InputStreamReader(System.in));
            } else {
                this.results.load(string2);
            }
        }
        catch (IOException iOException) {
            JBButil.getLog().log(Level.WARNING, "Error reading results file " + string2 + ": " + iOException, iOException);
            System.exit(1);
        }
        this.metrics = new TextMetrics(this.results, bl);
        this.hardware = this.get("config.hw.vendor") + " " + this.get("config.hw.model");
        if (this.metric == null) {
            this.metric = this.metrics.metric();
        }
        if (this.metrics.valid) {
            this.metrics.output_properly("Valid run, Score is " + this.metric + "\n");
        } else if (this.metrics.print_score) {
            this.metrics.output_properly("INVALID run; Score is " + this.metric + "\n");
        } else {
            this.metrics.output_properly("INVALID run, preventing score calculation.");
        }
        this.software = this.get("config.sw.vendor") + " " + this.get("config.sw.JVM");
        this.memory = this.results.get("config.hw.memory");
        this.memoryDescription = this.results.get("config.hw.memory_description");
    }

    private String configSection() {
        TextBlock textBlock = new TextBlock(51, "HARDWARE");
        this.columnTitle = new TextColumn(25);
        this.columnValue = new TextColumn(25);
        this.cput("config.hw.vendor", "Vendor");
        this.cput("config.hw.vendor.url", "Vendor URL");
        this.cput("config.hw.model", "Model");
        this.cput("config.hw.processor", "Processor");
        this.cput("config.hw.MHz", "MHz");
        this.cput("config.hw.nchips", "# of Chips");
        this.cput("config.hw.ncores", "# of Cores");
        this.cput("config.hw.ncoresperchip", "# of Cores/Chip");
        this.cput("config.hw.hwThreads", "HW Threading Enabled");
        this.cput("config.sw.procsAvailtoJava", "Procs avail to Java");
        this.cput("config.hw.memory", "Memory (MB)");
        this.cput("config.hw.memory_description", "Memory Details");
        this.cput("config.hw.primaryCache", "L1 Cache");
        this.cput("config.hw.secondaryCache", "L2 Cache");
        this.cput("config.hw.otherCache", "Other Cache");
        this.cput("config.hw.fileSystem", "Filesystem");
        this.cput("config.hw.disk", "Disks");
        this.cput("config.hw.other", "Other H/W");
        textBlock.add(this.columnTitle.join(this.columnValue, " ").merge());
        TextBlock textBlock2 = new TextBlock(65, "SOFTWARE");
        this.columnTitle = new TextColumn(20);
        this.columnValue = new TextColumn(44);
        this.cput("config.sw.vendor", "Vendor");
        this.cput("config.sw.vendor.url", "Vendor URL");
        this.cput("config.sw.JVM", "JVM Version");
        this.cput("config.sw.command_line", "Command Line");
        this.cput("config.sw.JVMheapInitial", "Initial Heap Mem (MB)");
        this.cput("config.sw.JVMheapMax", "Max Heap Mem (MB)");
        this.cput("config.sw.JVMbitness", "JVM addressing bits");
        this.cput("java.class.path", "JVM CLASSPATH");
        this.cput("java.library.path", "JVM BOOTCLASSPATH");
        this.cput("config.sw.OS", "OS Version");
        this.cput("config.sw.other", "Other S/W");
        textBlock2.add(this.columnTitle.join(this.columnValue, " ").merge());
        textBlock2.add("");
        textBlock2.add("AOT Compilation Details");
        if (this.results.get("config.sw.aot") != null) {
            textBlock2.add(this.results.get("config.sw.aot"));
        }
        textBlock2.add("");
        textBlock2.add("TUNING AND NOTES");
        if (this.results.get("config.sw.tuning") != null) {
            textBlock2.add(this.results.get("config.sw.tuning"));
        }
        if (this.results.get("config.sw.notes") != null) {
            textBlock2.add(this.results.get("config.sw.notes"));
        }
        textBlock2.add("");
        TextBlock textBlock3 = textBlock.join(textBlock2);
        textBlock3.add("");
        textBlock2 = new TextBlock(37, "TEST INFORMATION");
        this.columnTitle = new TextColumn(18);
        this.columnValue = new TextColumn(18);
        this.cput("config.test.testedBy", "Tested by");
        this.cput("config.test.specLicense", "SPEC License");
        this.cput("config.test.location", "Test Location");
        this.cput("config.test.date", "Test Date");
        this.cput("config.sw.JVMavailable", "JVM available");
        this.cput("config.hw.available", "H/w available");
        this.cput("config.sw.OSavailable", "OS available");
        this.cput("config.sw.otherAvailable", "Other s/w available");
        textBlock2.add(this.columnTitle.join(this.columnValue, " ").merge());
        textBlock3.add(textBlock2);
        return textBlock3.toString();
    }

    private void cput(String string, String string2) {
        this.columnTitle.add(string2);
        this.columnValue.add(this.get(string));
    }

    private String get(String string) {
        return this.get(string, "MISSING");
    }

    private String get(String string, String string2) {
        String string3 = this.results.get(string, string2);
        if (string3.indexOf(60) >= 0) {
            int n = string3.indexOf("<i>");
            if (n >= 0) {
                string3 = string3.substring(0, n) + string3.substring(n + 3);
            }
            if ((n = string3.indexOf("<I>")) >= 0) {
                string3 = string3.substring(0, n) + string3.substring(n + 3);
            }
            if ((n = string3.indexOf("</i>")) >= 0) {
                string3 = string3.substring(0, n) + string3.substring(n + 4);
            }
            if ((n = string3.indexOf("</I>")) >= 0) {
                string3 = string3.substring(0, n) + string3.substring(n + 4);
            }
        }
        return string3;
    }

    public void print(String string) {
        try {
            this.print(new PrintStream(new BufferedOutputStream(new FileOutputStream(string))));
        }
        catch (IOException iOException) {
            JBButil.getLog().log(Level.WARNING, "Error creating output: " + iOException, iOException);
        }
    }

    public void print(PrintStream printStream) {
        try {
            printStream.println("SPECjbb2005                bops = " + this.metric + ", bops/JVM = " + this.metric);
            printStream.println();
            printStream.println(this.hardware);
            printStream.println(this.software);
            this.testBar(printStream);
            printStream.println(this.metrics.ratioTable());
            printStream.println();
            printStream.println(this.configSection());
            printStream.println(this.metrics.detail());
            printStream.println("\nSPECjbb2005 Version: [" + this.results.get("config.benchmark_version", "N/A") + ", " + this.results.get("config.benchmark_versionDate", "-") + "]");
            if (this.issue != null && !this.issue.equals("") && this.metrics.valid) {
                printStream.println("Published by SPEC " + this.issue);
            }
            printStream.println("Reporting page (C) Copyright SPEC, 2005. All rights reserved\n");
            printStream.close();
        }
        catch (Exception exception) {
            JBButil.getLog().log(Level.WARNING, "Error: " + exception, exception);
        }
    }

    public void testBar(PrintStream printStream) throws IOException {
        String string = this.results.get("config.test.specLicense", "MISSING");
        String string2 = this.results.get("config.test.testedBy", "MISSING");
        String string3 = this.results.get("config.test.date", "MISSING");
        printStream.println("SPEC license # " + string + ",  " + "Tested by: " + string2 + ",  " + "Test date: " + string3);
    }
}

