/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import java.io.PrintStream;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;

public class SimpleClassFilePrinter
implements ClassFileVisitor,
MemberInfoVisitor {
    private boolean printAccessModifiers;
    private PrintStream ps;

    public SimpleClassFilePrinter() {
        this(true);
    }

    public SimpleClassFilePrinter(boolean bl) {
        this(bl, System.out);
    }

    public SimpleClassFilePrinter(boolean bl, PrintStream printStream) {
        this.printAccessModifiers = bl;
        this.ps = printStream;
    }

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        this.ps.println(ClassUtil.externalFullClassDescription(this.printAccessModifiers ? programClassFile.getAccessFlags() : 0, programClassFile.getName()));
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
        this.ps.println(ClassUtil.externalFullClassDescription(this.printAccessModifiers ? libraryClassFile.getAccessFlags() : 0, libraryClassFile.getName()));
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        this.ps.println(ClassUtil.externalFullClassDescription(this.printAccessModifiers ? programClassFile.getAccessFlags() : 0, programClassFile.getName()) + ": " + ClassUtil.externalFullFieldDescription(this.printAccessModifiers ? programFieldInfo.getAccessFlags() : 0, programFieldInfo.getName(programClassFile), programFieldInfo.getDescriptor(programClassFile)));
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        this.ps.println(ClassUtil.externalFullClassDescription(this.printAccessModifiers ? programClassFile.getAccessFlags() : 0, programClassFile.getName()) + ": " + ClassUtil.externalFullMethodDescription(programClassFile.getName(), this.printAccessModifiers ? programMethodInfo.getAccessFlags() : 0, programMethodInfo.getName(programClassFile), programMethodInfo.getDescriptor(programClassFile)));
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
        this.ps.println(ClassUtil.externalFullClassDescription(this.printAccessModifiers ? libraryClassFile.getAccessFlags() : 0, libraryClassFile.getName()) + ": " + ClassUtil.externalFullFieldDescription(this.printAccessModifiers ? libraryFieldInfo.getAccessFlags() : 0, libraryFieldInfo.getName(libraryClassFile), libraryFieldInfo.getDescriptor(libraryClassFile)));
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
        this.ps.println(ClassUtil.externalFullClassDescription(this.printAccessModifiers ? libraryClassFile.getAccessFlags() : 0, libraryClassFile.getName()) + ": " + ClassUtil.externalFullMethodDescription(libraryClassFile.getName(), this.printAccessModifiers ? libraryMethodInfo.getAccessFlags() : 0, libraryMethodInfo.getName(libraryClassFile), libraryMethodInfo.getDescriptor(libraryClassFile)));
    }
}

