/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.annotation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import proguard.classfile.ClassFile;
import proguard.classfile.attribute.AttrInfo;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationVisitor;

public abstract class RuntimeParameterAnnotationsAttrInfo
extends AttrInfo {
    private static final int CONSTANT_FIELD_SIZE1 = 1;
    private static final int CONSTANT_FIELD_SIZE2 = 2;
    public int u2numberOfParameters;
    public Annotation[][] parameterAnnotations;

    protected RuntimeParameterAnnotationsAttrInfo() {
    }

    public void annotationsAccept(ClassFile classFile, AnnotationVisitor annotationVisitor) {
        for (int i = 0; i < this.u2numberOfParameters; ++i) {
            Annotation[] annotationArray = this.parameterAnnotations[i];
            int n = annotationArray.length;
            for (int j = 0; j < n; ++j) {
                annotationVisitor.visitAnnotation(classFile, annotationArray[j]);
            }
        }
    }

    protected int getLength() {
        int n = 1;
        for (int i = 0; i < this.u2numberOfParameters; ++i) {
            Annotation[] annotationArray = this.parameterAnnotations[i];
            int n2 = annotationArray.length;
            n += 2;
            for (int j = 0; j < n2; ++j) {
                n += annotationArray[j].getLength();
            }
        }
        return n;
    }

    protected void readInfo(DataInput dataInput, ClassFile classFile) throws IOException {
        this.u2numberOfParameters = dataInput.readUnsignedByte();
        this.parameterAnnotations = new Annotation[this.u2numberOfParameters][];
        for (int i = 0; i < this.u2numberOfParameters; ++i) {
            int n = dataInput.readUnsignedShort();
            Annotation[] annotationArray = new Annotation[n];
            for (int j = 0; j < n; ++j) {
                annotationArray[j] = Annotation.create(dataInput);
            }
            this.parameterAnnotations[i] = annotationArray;
        }
    }

    protected void writeInfo(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.u2numberOfParameters);
        for (int i = 0; i < this.u2numberOfParameters; ++i) {
            Annotation[] annotationArray = this.parameterAnnotations[i];
            int n = annotationArray.length;
            dataOutput.writeShort(n);
            for (int j = 0; j < n; ++j) {
                annotationArray[j].write(dataOutput);
            }
        }
    }
}

