/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.webservices.runtime;

import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.connection.jca.cics.CICSInteractionDescription;
import it.imolinfo.jbi4cics.exception.Jbi4cicsException;
import it.imolinfo.jbi4cics.exception.LocationException;
import it.imolinfo.jbi4cics.jbi.BCELClassLoader;
import it.imolinfo.jbi4cics.jbi.wsdl.Jbi4CicsAddress;
import it.imolinfo.jbi4cics.jbi.wsdl.Jbi4CicsBinding;
import it.imolinfo.jbi4cics.jbi.wsdl.Jbi4CicsExtension;
import it.imolinfo.jbi4cics.jbi.xfire.JbiTransport;
import it.imolinfo.jbi4cics.locator.SimpleLocation;
import it.imolinfo.jbi4cics.security.Account;
import it.imolinfo.jbi4cics.webservices.descriptor.ServiceDescriptor;
import it.imolinfo.jbi4cics.webservices.runtime.BigDecimalType;
import it.imolinfo.jbi4cics.webservices.runtime.BigIntegerType;
import it.imolinfo.jbi4cics.webservices.runtime.ServiceInvoker;
import it.imolinfo.jbi4cics.webservices.utils.generators.ServiceBeanGenerator;
import it.imolinfo.jbi4cics.webservices.utils.generators.ServiceInterfaceGenerator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.jbi.component.ComponentContext;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.codehaus.xfire.DefaultXFire;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.aegis.AegisBindingProvider;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.TypeMapping;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.service.invoker.Invoker;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.transport.TransportManager;
import org.xml.sax.InputSource;

public final class ServiceCreator {
    private static final int BUFFER_SIZE = 4096;
    private static final Logger LOG = LoggerFactory.getLogger(ServiceCreator.class);

    public Service createService(ServiceDescriptor desc, XFire xfire) {
        QName interfaceName = new QName(desc.getServiceNameSpace(), desc.getServiceInterfaceName());
        return this.doCreateService(desc, xfire, interfaceName, false);
    }

    public Service createJbiService(ServiceDescriptor desc, XFire xfire, QName interfaceName) {
        return this.doCreateService(desc, xfire, interfaceName, true);
    }

    private Service doCreateService(ServiceDescriptor desc, XFire xfire, QName interfaceName, boolean isJbiService) {
        ObjectServiceFactory factory = new ObjectServiceFactory(xfire.getTransportManager());
        AegisBindingProvider bindingProvider = (AegisBindingProvider)factory.getBindingProvider();
        HashMap<String, Object> props = null;
        if (isJbiService) {
            props = new HashMap<String, Object>();
            props.put("objectServiceFactory.portType", interfaceName);
            props.put("objectServiceFactory.style", "wrapped");
            props.put("objectServiceFactory.use", "literal");
            factory.getSoap12Transports().clear();
            factory.getSoap11Transports().clear();
            factory.getSoap11Transports().add("http://java.sun.com/xml/ns/jbi/binding/service+engine");
        }
        Service service = factory.create(desc.getServiceInterface(), desc.getServiceName(), desc.getServiceNameSpace(), props);
        service.setInvoker((Invoker)new ServiceInvoker(desc));
        service.setProperty("wsdlBuilder.generateImports", (Object)"true");
        TypeMapping typeMapping = bindingProvider.getTypeMapping(service);
        typeMapping.register((Type)new BigIntegerType());
        typeMapping.register((Type)new BigDecimalType());
        return service;
    }

    public Definition createWsdlFromCopyCobol(String copyCobol, String outputCopyCobol, ServiceDescriptor desc) throws Jbi4cicsException {
        BCELClassLoader loader = new BCELClassLoader(this.getClass().getClassLoader());
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(4096);
        new ServiceBeanGenerator(desc, true).generateBeanClass(loader);
        new ServiceBeanGenerator(desc, false).generateBeanClass(loader);
        new ServiceInterfaceGenerator(desc).generateServiceInterface(loader);
        Service service = this.createJbiService(desc, ServiceCreator.createXFire(null), new QName(desc.getServiceNameSpace(), desc.getServiceInterfaceName()));
        try {
            service.getWSDLWriter().write((OutputStream)buffer);
            return this.bindToCics(new ByteArrayInputStream(buffer.toByteArray()), copyCobol, outputCopyCobol, desc);
        }
        catch (WSDLException e) {
            LOG.error(e.getLocalizedMessage(), e);
            throw new Jbi4cicsException(e.getMessage(), e);
        }
        catch (IOException e) {
            LOG.error(e.getLocalizedMessage(), e);
            throw new Jbi4cicsException(e.getMessage(), e);
        }
    }

    public static XFire createXFire(ComponentContext componentContext) {
        DefaultXFire xfire = new DefaultXFire();
        TransportManager manager = xfire.getTransportManager();
        for (Object o : manager.getTransports().toArray()) {
            manager.unregister((Transport)o);
        }
        manager.register((Transport)new JbiTransport(componentContext));
        return xfire;
    }

    private Definition bindToCics(InputStream wsdl, String copyCobol, String outputCopyCobol, ServiceDescriptor desc) throws WSDLException, IOException, LocationException {
        WSDLFactory factory = WSDLFactory.newInstance();
        WSDLReader reader = factory.newWSDLReader();
        ExtensionRegistry registry = factory.newPopulatedExtensionRegistry();
        Jbi4CicsExtension.register(registry);
        reader.setExtensionRegistry(registry);
        Definition def = reader.readWSDL(null, new InputSource(wsdl));
        def.setExtensionRegistry(registry);
        def.addNamespace("imolacics", "uri://schemas.imola.it/jbi/wsdl-extensions/cics/");
        javax.wsdl.Service service = def.getService(new QName(desc.getServiceNameSpace(), desc.getServiceName()));
        service.getPorts().clear();
        Port port = def.createPort();
        port.setName(desc.getServiceName() + "CicsPort");
        service.addPort(port);
        port.addExtensibilityElement((ExtensibilityElement)ServiceCreator.createJbi4CicsAddressElement(desc));
        Binding binding = def.createBinding();
        binding.setUndefined(false);
        binding.setQName(new QName(desc.getServiceNameSpace(), desc.getServiceName() + "CicsBinding"));
        binding.setPortType(def.getPortType(new QName(desc.getServiceNameSpace(), desc.getServiceInterfaceName())));
        port.setBinding(binding);
        def.addBinding(binding);
        ServiceCreator.removeWsdlSoapElements(def, binding, desc);
        binding.addExtensibilityElement((ExtensibilityElement)ServiceCreator.createJbi4CicsBindingElement(copyCobol, outputCopyCobol, desc));
        return def;
    }

    private static Jbi4CicsAddress createJbi4CicsAddressElement(ServiceDescriptor desc) throws LocationException {
        Jbi4CicsAddress addr = new Jbi4CicsAddress();
        Account account = desc.getAccount();
        SimpleLocation location = (SimpleLocation)desc.getServiceLocation();
        CICSInteractionDescription interactionDesc = (CICSInteractionDescription)desc.getInteractionDescription();
        addr.setElementType(Jbi4CicsExtension.Q_ELEM_JBI4CICS_ADDRESS);
        addr.setUsername(account.getUsername());
        addr.setPassword(account.getPassword());
        addr.setConnectionType(location.getConnectionTypeName());
        addr.setJNDIConnectionName(location.getLocationName());
        addr.setProgramName(interactionDesc.getProgramName());
        addr.setTransactionName(interactionDesc.getTransactionName());
        addr.setTpn(interactionDesc.isTpn());
        return addr;
    }

    private static void removeWsdlSoapElements(Definition def, Binding binding, ServiceDescriptor desc) {
        QName oldBindingName = new QName(desc.getServiceNameSpace(), desc.getServiceName() + "JBIBinding");
        for (Object o : def.getBinding(oldBindingName).getBindingOperations()) {
            BindingOperation bindingOp = (BindingOperation)o;
            Operation operation = bindingOp.getOperation();
            BindingInput input = bindingOp.getBindingInput();
            BindingOutput output = bindingOp.getBindingOutput();
            BindingOperation newBindingOp = def.createBindingOperation();
            Operation newOperation = def.createOperation();
            BindingInput newInput = def.createBindingInput();
            BindingOutput newOutput = def.createBindingOutput();
            newBindingOp.setName(bindingOp.getName());
            newOperation.setName(operation.getName());
            newInput.setName(input.getName());
            newOutput.setName(output.getName());
            newBindingOp.setOperation(newOperation);
            newBindingOp.setBindingInput(newInput);
            newBindingOp.setBindingOutput(newOutput);
            for (Object obj : bindingOp.getBindingFaults().values()) {
                BindingFault fault = (BindingFault)obj;
                BindingFault newFault = def.createBindingFault();
                newFault.setName(fault.getName());
                newBindingOp.addBindingFault(newFault);
            }
            binding.addBindingOperation(newBindingOp);
        }
        def.removeBinding(oldBindingName);
    }

    private static Jbi4CicsBinding createJbi4CicsBindingElement(String copyCobol, String outputCopyCobol, ServiceDescriptor desc) {
        Jbi4CicsBinding binding = new Jbi4CicsBinding();
        binding.setElementType(Jbi4CicsExtension.Q_ELEM_JBI4CICS_BINDING);
        binding.setServicePackageName(desc.getServiceInterfacePackageName());
        binding.setCodePage(desc.getCodePage());
        binding.setCopyCobol(copyCobol);
        if (outputCopyCobol != null && !ServiceCreator.isBlank(outputCopyCobol)) {
            binding.setSameCopyCobol(Boolean.FALSE);
            binding.setOutputCopyCobol(outputCopyCobol);
        }
        return binding;
    }

    private static boolean isBlank(String str) {
        for (int i = str.length() - 1; i >= 0; --i) {
            if (str.charAt(i) <= ' ') continue;
            return false;
        }
        return true;
    }
}

