/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.connection.jdbc;

import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.connection.ConnectionManager;
import it.imolinfo.jbi4cics.connection.jdbc.util.DisconnectedPreparedStatement;
import it.imolinfo.jbi4cics.exception.ConnectionException;
import it.imolinfo.jbi4cics.locator.ServiceLocation;
import it.imolinfo.jbi4cics.messageformat.jdbc.JdbcOutputMessage;
import it.imolinfo.jbi4cics.messageformat.jdbc.JdbcStatementDescriptor;
import it.imolinfo.jbi4cics.service.ServiceContext;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JdbcConnectionManager
implements ConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcConnectionManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCall(ServiceContext serviceContext) throws ConnectionException {
        Connection connection = null;
        DisconnectedPreparedStatement disconnectedStatement = null;
        try {
            connection = this.createConnection(serviceContext);
            Object inputMessage = serviceContext.getInputMessage();
            if (!(inputMessage instanceof DisconnectedPreparedStatement)) {
                LOG.error("CIC000600_Expected_disconnected_statement_input_message", new Object[]{inputMessage.getClass()});
                throw new ConnectionException("CIC000600_Expected_disconnected_statement_input_message", new Object[]{inputMessage.getClass()});
            }
            disconnectedStatement = (DisconnectedPreparedStatement)inputMessage;
            if (!(serviceContext.getInputMappingDescriptor() instanceof JdbcStatementDescriptor)) {
                LOG.error("CIC000601_Expected_jdbc_statement_descriptor_input_message", new Object[]{serviceContext.getInputMappingDescriptor().getClass()});
                throw new ConnectionException("CIC000601_Expected_jdbc_statement_descriptor_input_message", new Object[]{serviceContext.getInputMappingDescriptor().getClass()});
            }
            JdbcStatementDescriptor jdbcStatementDescriptor = (JdbcStatementDescriptor)serviceContext.getInputMappingDescriptor();
            ResultSet resultSet = null;
            disconnectedStatement.setConnection(connection);
            try {
                disconnectedStatement.setConnected(true);
            }
            catch (SQLException e) {
                LOG.error("CIC000602_Error_preparing_statement", new Object[]{e.getMessage()}, e);
                throw new ConnectionException("CIC000602_Error_preparing_statement", new Object[]{e.getMessage()}, e);
            }
            try {
                switch (jdbcStatementDescriptor.getSqlType()) {
                    case 1: {
                        resultSet = disconnectedStatement.executeQuery();
                        break;
                    }
                    case 0: {
                        boolean result = disconnectedStatement.execute();
                        if (result) {
                            resultSet = disconnectedStatement.getResultSet();
                        }
                        break;
                    }
                    default: {
                        LOG.error("CIC000603_Unexpected_sql_type", new Object[]{jdbcStatementDescriptor.getSqlType()});
                        throw new ConnectionException("CIC000603_Unexpected_sql_type", new Object[]{jdbcStatementDescriptor.getSqlType()});
                    }
                }
            }
            catch (SQLException e) {
                LOG.error("CIC000604_Error_executing_statement", new Object[]{e.getMessage()}, e);
                throw new ConnectionException("CIC000604_Error_executing_statement", new Object[]{e.getMessage()}, e);
            }
            JdbcOutputMessage jdbcOutputMessage = new JdbcOutputMessage();
            jdbcOutputMessage.setDisconnectedSatetement(disconnectedStatement);
            jdbcOutputMessage.setResultSet(resultSet);
            serviceContext.setOutputMessage(jdbcOutputMessage);
        }
        catch (Throwable throwable) {
            this.releaseResources(connection, disconnectedStatement);
            throw throwable;
        }
        this.releaseResources(connection, disconnectedStatement);
    }

    private Connection createConnection(ServiceContext serviceContext) throws ConnectionException {
        ServiceLocation serviceLocation = serviceContext.getServiceLocation();
        if (serviceLocation.getConnectionType() != 2) {
            throw new ConnectionException("CIC000605_Expected_jdbc_connection_type", new Object[]{serviceLocation.getConnectionType()});
        }
        String jndiConnectionName = serviceLocation.getLocationName();
        DataSource dataSource = null;
        try {
            InitialContext initialContext = new InitialContext();
            dataSource = (DataSource)initialContext.lookup(jndiConnectionName);
        }
        catch (NamingException e) {
            LOG.error("CIC000606_Error_retrieving_data_source", new Object[]{e.getMessage()}, e);
            throw new ConnectionException("CIC000606_Error_retrieving_data_source", new Object[]{e.getMessage()}, e);
        }
        if (dataSource == null) {
            throw new ConnectionException("CIC000607_Lookup_failed", new Object[]{jndiConnectionName});
        }
        try {
            Connection connection = dataSource.getConnection();
            return connection;
        }
        catch (SQLException e) {
            LOG.error("CIC000608_Error_getting_connection_data_source", new Object[]{e.getMessage()}, e);
            throw new ConnectionException("CIC000608_Error_getting_connection_data_source", new Object[]{e.getMessage()}, e);
        }
    }

    private void releaseResources(Connection connection, DisconnectedPreparedStatement disconnectedPreparedStatement) throws ConnectionException {
        try {
            if (disconnectedPreparedStatement != null) {
                disconnectedPreparedStatement.setConnected(false);
            }
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e) {
            LOG.error("CIC000609_Error_releasing_resources", new Object[]{e.getMessage()}, e);
            throw new ConnectionException("CIC000609_Error_releasing_resources", new Object[]{e.getMessage()}, e);
        }
    }
}

