/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.connection.jca;

import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.connection.ConnectionManager;
import it.imolinfo.jbi4cics.exception.ConnectionException;
import it.imolinfo.jbi4cics.locator.ServiceLocation;
import it.imolinfo.jbi4cics.service.ServiceContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;

public abstract class JCAAbstractConnectionManager
implements ConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(JCAAbstractConnectionManager.class);
    ConnectionFactory connectionFactory = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCall(ServiceContext serviceContext) throws ConnectionException {
        Connection connection = null;
        Interaction interaction = null;
        if (this.connectionFactory == null) {
            this.lookupConnectionFactory(serviceContext);
        }
        try {
            ConnectionSpec connectionSpec = this.createConnectionSpec(serviceContext);
            connection = this.createConnection(serviceContext, connectionSpec);
            interaction = this.createInteraction(connection);
            InteractionSpec interactionSpec = this.createInteractionSpec(serviceContext);
            Record inputRecord = this.createInputRecord(serviceContext);
            Record outputRecord = this.createOutputRecord(serviceContext);
            try {
                boolean result = interaction.execute(interactionSpec, inputRecord, outputRecord);
                if (!result) {
                    LOG.error("CIC000302_Wrong_execution_of_the_request");
                    throw new ConnectionException("CIC000302_Wrong_execution_of_the_request");
                }
            }
            catch (ResourceException e) {
                LOG.error("CIC000303_Error_executing_the_request", new Object[]{e.getMessage()}, e);
                throw new ConnectionException("CIC000303_Error_executing_the_request", new Object[]{e.getMessage()}, e);
            }
            Object outputMessage = this.createOutputMessage(serviceContext, outputRecord);
            serviceContext.setOutputMessage(outputMessage);
        }
        catch (Throwable throwable) {
            this.releaseResources(connection, interaction);
            throw throwable;
        }
        this.releaseResources(connection, interaction);
    }

    protected void releaseResources(Connection connection, Interaction interaction) throws ConnectionException {
        try {
            if (interaction != null) {
                interaction.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        catch (ResourceException e) {
            LOG.error("CIC000304_Error_releasing_resources", new Object[]{e.getMessage()}, e);
            throw new ConnectionException("CIC000304_Error_releasing_resources", new Object[]{e.getMessage()}, e);
        }
    }

    protected Interaction createInteraction(Connection connection) throws ConnectionException {
        try {
            Interaction interaction = connection.createInteraction();
            return interaction;
        }
        catch (ResourceException e) {
            LOG.error("CIC000305_Error_getting_interaction_from_JCA", new Object[]{e.getMessage()}, e);
            throw new ConnectionException("CIC000305_Error_getting_interaction_from_JCA", new Object[]{e.getMessage()}, e);
        }
    }

    protected Connection createConnection(ServiceContext serviceContext, ConnectionSpec connectionSpec) throws ConnectionException {
        if (this.connectionFactory == null) {
            this.lookupConnectionFactory(serviceContext);
        }
        try {
            Connection connection = this.connectionFactory.getConnection(connectionSpec);
            return connection;
        }
        catch (ResourceException e) {
            LOG.error("CIC000306_Error_getting_connection_from_JCA", new Object[]{e.getMessage()}, e);
            throw new ConnectionException("CIC000306_Error_getting_connection_from_JCA", new Object[]{e.getMessage()}, e);
        }
    }

    private void lookupConnectionFactory(ServiceContext serviceContext) throws ConnectionException {
        ServiceLocation serviceLocation = serviceContext.getServiceLocation();
        if (this.connectionFactory == null) {
            String jndiConnectionName = serviceLocation.getLocationName();
            try {
                InitialContext initialContext = new InitialContext();
                this.connectionFactory = (ConnectionFactory)initialContext.lookup(jndiConnectionName);
            }
            catch (NamingException e) {
                LOG.error("CIC000307_Error_retrieving_JCA_connection_factory", new Object[]{e.getMessage()}, e);
                throw new ConnectionException("CIC000307_Error_retrieving_JCA_connection_factory", new Object[]{e.getMessage()}, e);
            }
            if (this.connectionFactory == null) {
                LOG.error("CIC000308_Lookup_failed", new Object[]{jndiConnectionName});
                throw new ConnectionException("CIC000308_Lookup_failed", new Object[]{jndiConnectionName});
            }
        }
    }

    public ClassLoader getConnectorClassLoader() throws ConnectionException {
        if (this.connectionFactory == null) {
            throw new ConnectionException("CIC000309_Null_connection_factory");
        }
        return this.connectionFactory.getClass().getClassLoader();
    }

    protected abstract Object createOutputMessage(ServiceContext var1, Record var2) throws ConnectionException;

    protected abstract InteractionSpec createInteractionSpec(ServiceContext var1) throws ConnectionException;

    protected abstract Record createOutputRecord(ServiceContext var1) throws ConnectionException;

    protected abstract Record createInputRecord(ServiceContext var1) throws ConnectionException;

    protected abstract ConnectionSpec createConnectionSpec(ServiceContext var1) throws ConnectionException;
}

