/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.coco.xsdbuilder;

import com.sun.encoder.coco.appinfo.CocoEncoding;
import com.sun.encoder.coco.appinfo.CocoEncodingMark;
import com.sun.encoder.coco.model.CocoDataModel;
import com.sun.encoder.coco.model.CocoDescriptionEntry;
import com.sun.encoder.coco.model.CocoLexer;
import com.sun.encoder.coco.model.CocoParser;
import com.sun.encoder.coco.runtime.messages.ErrorManager;
import com.sun.encoder.coco.runtime.messages.Message;
import com.sun.encoder.coco.runtime.messages.MessageCatalog;
import com.sun.encoder.coco.xsdbuilder.CocoXsdBuilderException;
import com.sun.encoder.coco.xsdbuilder.CocoXsdBuilderSpec;
import com.sun.encoder.frmwk.appinfo.EncodingMark;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.xb.xsdschema.AppinfoDocument;
import org.apache.xmlbeans.impl.xb.xsdschema.Element;
import org.apache.xmlbeans.impl.xb.xsdschema.Group;
import org.apache.xmlbeans.impl.xb.xsdschema.LocalComplexType;
import org.apache.xmlbeans.impl.xb.xsdschema.SchemaDocument;
import org.apache.xmlbeans.impl.xb.xsdschema.TopLevelElement;

public class CocoXsdBuilder {
    public static final String BUILDER_VERSION;
    private static final boolean mShowTrace;
    private CocoXsdBuilderSpec mSpec;
    private File mCopybookFile = null;
    private String mCopybookCharEncoding;
    private File mXsdFile = null;
    private String mTargetNamespace = null;
    private boolean mIgnoreExtraContent;
    private boolean mCheckReservedWord;
    private String mDisplayCharEncoding;
    private String mDisplay1CharEncoding;
    private final Map<CocoDescriptionEntry, SchemaNode> mEntriesToNodes;
    private final ErrorManager mErrorMgr = ErrorManager.getManager("OpenESB.encoder.COBOLCopybook." + this.getClass().getName());

    public CocoXsdBuilder() {
        this.mSpec = null;
        this.mEntriesToNodes = Collections.synchronizedMap(new HashMap(10000));
    }

    public CocoXsdBuilder(CocoXsdBuilderSpec spec) {
        this.validateSpec(spec);
        this.mSpec = spec;
        this.mEntriesToNodes = Collections.synchronizedMap(new HashMap(10000));
    }

    public void setOtdBuilderSpec(CocoXsdBuilderSpec spec) {
        this.validateSpec(spec);
        this.mSpec = spec;
    }

    public CocoXsdBuilderSpec getOtdBuilderSpec() {
        return this.mSpec;
    }

    private void validateSpec(CocoXsdBuilderSpec spec) throws IllegalArgumentException {
        String displayEncoding;
        if (spec == null) {
            return;
        }
        String copybookLocation = spec.getCopybookLocation();
        if (copybookLocation == null) {
            Message msg = MessageCatalog.getMessage("CCCB4012");
            String text = msg.toString();
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        File copybookFile = new File(copybookLocation);
        if (!copybookFile.canRead() || !copybookFile.isFile()) {
            Message msg = MessageCatalog.getMessage("CCCB4015");
            String text = msg.formatText(new Object[]{copybookFile.getAbsolutePath()});
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        String copybookEncoding = spec.getCopybookCharEncoding();
        if (copybookEncoding == null) {
            Message msg = MessageCatalog.getMessage("CCCB4013");
            String text = msg.toString();
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        String xsdLocation = spec.getXsdLocation();
        if (xsdLocation == null) {
            Message msg = MessageCatalog.getMessage("CCCB4014");
            String text = msg.toString();
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        String targetNamespace = spec.getTargetNamespace();
        if (targetNamespace != null) {
            try {
                new URI(targetNamespace);
            }
            catch (URISyntaxException e) {
                Message msg = MessageCatalog.getMessage("CCCB4017");
                String text = msg.formatText(new Object[]{targetNamespace});
                this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
                throw new IllegalArgumentException(text);
            }
        }
        if ((displayEncoding = spec.getDisplayCharEncoding()) == null) {
            Message msg = MessageCatalog.getMessage("CCCB4020");
            String text = msg.toString();
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        String display1Encoding = spec.getDisplay1CharEncoding();
        if (display1Encoding == null) {
            Message msg = MessageCatalog.getMessage("CCCB4021");
            String text = msg.toString();
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        this.mCopybookFile = copybookFile;
        this.mCopybookCharEncoding = copybookEncoding;
        this.mXsdFile = new File(xsdLocation);
        this.mTargetNamespace = targetNamespace;
        this.mIgnoreExtraContent = spec.getIgnoreContentBeyondCol72();
        this.mCheckReservedWord = spec.getCheckNamesForReservedWords();
        this.mDisplayCharEncoding = displayEncoding;
        this.mDisplay1CharEncoding = display1Encoding;
    }

    public void buildXsd() throws CocoXsdBuilderException, IllegalStateException {
        if (this.mSpec == null) {
            Message msg = MessageCatalog.getMessage("CCCB4018");
            String text = msg.toString();
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalStateException(text);
        }
        try {
            CocoLexer lexer = new CocoLexer(this.mCopybookFile, this.mCopybookCharEncoding);
            lexer.disable72ColumnLimit(!this.mIgnoreExtraContent);
            CocoParser parser = new CocoParser(lexer);
            parser.disableItemNameReservedWordChecking(!this.mCheckReservedWord);
            CocoDataModel model = null;
            model = parser.parse();
            if (mShowTrace && this.mXsdFile != null) {
                File tFile = File.createTempFile("CocoXsdBuilder", "debug", this.mXsdFile);
                PrintStream outStream = new PrintStream(new FileOutputStream(tFile));
                model.toStream(outStream);
                outStream.close();
            }
            SchemaDocument schemaDoc = SchemaDocument.Factory.newInstance();
            SchemaDocument.Schema schema = schemaDoc.addNewSchema();
            if (this.mTargetNamespace != null && this.mTargetNamespace.length() > 0) {
                schema.setTargetNamespace(this.mTargetNamespace);
            }
            this.createXsd(model, schema);
            XmlOptions options = new XmlOptions();
            options.setSaveAggressiveNamespaces();
            HashMap<String, String> prefixes = new HashMap<String, String>();
            prefixes.put("urn:com.sun:encoder", "enc");
            prefixes.put("urn:com.sun:encoder-coco-1.0", "coco");
            options.setSaveSuggestedPrefixes(prefixes);
            options.setSavePrettyPrint();
            options.setSavePrettyPrintIndent(4);
            options.setSavePrettyPrintOffset(0);
            options.setCharacterEncoding("UTF-8");
            schemaDoc.save(this.mXsdFile, options);
        }
        catch (Exception e) {
            throw new CocoXsdBuilderException(e.getLocalizedMessage(), e);
        }
    }

    private void createXsd(CocoDataModel model, SchemaDocument.Schema schema) throws CocoXsdBuilderException {
        this.populateEncodingMark(schema);
        this.growXsd(model.getRoot(), new SchemaNode(schema, null, null, null));
    }

    private void populateEncodingMark(SchemaDocument.Schema schema) {
        CocoEncodingMark encodingMark = CocoEncodingMark.Factory.newInstance();
        EncodingMark.Encoding encoding = encodingMark.addNewEncoding();
        encoding.setName("COBOL Copybook Encoder");
        encoding.setNamespace("urn:com.sun:encoder-coco-1.0");
        encoding.setStyle("cocoencoder-1.0");
        encodingMark.setCocoXsdBuilderVendor("SUNW");
        encodingMark.setCocoXsdBuilderVersion(BUILDER_VERSION);
        encodingMark.setCopybookCharEncoding(this.mCopybookCharEncoding);
        String inputFilename = null;
        try {
            inputFilename = this.mCopybookFile.getCanonicalPath();
        }
        catch (IOException ie) {
            inputFilename = this.mCopybookFile.getAbsolutePath();
        }
        encodingMark.setCopybookLocation(inputFilename);
        encodingMark.setIgnoreContentBeyondCol72(this.mIgnoreExtraContent);
        encodingMark.setCheckNamesForReservedWords(this.mCheckReservedWord);
        if (this.mXsdFile != null) {
            String outputFileName = null;
            try {
                outputFileName = this.mXsdFile.getCanonicalPath();
            }
            catch (IOException ie2) {
                outputFileName = this.mXsdFile.getAbsolutePath();
            }
            encodingMark.setXsdLocation(outputFileName);
        }
        AppinfoDocument.Appinfo appInfo = schema.addNewAnnotation().addNewAppinfo();
        appInfo.set((XmlObject)encodingMark);
        appInfo.setSource("urn:com.sun:encoder");
    }

    private void growXsd(CocoDescriptionEntry entry, SchemaNode base) throws CocoXsdBuilderException {
        SchemaNode newNode = this.growNode(entry, base);
        if (!entry.isElementary()) {
            for (int i = 0; i < entry.countChildren(); ++i) {
                this.growXsd(entry.getChild(i), newNode);
            }
        }
        this.plantRedefines(entry, newNode, base);
        this.plantOccursDependsOn(entry, newNode);
    }

    private void plantRedefines(CocoDescriptionEntry entry, SchemaNode entryElement, SchemaNode base) throws IndexOutOfBoundsException, CocoXsdBuilderException {
        for (int i = 0; i < entry.countRedefinitions(); ++i) {
            CocoDescriptionEntry redef = entry.getRedefinition(i);
            SchemaNode node = this.growNode(redef, base);
            this.setRedefine(node, entryElement.getElement());
            for (int c = 0; c < redef.countChildren(); ++c) {
                this.growXsd(redef.getChild(c), node);
            }
        }
    }

    private void setRedefine(SchemaNode redefineSubject, Element redefinedObject) {
        redefineSubject.getEncoding().setRedefine(redefinedObject.getName());
        redefineSubject.getElement().getAnnotation().getAppinfoArray(0).set((XmlObject)redefineSubject.getEncoding());
        XmlCursor cursor = redefinedObject.newCursor();
        cursor.setAttributeText(new QName("minOccurs"), "0");
        cursor.dispose();
        cursor = redefineSubject.getElement().newCursor();
        cursor.setAttributeText(new QName("minOccurs"), "0");
        cursor.dispose();
    }

    private void setOccursDependOn(SchemaNode entryNode, SchemaNode nodeBeingDepended) {
        CocoEncoding encoding = entryNode.getEncoding();
        CocoEncoding.OccursDependOn occurs = encoding.addNewOccursDependOn();
        QName qName = new QName(nodeBeingDepended.getSchema().getTargetNamespace(), nodeBeingDepended.getTopElement().getName());
        occurs.setTopElement(qName);
        occurs.setPath(nodeBeingDepended.getPath());
        entryNode.getElement().getAnnotation().getAppinfoArray(0).set((XmlObject)encoding);
    }

    private void plantOccursDependsOn(CocoDescriptionEntry entry, SchemaNode entryElement) throws CocoXsdBuilderException {
        CocoDescriptionEntry depends = entry.getOccursOn();
        if (null != depends) {
            SchemaNode refNode = this.mEntriesToNodes.get(depends);
            if (null != refNode) {
                this.setOccursDependOn(entryElement, refNode);
            } else {
                Message msg = MessageCatalog.getMessage("CCCB4102");
                String text = msg.formatText(new Object[]{depends.getName(), entryElement.getElement().getName()});
                this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
                throw new CocoXsdBuilderException(text);
            }
        }
    }

    Group getSequenceGroup(Element elem) {
        LocalComplexType cType = elem.isSetComplexType() ? elem.getComplexType() : elem.addNewComplexType();
        if (cType.isSetSequence()) {
            return cType.getSequence();
        }
        return cType.addNewSequence();
    }

    private SchemaNode growNode(CocoDescriptionEntry entry, SchemaNode base) {
        boolean isTop;
        String name = entry.getName();
        TopLevelElement elem = null;
        boolean bl = isTop = base.getElement() == null;
        if (isTop) {
            elem = base.getSchema().addNewElement();
            base.setTopElement((Element)elem);
        } else {
            elem = this.getSequenceGroup(base.getElement()).addNewElement();
        }
        elem.setName(name);
        if (!isTop) {
            XmlCursor cursor = elem.newCursor();
            cursor.toLastAttribute();
            cursor.toNextToken();
            cursor.insertAttributeWithValue(new QName("minOccurs"), String.valueOf(entry.getMinimumOccurs()));
            cursor.insertAttributeWithValue(new QName("maxOccurs"), String.valueOf(entry.getMaximumOccurs()));
            cursor.dispose();
        }
        CocoEncoding encoding = this.defineElement(entry, (Element)elem);
        if (isTop) {
            encoding.setTop(true);
            if (this.mSpec.getPreDecodeCharCoding() != null) {
                encoding.setPreDecodeCharCoding(this.mSpec.getPreDecodeCharCoding());
            }
            if (this.mSpec.getPostEncodeCharCoding() != null) {
                encoding.setPostEncodeCharCoding(this.mSpec.getPostEncodeCharCoding());
            }
            encoding.setDisplayCharEncoding(this.mDisplayCharEncoding);
            encoding.setDisplay1CharEncoding(this.mDisplay1CharEncoding);
            elem.getAnnotation().getAppinfoArray(0).set((XmlObject)encoding);
        }
        SchemaNode node = base.getElement() == null ? new SchemaNode(base.getSchema(), (Element)elem, "", encoding) : new SchemaNode(base.getSchema(), (Element)elem, base.getPath().length() == 0 ? name : base.getPath() + "/" + name, encoding);
        node.setTopElement(base.getTopElement());
        this.mEntriesToNodes.put(entry, node);
        return node;
    }

    private CocoEncoding defineElement(CocoDescriptionEntry entry, Element elem) {
        return entry.toElement(elem);
    }

    static {
        int pos2;
        String ver = "$Revision: 1.2 $";
        int pos1 = ver.lastIndexOf(58) + 2;
        if (pos1 < (pos2 = ver.lastIndexOf(36) - 1)) {
            ver = ver.substring(pos1, pos2).trim();
        }
        BUILDER_VERSION = ver;
        mShowTrace = "true".equals(System.getProperty("sun.encoder.coco.showtrace"));
    }

    private class SchemaNode {
        private final SchemaDocument.Schema mSchema;
        private final Element mElem;
        private final String mPath;
        private final CocoEncoding mEncoding;
        private Element mTopElement;

        public SchemaNode(SchemaDocument.Schema schema, Element elem, String path, CocoEncoding encoding) {
            this.mSchema = schema;
            this.mElem = elem;
            this.mPath = path;
            this.mEncoding = encoding;
        }

        public SchemaDocument.Schema getSchema() {
            return this.mSchema;
        }

        public Element getElement() {
            return this.mElem;
        }

        public String getPath() {
            return this.mPath;
        }

        public CocoEncoding getEncoding() {
            return this.mEncoding;
        }

        public void setTopElement(Element topElem) {
            this.mTopElement = topElem;
        }

        public Element getTopElement() {
            return this.mTopElement;
        }
    }
}

