/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4ejb.configuration;

import it.imolinfo.jbi4ejb.Logger;
import it.imolinfo.jbi4ejb.LoggerFactory;
import it.imolinfo.jbi4ejb.exception.EJBWSDLGenerationException;
import it.imolinfo.jbi4ejb.webservice.generator.JarUtil;
import it.imolinfo.jbi4ejb.webservice.generator.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InterfaceExtractorUtil {
    private static final String EAR_TEMP_DIR = "EAR_";
    private static final String REMOTE = "remote";
    private static final String STATELESS = "Stateless";
    private static final String SESSION_TYPE = "session-type";
    private static final String SESSION = "session";
    private static final String EJB = "ejb";
    private static final String APPLICATION_XML = "application.xml";
    private static final Logger LOG = LoggerFactory.getLogger(InterfaceExtractorUtil.class);

    private InterfaceExtractorUtil() {
    }

    public static List<String> extractRemoteInterfacesFromEar(String earPath) throws EJBWSDLGenerationException {
        File tempDir;
        try {
            tempDir = File.createTempFile(EAR_TEMP_DIR, null);
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            throw new EJBWSDLGenerationException(e);
        }
        tempDir.delete();
        tempDir.mkdir();
        try {
            JarUtil.unjar(new File(earPath), tempDir);
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            throw new EJBWSDLGenerationException(e);
        }
        File applicationXml = InterfaceExtractorUtil.findSingleFile(tempDir.getAbsolutePath(), APPLICATION_XML);
        if (applicationXml == null) {
            String msg = "No application.xml found in ear: " + earPath;
            LOG.error(msg);
            throw new EJBWSDLGenerationException(msg);
        }
        List<String> jarList = InterfaceExtractorUtil.getEjbJarFromApplicationXML(applicationXml);
        ArrayList<String> remoteInterfaces = new ArrayList<String>();
        for (String jarName : jarList) {
            File jarFile = InterfaceExtractorUtil.findSingleFile(tempDir.getAbsolutePath(), jarName);
            remoteInterfaces.addAll(InterfaceExtractorUtil.extractRemoteInterfaceFromJar(jarFile.getAbsolutePath()));
        }
        tempDir.delete();
        return remoteInterfaces;
    }

    public static List<String> extractRemoteInterfaceFromJar(String jarPath) throws EJBWSDLGenerationException {
        File tempDir;
        ArrayList<String> remoteInterfaces = new ArrayList<String>();
        try {
            tempDir = File.createTempFile("JAR_", null);
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            throw new EJBWSDLGenerationException(e);
        }
        tempDir.delete();
        tempDir.mkdir();
        try {
            JarUtil.unjar(new File(jarPath), tempDir);
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            throw new EJBWSDLGenerationException(e);
        }
        File ejbJarXml = InterfaceExtractorUtil.findSingleFile(tempDir.getAbsolutePath(), "ejb-jar.xml");
        List<Object> interfacesListFromEjbJar = new ArrayList();
        if (ejbJarXml != null) {
            interfacesListFromEjbJar = InterfaceExtractorUtil.getInterfacesFromEjbJarXml(ejbJarXml);
        }
        remoteInterfaces.addAll(interfacesListFromEjbJar);
        tempDir.delete();
        return remoteInterfaces;
    }

    private static File findSingleFile(String sourceDir, String fileName) throws EJBWSDLGenerationException {
        File applicationXml = null;
        List<File> files = Util.findFilesFromSourceDirectoryFromExactFileName(sourceDir, fileName);
        if (files.size() > 1) {
            String msg = "Found " + files.size() + " " + fileName + " files";
            throw new EJBWSDLGenerationException(msg);
        }
        if (files.size() != 0) {
            applicationXml = files.get(0);
        }
        return applicationXml;
    }

    private static List<String> getInterfacesFromEjbJarXml(File ejbJarXml) throws EJBWSDLGenerationException {
        ArrayList<String> interfacesList = new ArrayList<String>();
        Document doc = InterfaceExtractorUtil.getDocument(ejbJarXml);
        NodeList nodes = doc.getElementsByTagName(SESSION);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            NodeList sessionType = element.getElementsByTagName(SESSION_TYPE);
            Element type = (Element)sessionType.item(0);
            if (!InterfaceExtractorUtil.getCharacterDataFromElement(type).equalsIgnoreCase(STATELESS)) continue;
            LOG.debug("Found a stateless EJB");
            NodeList remoteElement = element.getElementsByTagName(REMOTE);
            Element remote = (Element)remoteElement.item(0);
            String remoteInterfaceName = InterfaceExtractorUtil.getCharacterDataFromElement(remote);
            LOG.debug("Found a stateless EJB with interface: " + remoteInterfaceName);
            interfacesList.add(remoteInterfaceName);
        }
        return interfacesList;
    }

    private static List<String> getEjbJarFromApplicationXML(File applicationXml) throws EJBWSDLGenerationException {
        ArrayList<String> jarList = new ArrayList<String>();
        Document doc = InterfaceExtractorUtil.getDocument(applicationXml);
        NodeList nodes = doc.getElementsByTagName(EJB);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            String ejbJarName = InterfaceExtractorUtil.getCharacterDataFromElement(element);
            jarList.add(ejbJarName);
        }
        return jarList;
    }

    private static String getCharacterDataFromElement(Element e) {
        Node child = e.getFirstChild();
        if (child instanceof CharacterData) {
            CharacterData cd = (CharacterData)child;
            return cd.getData();
        }
        return "";
    }

    private static Document getDocument(File file) throws EJBWSDLGenerationException {
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(file);
        }
        catch (ParserConfigurationException e) {
            String msg = e.getMessage();
            LOG.error(msg);
            throw new EJBWSDLGenerationException(e);
        }
        catch (IOException e) {
            String msg = e.getMessage();
            LOG.error(msg);
            throw new EJBWSDLGenerationException(e);
        }
        catch (SAXException e) {
            String msg = e.getMessage();
            LOG.error(msg);
            throw new EJBWSDLGenerationException(e);
        }
        return doc;
    }

    public static String extractEarClassesInTempDirectory(String earPath) throws EJBWSDLGenerationException {
        File tempDir;
        try {
            tempDir = File.createTempFile(EAR_TEMP_DIR, null);
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            throw new EJBWSDLGenerationException(e);
        }
        tempDir.delete();
        tempDir.mkdir();
        try {
            JarUtil.unjar(new File(earPath), tempDir);
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            throw new EJBWSDLGenerationException(e);
        }
        File applicationXml = InterfaceExtractorUtil.findSingleFile(tempDir.getAbsolutePath(), APPLICATION_XML);
        if (applicationXml == null) {
            String msg = "No application.xml found in ear: " + earPath;
            LOG.error(msg);
            throw new EJBWSDLGenerationException(msg);
        }
        List<String> jarList = InterfaceExtractorUtil.getEjbJarFromApplicationXML(applicationXml);
        for (String jarName : jarList) {
            LOG.info("Found ejb-jar: " + jarName);
            File jarFile = InterfaceExtractorUtil.findSingleFile(tempDir.getAbsolutePath(), jarName);
            try {
                JarUtil.unjar(jarFile, tempDir);
            }
            catch (IOException e) {
                LOG.error(e.getMessage());
                throw new EJBWSDLGenerationException(e);
            }
        }
        return tempDir.getAbsolutePath();
    }
}

