/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.instruments;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.instruments.AbstractGraduatedScale;
import com.nwoods.jgo.instruments.DoubleRef;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class GraduatedScaleLinear
extends AbstractGraduatedScale {
    public static final int ChangedStartPoint = 13200;
    public static final int ChangedEndPoint = 13201;
    private Point v = new Point(0, 0);
    private Point s = new Point(0, 0);
    private float u = 0.0f;
    private float w = 0.0f;
    private float r = 0.0f;
    private float t = 0.0f;

    public JGoObject copyObject(JGoCopyEnvironment jGoCopyEnvironment) {
        GraduatedScaleLinear graduatedScaleLinear = (GraduatedScaleLinear)super.copyObject(jGoCopyEnvironment);
        graduatedScaleLinear.v.x = this.v.x;
        graduatedScaleLinear.v.y = this.v.y;
        graduatedScaleLinear.s.x = this.s.x;
        graduatedScaleLinear.s.y = this.s.y;
        graduatedScaleLinear.u = this.u;
        graduatedScaleLinear.w = this.w;
        graduatedScaleLinear.r = this.r;
        graduatedScaleLinear.t = this.t;
        return graduatedScaleLinear;
    }

    public Point getStartPoint() {
        return this.v;
    }

    public void setStartPoint(Point point) {
        int n = this.v.x;
        int n2 = this.v.y;
        if (n != point.x || n2 != point.y) {
            this.v.x = point.x;
            this.v.y = point.y;
            this.resetPath();
            this.adjustTickOffset();
            this.setBoundingRectInvalid(true);
            this.update(13200, 0, new Point(n, n2));
        }
    }

    public Point getEndPoint() {
        return this.s;
    }

    public void setEndPoint(Point point) {
        int n = this.s.x;
        int n2 = this.s.y;
        if (n != point.x || n2 != point.y) {
            this.s.x = point.x;
            this.s.y = point.y;
            this.resetPath();
            this.adjustTickOffset();
            this.setBoundingRectInvalid(true);
            this.update(13201, 0, new Point(n, n2));
        }
    }

    public void setTickLengthLeft(float f) {
        float f2 = this.getTickLengthLeft();
        super.setTickLengthLeft(f);
        if (f2 != this.getTickLengthLeft()) {
            this.adjustTickOffset();
        }
    }

    public void setTickLengthRight(float f) {
        float f2 = this.getTickLengthRight();
        super.setTickLengthRight(f);
        if (f2 != this.getTickLengthRight()) {
            this.adjustTickOffset();
        }
    }

    public boolean getIntersectionWithLine(Point2D.Float float_, Point2D.Float float_2, DoubleRef doubleRef) {
        Point point = this.getStartPoint();
        Point point2 = this.getEndPoint();
        Point2D.Float float_3 = new Point2D.Float();
        boolean bl = GraduatedScaleLinear.getNearestIntersectionOnLine(point.x, point.y, point2.x, point2.y, float_.x, float_.y, float_2.x, float_2.y, float_3);
        doubleRef.value = this.getValueAtPoint(float_3);
        return bl;
    }

    public double getValueAtPoint(Point2D.Float float_) {
        Point point = this.getStartPoint();
        Point point2 = this.getEndPoint();
        Point2D.Float float_2 = new Point2D.Float();
        GraduatedScaleLinear.getNearestPointOnLine(point.x, point.y, point2.x, point2.y, float_.x, float_.y, float_2);
        double d = this.getMinimum();
        double d2 = this.getMaximum();
        if (point.x == point2.x && point.y == point2.y) {
            return d;
        }
        if (point.x == point2.x) {
            return d + (d2 - d) * (double)(float_2.y - (float)point.y) / (double)(point2.y - point.y);
        }
        return d + (d2 - d) * (double)(float_2.x - (float)point.x) / (double)(point2.x - point.x);
    }

    public Point2D.Float getPointForValue(double d) {
        Point point = this.getStartPoint();
        double d2 = this.getMinimum();
        if (d == d2) {
            return new Point2D.Float(point.x, point.y);
        }
        Point point2 = this.getEndPoint();
        double d3 = this.getMaximum();
        if (d == d3) {
            return new Point2D.Float(point2.x, point2.y);
        }
        if (d2 == d3) {
            return new Point2D.Float(point.x, point.y);
        }
        if (point.x == point2.x && point.y == point2.y) {
            return new Point2D.Float(point.x, point.y);
        }
        double d4 = (d - d2) / (d3 - d2);
        return new Point2D.Float((float)((double)point.x + (double)(point2.x - point.x) * d4), (float)((double)point.y + (double)(point2.y - point.y) * d4));
    }

    protected Rectangle computeBoundingRect() {
        Point point = this.getStartPoint();
        Point point2 = this.getEndPoint();
        Rectangle rectangle = new Rectangle();
        rectangle.x = Math.min(point.x, point2.x);
        rectangle.y = Math.min(point.y, point2.y);
        rectangle.width = Math.abs(point.x - point2.x);
        rectangle.height = Math.abs(point.y - point2.y);
        return rectangle;
    }

    protected void geometryChange(Rectangle rectangle) {
        super.geometryChange(rectangle);
        int n = this.getLeft();
        int n2 = this.getTop();
        int n3 = this.getStartPoint().x;
        int n4 = this.getStartPoint().y;
        int n5 = n3;
        int n6 = n4;
        int n7 = this.getEndPoint().x;
        int n8 = this.getEndPoint().y;
        int n9 = n7;
        int n10 = n8;
        n3 += n - rectangle.x;
        n7 += n - rectangle.x;
        n4 += n2 - rectangle.y;
        n8 += n2 - rectangle.y;
        if (rectangle.width != this.getWidth() && rectangle.width != 0) {
            n3 = (int)((float)this.getWidth() / (float)rectangle.width * (float)(n3 - n) + (float)n);
            n7 = (int)((float)this.getWidth() / (float)rectangle.width * (float)(n7 - n) + (float)n);
        }
        if (rectangle.height != this.getHeight() && rectangle.height != 0) {
            n4 = (int)((float)this.getHeight() / (float)rectangle.height * (float)(n4 - n2) + (float)n2);
            n8 = (int)((float)this.getHeight() / (float)rectangle.height * (float)(n8 - n2) + (float)n2);
        }
        this.setBoundingRectInvalid(false);
        if (n5 != n3 || n6 != n4) {
            this.v.x = n3;
            this.v.y = n4;
            this.resetPath();
            this.adjustTickOffset();
            this.update(13200, 0, new Point(n5, n6));
        }
        if (n9 != n7 || n10 != n8) {
            this.s.x = n7;
            this.s.y = n8;
            this.resetPath();
            this.adjustTickOffset();
            this.update(13201, 0, new Point(n9, n10));
        }
    }

    protected Rectangle handleResize(Graphics2D graphics2D, JGoView jGoView, Rectangle rectangle, Point point, int n, int n2, int n3, int n4) {
        if (n >= 100) {
            if (n == 100) {
                this.setStartPoint(point);
            } else {
                this.setEndPoint(point);
            }
            return null;
        }
        return super.handleResize(graphics2D, jGoView, rectangle, point, n, n2, n3, n4);
    }

    protected void gainedSelection(JGoSelection jGoSelection) {
        if (!this.isResizable()) {
            jGoSelection.createBoundingHandle((JGoObject)this);
        } else {
            Point point = this.getStartPoint();
            Point point2 = this.getEndPoint();
            jGoSelection.createResizeHandle((JGoObject)this, point.x, point.y, 100, true);
            jGoSelection.createResizeHandle((JGoObject)this, point2.x, point2.y, 101, true);
        }
    }

    public boolean isPointInObj(Point point) {
        GeneralPath generalPath = new GeneralPath();
        Point point2 = this.getEndPoint();
        Point point3 = this.getStartPoint();
        float f = (float)point2.x + this.u;
        float f2 = (float)point2.y + this.w;
        float f3 = (float)point2.x + this.r;
        float f4 = (float)point2.y + this.t;
        float f5 = (float)point3.x + this.r;
        float f6 = (float)point3.y + this.t;
        float f7 = (float)point3.x + this.u;
        float f8 = (float)point3.y + this.w;
        generalPath.moveTo(f, f2);
        generalPath.lineTo(f3, f4);
        generalPath.lineTo(f5, f6);
        generalPath.lineTo(f7, f8);
        generalPath.lineTo(f, f2);
        boolean bl = generalPath.contains(point);
        return bl;
    }

    protected void computePath(GeneralPath generalPath) {
        Point point = this.getStartPoint();
        generalPath.moveTo(point.x, point.y);
        Point point2 = this.getEndPoint();
        generalPath.lineTo(point2.x, point2.y);
    }

    protected void adjustTickOffset() {
        float f = this.getTickLengthLeft();
        float f2 = this.getTickLengthRight();
        Point point = this.getStartPoint();
        Point point2 = this.getEndPoint();
        if (point.x == point2.x) {
            if (point2.y < point.y) {
                this.u = -f;
                this.w = 0.0f;
                this.r = f2;
                this.t = 0.0f;
            } else {
                this.u = -f2;
                this.w = 0.0f;
                this.r = f;
                this.t = 0.0f;
            }
        } else if (point.y == point2.y) {
            if (point2.x < point.x) {
                this.u = 0.0f;
                this.w = f;
                this.r = 0.0f;
                this.t = -f2;
            } else {
                this.u = 0.0f;
                this.w = f2;
                this.r = 0.0f;
                this.t = -f;
            }
        } else {
            float f3 = (float)(-(point2.x - point.x)) / (float)(point2.y - point.y);
            float f4 = (float)Math.sqrt(f * f3 * (f * f3) / (1.0f + f3 * f3));
            float f5 = (float)Math.sqrt(f2 * f3 * (f2 * f3) / (1.0f + f3 * f3));
            if (point2.x < point.x) {
                this.u = f4 / f3;
                this.w = f4;
                this.r = -f5 / f3;
                this.t = -f5;
            } else {
                this.u = -f4 / f3;
                this.w = -f4;
                this.r = f5 / f3;
                this.t = f5;
            }
        }
    }

    public void getTickEnds(double d, boolean bl, Point2D.Float float_, Point2D.Float float_2) {
        Point2D.Float float_3 = this.getPointForValue(d);
        float f = this.u;
        float f2 = this.w;
        float f3 = this.r;
        float f4 = this.t;
        if (bl) {
            float f5 = this.getTickMajorLengthRatio();
            f *= f5;
            f2 *= f5;
            f3 *= f5;
            f4 *= f5;
        }
        float_.x = float_3.x + f;
        float_.y = float_3.y + f2;
        float_2.x = float_3.x + f3;
        float_2.y = float_3.y + f4;
    }

    public Point getLabelCenter(double d, boolean bl) {
        Point2D.Float float_ = this.getPointForValue(d);
        Point point = this.getStartPoint();
        Point point2 = this.getEndPoint();
        Point point3 = new Point();
        float f = bl ? this.getTickLengthLeft() : -this.getTickLengthRight();
        f = f != 0.0f ? f * 2.0f + GraduatedScaleLinear.do(f) * (float)this.getLabelDistance() : (float)((bl ? 1 : -1) * this.getLabelDistance());
        if (point2.x == point.x) {
            point3.x = (int)((float)GraduatedScaleLinear.do(point2.y - point.y) * f + float_.x);
            point3.y = (int)float_.y;
        } else if (point2.y == point.y) {
            point3.x = (int)float_.x;
            point3.y = (int)((float)GraduatedScaleLinear.do(point.x - point2.x) * f + float_.y);
        } else {
            float f2 = (float)(-(point2.x - point.x)) / (float)(point2.y - point.y);
            float f3 = GraduatedScaleLinear.do(f2) * GraduatedScaleLinear.do(f) * (float)GraduatedScaleLinear.do(point.x - point2.x) * (float)Math.sqrt(f * f / (1.0f + f2 * f2));
            point3.x = (int)(float_.x + f3);
            point3.y = (int)(float_.y + f3 * f2);
        }
        return point3;
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 13200: {
                jGoDocumentChangedEdit.setNewValue((Object)new Point(this.getStartPoint()));
                return;
            }
            case 13201: {
                jGoDocumentChangedEdit.setNewValue((Object)new Point(this.getEndPoint()));
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 13200: {
                Point point = (Point)jGoDocumentChangedEdit.getValue(bl);
                this.v.x = point.x;
                this.v.y = point.y;
                this.resetPath();
                this.adjustTickOffset();
                return;
            }
            case 13201: {
                Point point = (Point)jGoDocumentChangedEdit.getValue(bl);
                this.s.x = point.x;
                this.s.y = point.y;
                this.resetPath();
                this.adjustTickOffset();
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.instruments.GraduatedScaleLinear", domElement);
            domElement2.setAttribute("startx", Integer.toString(this.v.x));
            domElement2.setAttribute("starty", Integer.toString(this.v.y));
            domElement2.setAttribute("endx", Integer.toString(this.s.x));
            domElement2.setAttribute("endy", Integer.toString(this.s.y));
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            String string = domElement2.getAttribute("startx");
            String string2 = domElement2.getAttribute("starty");
            this.v.x = Integer.parseInt(string);
            this.v.y = Integer.parseInt(string2);
            this.setStartPoint(new Point(this.v.x, this.v.y));
            String string3 = domElement2.getAttribute("endx");
            String string4 = domElement2.getAttribute("endy");
            this.s.x = Integer.parseInt(string3);
            this.s.y = Integer.parseInt(string4);
            this.setEndPoint(new Point(this.s.x, this.s.y));
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingElement());
            this.adjustTickOffset();
        }
        return domElement.getNextSibling();
    }
}

