/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sql.framework.utils;

import com.sun.sql.framework.exception.BaseException;
import com.sun.sql.framework.utils.Attribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AttributeMap {
    static final String LOG_CATEGORY = Attribute.class.getName();
    protected Map attributes = new HashMap();

    public Attribute get(String attrName) {
        return (Attribute)this.attributes.get(attrName);
    }

    public Object getAttributeValue(String attrName) {
        Attribute attr = this.get(attrName);
        return attr != null ? attr.getAttributeValue() : null;
    }

    public Collection keySet() {
        return this.attributes.keySet();
    }

    public void parseAttributeList(NodeList list) throws BaseException {
        for (int i = 0; i < list.getLength(); ++i) {
            Element elem;
            if (list.item(i).getNodeType() != 1 || !(elem = (Element)list.item(i)).getNodeName().equals("attr")) continue;
            Attribute attr = new Attribute();
            attr.parseXMLString(elem);
            this.attributes.put(attr.getAttributeName(), attr);
        }
    }

    public void put(String attrName, Object val) {
        Attribute attr = this.get(attrName);
        if (attr != null) {
            attr.setAttributeValue(val);
        } else {
            attr = new Attribute(attrName, val);
            this.attributes.put(attrName, attr);
        }
    }

    public String toXMLString(String prefix) {
        StringBuffer buf = new StringBuffer(100);
        for (Attribute attr : this.attributes.values()) {
            if (attr.getAttributeValue() == null) continue;
            buf.append(attr.toXMLString(prefix + "\t"));
        }
        return buf.toString();
    }
}

