/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import java.util.Calendar;
import java.util.GregorianCalendar;

public class TimeLib {
    public static final int MILLENIUM = -1000;
    public static final int CENTURY = -100;
    public static final int DECADE = -10;
    private static final double SECOND_MILLIS = 1000.0;
    private static final double MINUTE_MILLIS = 60000.0;
    private static final double HOUR_MILLIS = 3600000.0;
    private static final double DAY_MILLIS = 8.64054E7;
    private static final double WEEK_MILLIS = 6.048378E8;
    private static final double MONTH_MILLIS = 2.62989955845E9;
    private static final double YEAR_MILLIS = 3.157253316E10;
    private static final double DECADE_MILLIS = 3.157253316E11;
    private static final double CENTURY_MILLIS = 3.157253316E12;
    private static final double MILLENIUM_MILLIS = 3.157253316E13;
    private static final int[] CALENDAR_FIELDS = new int[]{1, 2, 5, 11, 12, 13, 14};

    private TimeLib() {
    }

    public static int getUnitsBetween(long t0, long t1, int field) {
        boolean negative = false;
        if (t1 < t0) {
            long tmp = t1;
            t1 = t0;
            t0 = tmp;
            negative = true;
        }
        GregorianCalendar gc1 = new GregorianCalendar();
        GregorianCalendar gc2 = new GregorianCalendar();
        gc1.setTimeInMillis(t0);
        gc2.setTimeInMillis(t1);
        int est = TimeLib.estimateUnitsBetween(t0, t1, field);
        boolean multiYear = TimeLib.isMultiYear(field);
        if (multiYear) {
            gc1.add(1, -field * (est - 2));
            est = -field * est;
        } else {
            gc1.add(field, est - 2);
        }
        int f = multiYear ? 1 : field;
        int inc = multiYear ? -field : 1;
        int i = est - inc;
        while (true) {
            gc1.add(f, inc);
            if (gc1.after(gc2)) {
                return negative ? inc - i : i - inc;
            }
            i += inc;
        }
    }

    private static int estimateUnitsBetween(long t0, long t1, int field) {
        long d = t1 - t0;
        switch (field) {
            case 14: {
                return (int)d;
            }
            case 13: {
                return (int)((double)d / 1000.0 + 0.5);
            }
            case 12: {
                return (int)((double)d / 60000.0 + 0.5);
            }
            case 10: 
            case 11: {
                return (int)((double)d / 3600000.0 + 0.5);
            }
            case 5: 
            case 8: {
                return (int)((double)d / 8.64054E7 + 0.5);
            }
            case 3: {
                return (int)((double)d / 6.048378E8 + 0.5);
            }
            case 2: {
                return (int)((double)d / 2.62989955845E9 + 0.5);
            }
            case 1: {
                return (int)((double)d / 3.157253316E10 + 0.5);
            }
            case -10: {
                return (int)((double)d / 3.157253316E11 + 0.5);
            }
            case -100: {
                return (int)((double)d / 3.157253316E12 + 0.5);
            }
            case -1000: {
                return (int)((double)d / 3.157253316E13 + 0.5);
            }
        }
        return 0;
    }

    public static void increment(Calendar c, int field, int val) {
        if (TimeLib.isMultiYear(field)) {
            c.add(1, -field * val);
        } else {
            c.add(field, val);
        }
    }

    public static int get(Calendar c, int field) {
        if (TimeLib.isMultiYear(field)) {
            int y = c.get(1);
            return -field * (y / -field);
        }
        return c.get(field);
    }

    public static long getDate(Calendar c, int year, int month, int day) {
        c.clear(14);
        c.set(year, month, day, 0, 0, 0);
        return c.getTimeInMillis();
    }

    public static long getTime(Calendar c, int hour, int minute, int second) {
        c.clear(14);
        c.set(1970, 0, 1, hour, minute, second);
        return c.getTimeInMillis();
    }

    public static long getClearedTime(long t, Calendar c, int field) {
        c.setTimeInMillis(t);
        TimeLib.clearTo(c, field);
        return c.getTimeInMillis();
    }

    public static Calendar clearTo(Calendar c, int field) {
        for (int i = CALENDAR_FIELDS.length - 1; i >= 1 && field != CALENDAR_FIELDS[i]; --i) {
            int val = CALENDAR_FIELDS[i] == 5 ? 1 : 0;
            c.set(CALENDAR_FIELDS[i], val);
        }
        if (TimeLib.isMultiYear(field)) {
            int y = c.get(1);
            y = -field * (y / -field);
            c.set(1, y);
        }
        return c;
    }

    public static boolean isMultiYear(int field) {
        return field == -10 || field == -100 || field == -1000;
    }
}

