/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import prefuse.Display;
import prefuse.data.Schema;
import prefuse.util.ColorLib;
import prefuse.util.FontLib;
import prefuse.util.PrefuseConfig;
import prefuse.util.StringLib;
import prefuse.visual.VisualItem;

public class PrefuseLib {
    private static final String GROUP_DELIMITER = PrefuseConfig.get("data.delimiter");
    private static final double SIZE_SCALE_FACTOR = PrefuseConfig.getDouble("size.scale2D");
    public static final String FIELD_PREFIX = PrefuseConfig.get("data.visual.fieldPrefix");

    private PrefuseLib() {
    }

    public static String getMemoryUsageInKB() {
        long total = Runtime.getRuntime().totalMemory() / 2048L;
        long free = Runtime.getRuntime().freeMemory() / 2048L;
        long max = Runtime.getRuntime().maxMemory() / 2048L;
        return "Memory: " + (total - free) + "k / " + total + "k / " + max + "k";
    }

    public static String getMemoryUsageInMB() {
        long total = Runtime.getRuntime().totalMemory() / 0x200000L;
        long free = Runtime.getRuntime().freeMemory() / 0x200000L;
        long max = Runtime.getRuntime().maxMemory() / 0x200000L;
        return "Memory: " + (total - free) + "M / " + total + "M / " + max + "M";
    }

    public static String getDisplayStats(Display d) {
        float fr = (float)Math.round(d.getFrameRate() * 100.0) / 100.0f;
        Runtime rt = Runtime.getRuntime();
        long tm = rt.totalMemory() / 0x200000L;
        long fm = rt.freeMemory() / 0x200000L;
        long mm = rt.maxMemory() / 0x200000L;
        StringBuffer sb = new StringBuffer();
        sb.append("frame rate: ").append(fr).append("fps - ");
        sb.append(d.getVisibleItemCount()).append(" items - ");
        sb.append("fonts(").append(FontLib.getCacheMissCount());
        sb.append(") colors(");
        sb.append(ColorLib.getCacheMissCount()).append(')');
        sb.append(" mem(");
        sb.append(tm - fm).append("M / ");
        sb.append(mm).append("M)");
        sb.append(" (x:");
        sb.append(StringLib.formatNumber(d.getDisplayX(), 2));
        sb.append(", y:");
        sb.append(StringLib.formatNumber(d.getDisplayY(), 2));
        sb.append(", z:");
        sb.append(StringLib.formatNumber(d.getScale(), 5)).append(")");
        return sb.toString();
    }

    public static double getSize2D(double size) {
        return Math.pow(size, SIZE_SCALE_FACTOR);
    }

    public static double distance(VisualItem vi1, VisualItem vi2) {
        double dx = vi1.getX() - vi2.getX();
        double dy = vi1.getY() - vi2.getY();
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static void update(VisualItem item, String field, Object val) {
        item.set(PrefuseLib.getStartField(field), item.get(field));
        item.set(field, val);
        item.set(PrefuseLib.getEndField(field), val);
    }

    public static void updateInt(VisualItem item, String field, int val) {
        item.setInt(PrefuseLib.getStartField(field), item.getInt(field));
        item.setInt(field, val);
        item.setInt(PrefuseLib.getEndField(field), val);
    }

    public static void updateLong(VisualItem item, String field, long val) {
        item.setLong(PrefuseLib.getStartField(field), item.getLong(field));
        item.setLong(field, val);
        item.setLong(PrefuseLib.getEndField(field), val);
    }

    public static void updateFloat(VisualItem item, String field, float val) {
        item.setFloat(PrefuseLib.getStartField(field), item.getFloat(field));
        item.setFloat(field, val);
        item.setFloat(PrefuseLib.getEndField(field), val);
    }

    public static void updateDouble(VisualItem item, String field, double val) {
        item.setDouble(PrefuseLib.getStartField(field), item.getDouble(field));
        item.setDouble(field, val);
        item.setDouble(PrefuseLib.getEndField(field), val);
    }

    public static void updateBoolean(VisualItem item, String field, boolean b) {
        item.setBoolean(PrefuseLib.getStartField(field), item.getBoolean(field));
        item.setBoolean(field, b);
        item.setBoolean(PrefuseLib.getEndField(field), b);
    }

    public static void updateVisible(VisualItem item, boolean val) {
        item.setStartVisible(item.isVisible());
        item.setVisible(val);
        item.setEndVisible(val);
    }

    public static void setX(VisualItem item, VisualItem referrer, double x) {
        double sx = item.getX();
        if (Double.isNaN(sx)) {
            sx = referrer != null ? referrer.getX() : x;
        }
        item.setStartX(sx);
        item.setEndX(x);
        item.setX(x);
    }

    public static void setY(VisualItem item, VisualItem referrer, double y) {
        double sy = item.getY();
        if (Double.isNaN(sy)) {
            sy = referrer != null ? referrer.getY() : y;
        }
        item.setStartY(sy);
        item.setEndY(y);
        item.setY(y);
    }

    public static boolean isChildGroup(String group) {
        return group.indexOf(GROUP_DELIMITER) != -1;
    }

    public static String getParentGroup(String group) {
        int idx = group.lastIndexOf(GROUP_DELIMITER);
        return idx < 0 ? null : group.substring(0, idx);
    }

    public static String getChildGroup(String group) {
        int idx = group.lastIndexOf(GROUP_DELIMITER);
        return idx < 0 ? null : group.substring(idx + 1);
    }

    public static String getGroupName(String parent, String child) {
        return parent + GROUP_DELIMITER + child;
    }

    public static String getStartField(String field) {
        return field + ":start";
    }

    public static String getEndField(String field) {
        return field + ":end";
    }

    public static Schema getVisualItemSchema() {
        Schema s = new Schema();
        s.addColumn(VisualItem.VALIDATED, Boolean.TYPE, Boolean.FALSE);
        s.addColumn(VisualItem.VISIBLE, Boolean.TYPE, Boolean.TRUE);
        s.addColumn(VisualItem.STARTVISIBLE, Boolean.TYPE, Boolean.FALSE);
        s.addColumn(VisualItem.ENDVISIBLE, Boolean.TYPE, Boolean.TRUE);
        s.addColumn(VisualItem.INTERACTIVE, Boolean.TYPE, Boolean.TRUE);
        s.addColumn(VisualItem.EXPANDED, Boolean.TYPE, Boolean.TRUE);
        s.addColumn(VisualItem.FIXED, Boolean.TYPE, Boolean.FALSE);
        s.addColumn(VisualItem.HIGHLIGHT, Boolean.TYPE, Boolean.FALSE);
        s.addColumn(VisualItem.HOVER, Boolean.TYPE, Boolean.FALSE);
        s.addInterpolatedColumn(VisualItem.X, Double.TYPE);
        s.addInterpolatedColumn(VisualItem.Y, Double.TYPE);
        s.addColumn(VisualItem.BOUNDS, Rectangle2D.class, new Rectangle2D.Double());
        Integer defStroke = new Integer(ColorLib.rgba(0, 0, 0, 0));
        s.addInterpolatedColumn(VisualItem.STROKECOLOR, Integer.TYPE, defStroke);
        Integer defFill = new Integer(ColorLib.rgba(0, 0, 0, 0));
        s.addInterpolatedColumn(VisualItem.FILLCOLOR, Integer.TYPE, defFill);
        Integer defTextColor = new Integer(ColorLib.rgba(0, 0, 0, 0));
        s.addInterpolatedColumn(VisualItem.TEXTCOLOR, Integer.TYPE, defTextColor);
        s.addInterpolatedColumn(VisualItem.SIZE, Double.TYPE, new Double(1.0));
        s.addColumn(VisualItem.SHAPE, Integer.TYPE, new Integer(0));
        s.addColumn(VisualItem.STROKE, Stroke.class, new BasicStroke());
        Font defFont = FontLib.getFont("SansSerif", 0, 10);
        s.addInterpolatedColumn(VisualItem.FONT, Font.class, defFont);
        s.addColumn(VisualItem.DOI, Double.TYPE, new Double(Double.MIN_VALUE));
        return s;
    }

    public static Schema getMinimalVisualSchema() {
        Schema s = new Schema();
        s.addColumn(VisualItem.VALIDATED, Boolean.TYPE, Boolean.FALSE);
        s.addColumn(VisualItem.VISIBLE, Boolean.TYPE, Boolean.TRUE);
        s.addColumn(VisualItem.STARTVISIBLE, Boolean.TYPE, Boolean.FALSE);
        s.addColumn(VisualItem.ENDVISIBLE, Boolean.TYPE, Boolean.TRUE);
        s.addColumn(VisualItem.INTERACTIVE, Boolean.TYPE, Boolean.TRUE);
        s.addColumn(VisualItem.BOUNDS, Rectangle2D.class, new Rectangle2D.Double());
        return s;
    }

    public static Schema getAxisLabelSchema() {
        Schema s = PrefuseLib.getVisualItemSchema();
        s.setDefault(VisualItem.STARTVISIBLE, (Object)Boolean.FALSE);
        Integer defColor = new Integer(ColorLib.gray(230));
        s.setInterpolatedDefault(VisualItem.STROKECOLOR, defColor);
        defColor = new Integer(ColorLib.gray(150));
        s.setInterpolatedDefault(VisualItem.TEXTCOLOR, defColor);
        Double nan = new Double(Double.NaN);
        s.addInterpolatedColumn(VisualItem.X2, Double.TYPE);
        s.addInterpolatedColumn(VisualItem.Y2, Double.TYPE);
        s.addColumn(VisualItem.LABEL, String.class);
        s.addColumn(VisualItem.VALUE, Double.TYPE, nan);
        return s;
    }
}

