/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.workflow.model.utl;

import com.sun.jbi.workflow.model.ModelException;
import com.sun.jbi.workflow.model.utl.Messages;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtil {
    private static final Messages MESSAGES = Messages.getMessages(ModelUtil.class);
    private static Pattern QNAME_PATTERN = Pattern.compile(":");
    public static final String XMLNS = "xmlns";
    public static final String DEFAULT_NS = "DEFAULT_NS";

    public static QName getQName(String prefixedString, Map nameSpaceMap) throws ModelException {
        if (nameSpaceMap == null) {
            throw new ModelException(MESSAGES.getString("ModelUtil.Invalid_QName", new String[]{prefixedString, nameSpaceMap.toString()}));
        }
        String[] qn = QNAME_PATTERN.split(prefixedString, 2);
        String prefix = "";
        String localName = "";
        if (qn.length == 2) {
            prefix = qn[0];
            localName = qn[1];
        } else if (qn.length == 1) {
            localName = qn[0];
        }
        String uri = (String)nameSpaceMap.get(prefix);
        if (uri == null) {
            throw new ModelException(MESSAGES.getString("ModelUtil.Invalid_QName", new String[]{prefixedString, nameSpaceMap.toString()}));
        }
        return new QName(uri, localName);
    }

    public static void addToNSMap(String prefixedName, String value, Map<String, String> nameSpaceMap) {
        if (!prefixedName.startsWith(XMLNS)) {
            return;
        }
        String[] qn = QNAME_PATTERN.split(prefixedName, 2);
        String prefix = null;
        if (qn.length == 2) {
            prefix = qn[1];
        }
        if (prefix != null) {
            nameSpaceMap.put(prefix, value);
        } else {
            nameSpaceMap.put(DEFAULT_NS, value);
        }
    }
}

