/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.util;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.primitives.IntCollection;
import org.apache.commons.collections.primitives.IntList;
import org.apache.commons.collections.primitives.IntListIterator;
import org.axiondb.io.AxionFileSystem;
import org.axiondb.util.BTreeMetaData;
import org.axiondb.util.BaseBTree;
import org.axiondb.util.IntListIteratorChain;
import org.axiondb.util.NullObject;

public class ObjectBTree
extends BaseBTree {
    private final Comparator _comparator;
    private List _keys = new ArrayList(this.getMinimizationFactor());

    public ObjectBTree(File idxDir, String idxName, int minimizationFactor, Comparator comp) throws IOException, ClassNotFoundException {
        super(idxDir, idxName, minimizationFactor);
        this._comparator = comp;
        if (null != this.getBTreeMetaData().getDataDirectory() && this.getBTreeMetaData().getCounterFile().exists()) {
            this.setFileId(0);
            this.getBTreeMetaData().loadCounter();
            this.read();
        } else {
            this.getBTreeMetaData().assignFileId(this);
        }
    }

    protected ObjectBTree(BTreeMetaData meta, Comparator comp) throws IOException, ClassNotFoundException {
        super(meta);
        this._comparator = comp;
        meta.assignFileId(this);
    }

    protected ObjectBTree(BTreeMetaData meta, Comparator comp, int fileId) throws IOException, ClassNotFoundException {
        super(meta);
        this._comparator = comp;
        this.setFileId(fileId);
        this.read();
    }

    public final void clearData() {
        this.getKeys().clear();
        super.clearData();
    }

    public final void delete(Object key, int rowid) throws IOException, ClassNotFoundException {
        if (this.size() <= 0) {
            return;
        }
        int i = this.findNearestKeyBelow(key, rowid);
        if (i >= 0 && this.isEqual(this.getKey(i), key) && this.getValue(i) != rowid) {
            int pivotLoc = i;
            if (!this.isLeaf()) {
                if (pivotLoc > 0 && this.getChild(pivotLoc - 1).size() >= this.getMinimizationFactor()) {
                    this.borrowLeft(pivotLoc);
                    this.deleteFromChild(pivotLoc, key, rowid);
                } else if (pivotLoc + 1 < this.getChildIds().size() && this.getChild(pivotLoc + 1).size() >= this.getMinimizationFactor()) {
                    this.borrowRight(pivotLoc);
                    this.deleteFromChild(pivotLoc, key, rowid);
                } else {
                    int mergeLoc = pivotLoc < this.size() ? pivotLoc : pivotLoc - 1;
                    this.mergeChildren(mergeLoc, this.getKey(mergeLoc));
                    this.maybeCollapseTree();
                    this.delete(key, rowid);
                }
            }
        } else if (i < 0 && this.isNotEqual(this.getKey(i + 1), key) || this.isNotEqual(this.getKey(i), key)) {
            int pivotLoc = i + 1;
            if (!this.isLeaf() && this.getChild(pivotLoc).size() < this.getMinimizationFactor()) {
                if (pivotLoc > 0 && this.getChild(pivotLoc - 1).size() >= this.getMinimizationFactor()) {
                    this.borrowLeft(pivotLoc);
                    this.deleteFromChild(pivotLoc, key, rowid);
                } else if (pivotLoc + 1 < this.getChildIds().size() && this.getChild(pivotLoc + 1).size() >= this.getMinimizationFactor()) {
                    this.borrowRight(pivotLoc);
                    this.deleteFromChild(pivotLoc, key, rowid);
                } else {
                    int mergeLoc = pivotLoc < this.size() ? pivotLoc : pivotLoc - 1;
                    this.mergeChildren(mergeLoc, this.getKey(mergeLoc));
                    this.maybeCollapseTree();
                    this.delete(key, rowid);
                }
            } else {
                this.deleteFromChild(i + 1, key, rowid);
            }
        } else if (this.isLeaf()) {
            this.removeKeyValuePairAt(i);
        } else if (this.getChild(i).size() >= this.getMinimizationFactor()) {
            Object[] keyParam = new Object[1];
            int[] valueParam = new int[1];
            this.getChild(i).getRightMost(keyParam, valueParam);
            this.setKeyValuePairAt(i, keyParam[0], valueParam[0]);
            this.deleteFromChild(i, keyParam[0], valueParam[0]);
        } else if (this.getChild(i + 1).size() >= this.getMinimizationFactor()) {
            Object[] keyParam = new Object[1];
            int[] valueParam = new int[1];
            this.getChild(i + 1).getLeftMost(keyParam, valueParam);
            this.setKeyValuePairAt(i, keyParam[0], valueParam[0]);
            this.deleteFromChild(i + 1, keyParam[0], valueParam[0]);
        } else {
            this.mergeChildren(i, key);
            this.deleteFromChild(i, key, rowid);
            this.maybeCollapseTree();
        }
    }

    public final Integer get(Object key) throws IOException, ClassNotFoundException {
        Integer result = null;
        int i = this.findNearestKeyAbove(key);
        if (i < this.size() && this.isEqual(key, this.getKey(i))) {
            result = new Integer(this.getValue(i));
        } else if (!this.isLeaf()) {
            result = this.getChild(i).get(key);
        }
        return result;
    }

    public final IntListIterator getAll(Object key) throws IOException, ClassNotFoundException {
        IntListIteratorChain chain = new IntListIteratorChain();
        this.getAll(key, chain);
        return chain;
    }

    public final IntListIterator getAllExcludingNull() throws IOException, ClassNotFoundException {
        IntListIteratorChain chain = new IntListIteratorChain();
        this.getAllExcludingNull(chain);
        return chain;
    }

    public final IntListIterator getAllFrom(Object key) throws IOException, ClassNotFoundException {
        IntListIteratorChain chain = new IntListIteratorChain();
        this.getAllFrom(key, chain);
        return chain;
    }

    public final IntListIterator getAllTo(Object key) throws IOException, ClassNotFoundException {
        IntListIteratorChain chain = new IntListIteratorChain();
        this.getAllTo(key, chain);
        return chain;
    }

    public IntListIteratorChain inorderIterator() throws IOException, ClassNotFoundException {
        IntListIteratorChain chain = new IntListIteratorChain();
        this.inorderIterator(chain);
        return chain;
    }

    public final void insert(Object key, int value) throws IOException, ClassNotFoundException {
        if (this.isFull()) {
            ObjectBTree child = this.allocateNewNode();
            child.addTuples(this.getKeys(), this.getValues(), this.getChildIds());
            this.clearData();
            this.addFileId(0, child.getFileId());
            this.subdivideChild(0, child);
        }
        this.insertNotfull(key, value);
    }

    public final void replaceId(Object key, int oldRowId, int newRowId) throws ClassNotFoundException, IOException {
        int i;
        boolean valSet = false;
        for (i = this.findNearestKeyAbove(key); i < this.size() && this.isEqual(key, this.getKey(i)); ++i) {
            if (!this.isLeaf()) {
                this.replaceIdInChild(i, key, oldRowId, newRowId);
            }
            if (this.getValue(i) != oldRowId) continue;
            this.setValue(i, newRowId);
            valSet = true;
            this.getBTreeMetaData().setDirty(this);
            break;
        }
        if (!valSet && !this.isLeaf()) {
            this.replaceIdInChild(i, key, oldRowId, newRowId);
        }
    }

    public final void save() throws IOException, ClassNotFoundException {
        this.saveCounterIfRoot();
        this.write();
        int I = this.getChildIds().size();
        for (int i = 0; i < I; ++i) {
            this.getChild(i).save();
        }
    }

    public final int size() {
        return this.getKeys().size();
    }

    public final String toString() {
        return this.toString(0);
    }

    public void truncate() {
        this.getKeys().clear();
        super.truncate();
    }

    final ObjectBTree getChild(int index) throws IOException, ClassNotFoundException {
        if (index >= this.getChildIds().size()) {
            throw new IOException("Node " + this.getFileId() + " has no child at index " + index);
        }
        return this.getChildByFileId(this.getFileIdForIndex(index));
    }

    final boolean isValid() throws IOException, ClassNotFoundException {
        return this.isValid(true);
    }

    protected final void addKeyValuePair(Object key, int value, boolean setDirty) {
        this.getKeys().add(key);
        this.getValues().add(value);
        if (setDirty) {
            this.getBTreeMetaData().setDirty(this);
        }
    }

    protected ObjectBTree createNode(BTreeMetaData meta, Comparator comp) throws IOException, ClassNotFoundException {
        return new ObjectBTree(meta, comp);
    }

    protected void getAllExcludingNull(IntListIteratorChain chain) throws IOException, ClassNotFoundException {
        int start = this.getKeys().lastIndexOf(this.getNullKey());
        if (this.isLeaf() && start != -1 && start + 1 < this.size()) {
            chain.addIterator(this.getValues().subList(start + 1, this.size()).listIterator());
        } else {
            if (start == -1) {
                start = 0;
            }
            int size = this.size();
            for (int i = start; i < size + 1; ++i) {
                if (this.getChild(i).size() > 0) {
                    this.getChild(i).getAllExcludingNull(chain);
                }
                if (i >= size) break;
                chain.addIterator(this.getValue(i));
            }
        }
    }

    protected final Object getKey(int index) {
        return this.getKeys().get(index);
    }

    protected Object getNullKey() {
        return NullObject.INSTANCE;
    }

    protected ObjectBTree loadNode(BTreeMetaData meta, Comparator comp, int fileId) throws IOException, ClassNotFoundException {
        return new ObjectBTree(meta, comp, fileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void read() throws IOException, ClassNotFoundException {
        ObjectInputStream in = null;
        AxionFileSystem fs = new AxionFileSystem();
        try {
            int i;
            in = fs.openObjectInputSteam(this.getBTreeMetaData().getFileById(this.getFileId()));
            int size = in.readInt();
            for (i = 0; i < size; ++i) {
                this.addKeyValuePair(in.readObject(), in.readInt(), false);
            }
            size = in.readInt();
            for (i = 0; i < size; ++i) {
                this.getChildIds().add(in.readInt());
            }
            fs.closeInputStream(in);
        }
        catch (Throwable throwable) {
            fs.closeInputStream(in);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write() throws IOException {
        ObjectOutputStream out = null;
        AxionFileSystem fs = new AxionFileSystem();
        try {
            int i;
            out = fs.createObjectOutputSteam(this.getBTreeMetaData().getFileById(this.getFileId()));
            int size = this.size();
            out.writeInt(size);
            for (i = 0; i < size; ++i) {
                out.writeObject(this.getKey(i));
                out.writeInt(this.getValue(i));
            }
            size = this.getChildIds().size();
            out.writeInt(size);
            for (i = 0; i < size; ++i) {
                out.writeInt(this.getChildIds().get(i));
            }
            fs.closeOutputStream(out);
        }
        catch (Throwable throwable) {
            fs.closeOutputStream(out);
            throw throwable;
        }
    }

    private final void addKeyValuePair(int index, Object key, int value) {
        this.getKeys().add(index, key);
        this.getValues().add(index, value);
        this.getBTreeMetaData().setDirty(this);
    }

    private final void addKeyValuePair(Object key, int value) {
        this.addKeyValuePair(key, value, true);
    }

    private final void addKeyValuePairs(List keys, IntList values) {
        this.getKeys().addAll(keys);
        this.getValues().addAll((IntCollection)values);
        this.getBTreeMetaData().setDirty(this);
    }

    private final void addTuples(List keys, IntList values, IntList fileIds) {
        this.getKeys().addAll(keys);
        this.getValues().addAll((IntCollection)values);
        this.getChildIds().addAll((IntCollection)fileIds);
        this.getBTreeMetaData().setDirty(this);
    }

    private final ObjectBTree allocateNewNode() throws IOException, ClassNotFoundException {
        ObjectBTree tree = this.createNode(this.getBTreeMetaData(), this._comparator);
        this.getBTreeMetaData().cacheNode(tree.getFileId(), (BaseBTree)tree);
        this.getBTreeMetaData().setDirty(tree);
        return tree;
    }

    private final void borrowLeft(int borrowLoc) throws IOException, ClassNotFoundException {
        ObjectBTree leftSibling = this.getChild(borrowLoc - 1);
        ObjectBTree rightSibling = this.getChild(borrowLoc);
        rightSibling.addKeyValuePair(0, this.getKey(borrowLoc - 1), this.getValue(borrowLoc - 1));
        this.setKeyValuePairAt(borrowLoc - 1, leftSibling.getKey(leftSibling.size() - 1), leftSibling.getValue(leftSibling.getValues().size() - 1));
        if (!leftSibling.isLeaf()) {
            rightSibling.addFileId(0, leftSibling.getChild(leftSibling.getChildIds().size() - 1).getFileId());
        }
        leftSibling.removeKeyValuePairAt(leftSibling.size() - 1);
        if (!leftSibling.isLeaf()) {
            leftSibling.getChildIds().removeElementAt(leftSibling.getChildIds().size() - 1);
        }
    }

    private final void borrowRight(int borrowLoc) throws IOException, ClassNotFoundException {
        ObjectBTree leftSibling = this.getChild(borrowLoc);
        ObjectBTree rightSibling = this.getChild(borrowLoc + 1);
        leftSibling.addKeyValuePair(this.getKey(borrowLoc), this.getValue(borrowLoc));
        this.setKeyValuePairAt(borrowLoc, rightSibling.getKey(0), rightSibling.getValue(0));
        if (!leftSibling.isLeaf()) {
            leftSibling.addFileId(rightSibling.getChild(0).getFileId());
        }
        rightSibling.removeKeyValuePairAt(0);
        if (!rightSibling.isLeaf()) {
            rightSibling.getChildIds().removeElementAt(0);
        }
    }

    private final int compare(Object x, Object y) {
        if (x == this.getNullKey() && y == this.getNullKey()) {
            return 0;
        }
        if (x == this.getNullKey() && y != this.getNullKey()) {
            return -1;
        }
        if (y == this.getNullKey() && x != this.getNullKey()) {
            return 1;
        }
        return this._comparator.compare(x, y);
    }

    private final void deleteFromChild(int position, Object key, int rowid) throws IOException, ClassNotFoundException {
        ObjectBTree node = this.getChild(position);
        node.delete(key, rowid);
    }

    private final int findNearestKeyAbove(Object key) {
        int high = this.size();
        int low = 0;
        int cur = 0;
        if (this.size() == 0) {
            return 0;
        }
        if (this.isLessThan(this.getKey(this.size() - 1), key)) {
            return this.size();
        }
        if (this.isGreaterThanOrEqual(this.getKey(0), key)) {
            return 0;
        }
        while (low < high) {
            int comp = this.compare(key, this.getKey(cur));
            if (high == low) {
                cur = low;
                break;
            }
            if (comp == 0) {
                for (cur = (high + low) / 2; cur > 0 && this.isEqual(key, this.getKey(cur)); --cur) {
                }
                break;
            }
            if (high - low == 1) {
                cur = high;
                break;
            }
            if (comp > 0) {
                if (low == cur) {
                    ++low;
                    continue;
                }
                low = cur;
                continue;
            }
            high = cur;
        }
        while (cur < this.size() && this.isGreaterThan(key, this.getKey(cur))) {
            ++cur;
        }
        return cur;
    }

    private final int findNearestKeyBelow(Object key) {
        int size;
        int high = size = this.size();
        int low = 0;
        int cur = 0;
        if (size == 0) {
            return -1;
        }
        if (this.isLessThanOrEqual(this.getKey(size - 1), key)) {
            return size - 1;
        }
        if (this.isGreaterThan(this.getKey(0), key)) {
            return -1;
        }
        while (low < high) {
            cur = (high + low) / 2;
            int comp = this.compare(key, this.getKey(cur));
            if (0 == comp) {
                while (cur < size && this.isEqual(key, this.getKey(cur))) {
                    ++cur;
                }
                break;
            }
            if (comp > 0) {
                if (low == cur) {
                    ++low;
                    continue;
                }
                low = cur;
                continue;
            }
            high = cur;
        }
        while (cur >= 0 && this.isLessThan(key, this.getKey(cur))) {
            --cur;
        }
        return cur;
    }

    private final int findNearestKeyBelow(Object key, int rowid) throws IOException {
        int size;
        int high = size = this.size();
        int low = 0;
        int cur = 0;
        if (size == 0) {
            return -1;
        }
        if (this.isLessThan(this.getKey(size - 1), key)) {
            return size - 1;
        }
        if (this.isGreaterThan(this.getKey(0), key)) {
            return -1;
        }
        if (this.isEqual(this.getKey(size - 1), key)) {
            cur = this.findNearestRowBelow(key, rowid, size - 1);
            return cur;
        }
        while (low < high) {
            cur = (high + low) / 2;
            int comp = this.compare(key, this.getKey(cur));
            if (0 == comp) {
                cur = this.findNearestRowBelow(key, rowid, cur);
                break;
            }
            if (comp > 0) {
                if (low == cur) {
                    ++low;
                    continue;
                }
                low = cur;
                continue;
            }
            high = cur;
        }
        while (cur >= 0 && this.isLessThan(key, this.getKey(cur))) {
            --cur;
        }
        return cur;
    }

    private final int findNearestRowBelow(Object key, int rowid, int index) throws IOException {
        int cur = 0;
        int start = 0;
        int end = 0;
        boolean found = false;
        if (index == this.size() - 1 && index == 0) {
            cur = 0;
            boolean bl = found = rowid == this.getValue(cur);
            cur = found ? 0 : (this.getChildIds().size() > 0 && rowid > this.getValue(cur) ? ++cur : 0);
            return cur;
        }
        if (index == this.size() - 1) {
            end = index;
            for (cur = index; cur >= 0 && this.isEqual(key, this.getKey(cur)); --cur) {
                if (rowid != this.getValue(cur)) continue;
                found = true;
                break;
            }
            start = found ? cur : ++cur;
        } else if (index == 0) {
            start = index;
            for (cur = 0; cur <= this.size() && this.isEqual(key, this.getKey(cur)); ++cur) {
                if (rowid != this.getValue(cur)) continue;
                found = true;
                break;
            }
            end = found ? cur : --cur;
        } else {
            for (cur = index; cur >= 0 && this.isEqual(key, this.getKey(cur)); --cur) {
                if (rowid != this.getValue(cur)) continue;
                found = true;
                break;
            }
            int n = start = found ? cur : ++cur;
            if (!found) {
                for (cur = index; cur < this.size() && this.isEqual(key, this.getKey(cur)); ++cur) {
                    if (rowid != this.getValue(cur)) continue;
                    found = true;
                    break;
                }
                int n2 = end = found ? cur : --cur;
            }
        }
        if (!found) {
            if (rowid > this.getValue(end)) {
                cur = end;
            } else if (rowid < this.getValue(start)) {
                cur = start;
            } else {
                for (int i = start; i < end; ++i) {
                    if (rowid <= this.getValue(i) || rowid >= this.getValue(i + 1)) continue;
                    cur = i;
                    break;
                }
            }
        }
        return cur;
    }

    private final void getAll(Object key, IntListIteratorChain chain) throws IOException, ClassNotFoundException {
        int start = this.findNearestKeyAbove(key);
        if (this.isLeaf()) {
            int stop;
            for (stop = start; stop < this.size() && this.isEqual(key, this.getKey(stop)); ++stop) {
            }
            chain.addIterator(this.getValues().subList(start, stop).listIterator());
        } else {
            int i;
            for (i = start; i < this.size() && this.isEqual(key, this.getKey(i)); ++i) {
                this.getChild(i).getAll(key, chain);
                chain.addIterator(this.getValue(i));
            }
            this.getChild(i).getAll(key, chain);
        }
    }

    private final void getAllFrom(Object key, IntListIteratorChain chain) throws IOException, ClassNotFoundException {
        int start = this.findNearestKeyAbove(key);
        if (this.isLeaf()) {
            chain.addIterator(this.getValues().subList(start, this.size()).listIterator());
        } else {
            int size = this.size();
            for (int i = start; i < size + 1; ++i) {
                this.getChild(i).getAllFrom(key, chain);
                if (i >= size) break;
                chain.addIterator(this.getValue(i));
            }
        }
    }

    private final void getAllTo(Object key, IntListIteratorChain chain) throws IOException, ClassNotFoundException {
        if (this.isLeaf()) {
            int endpoint = this.getKeys().indexOf(key);
            if (-1 != endpoint) {
                chain.addIterator(this.getValues().subList(0, endpoint).listIterator());
            } else {
                chain.addIterator(this.getValues().listIterator());
            }
        } else {
            int size = this.size();
            for (int i = 0; i < size + 1; ++i) {
                this.getChild(i).getAllTo(key, chain);
                if (i >= size || !this.isGreaterThan(key, this.getKey(i))) break;
                chain.addIterator(this.getValue(i));
            }
        }
    }

    private final ObjectBTree getChildByFileId(int fileid) throws IOException, ClassNotFoundException {
        ObjectBTree child = (ObjectBTree)this.getBTreeMetaData().getCachedNode(fileid);
        if (null == child) {
            child = this.loadNode(this.getBTreeMetaData(), this._comparator, fileid);
            this.getBTreeMetaData().cacheNode(fileid, (BaseBTree)child);
        }
        return child;
    }

    private final List getKeys() {
        return this._keys;
    }

    private final void getLeftMost(Object[] keyParam, int[] valueParam) throws IOException, ClassNotFoundException {
        if (this.isLeaf()) {
            keyParam[0] = this.getKey(0);
            valueParam[0] = this.getValue(0);
        } else {
            this.getChild(0).getLeftMost(keyParam, valueParam);
        }
    }

    private final void getRightMost(Object[] keyParam, int[] valueParam) throws IOException, ClassNotFoundException {
        if (this.isLeaf()) {
            int max = this.size() - 1;
            keyParam[0] = this.getKey(max);
            valueParam[0] = this.getValue(max);
        } else {
            int max = this.getChildIds().size() - 1;
            this.getChild(max).getRightMost(keyParam, valueParam);
        }
    }

    private void inorderIterator(IntListIteratorChain chain) throws IOException, ClassNotFoundException {
        int start = 0;
        if (this.isLeaf()) {
            int stop = this.size();
            chain.addIterator(this.getValues().subList(0, stop).listIterator());
        } else {
            int i;
            int size = this.size();
            for (i = start; i < size; ++i) {
                this.getChild(i).inorderIterator(chain);
                chain.addIterator(this.getValue(i));
            }
            this.getChild(i).inorderIterator(chain);
        }
    }

    private final void insertNotfull(Object key, int value) throws IOException, ClassNotFoundException {
        int i = this.findNearestKeyBelow(key);
        if (this.isLeaf()) {
            this.addKeyValuePair(i + 1, key, value);
        } else {
            ObjectBTree child;
            if ((child = this.getChild(++i)).isFull()) {
                this.subdivideChild(i, child);
                if (this.isGreaterThan(key, this.getKey(i))) {
                    ++i;
                }
            }
            this.getChild(i).insertNotfull(key, value);
        }
    }

    private final boolean isEqual(Object x, Object y) {
        return this.compare(x, y) == 0;
    }

    private final boolean isGreaterThan(Object x, Object y) {
        return this.compare(x, y) > 0;
    }

    private final boolean isGreaterThanOrEqual(Object x, Object y) {
        return this.compare(x, y) >= 0;
    }

    private final boolean isLessThan(Object x, Object y) {
        return this.compare(x, y) < 0;
    }

    private final boolean isLessThanOrEqual(Object x, Object y) {
        return this.compare(x, y) <= 0;
    }

    private final boolean isNotEqual(Object x, Object y) {
        return this.compare(x, y) != 0;
    }

    private final boolean isValid(boolean isRoot) throws IOException, ClassNotFoundException {
        int size = this.size();
        if (!this.isLeaf() && size == 0) {
            return false;
        }
        if (!isRoot && size < this.getMinimizationFactor() - 1) {
            return false;
        }
        if (!(this.isLeaf() || this.getChildIds().size() == size + 1 && size == this.getValues().size())) {
            return false;
        }
        if (!this.isLeaf()) {
            int I = this.getChildIds().size();
            for (int i = 0; i < I; ++i) {
                if (this.getChild(i).isValid(false)) continue;
                return false;
            }
        }
        return true;
    }

    private final void maybeCollapseTree() throws IOException, ClassNotFoundException {
        if (!this.isLeaf() && this.size() <= 0) {
            ObjectBTree nodeToPromote = this.getChild(0);
            this.setTuples(nodeToPromote.getKeys(), nodeToPromote.getValues(), nodeToPromote.getChildIds());
        }
    }

    private final void mergeChildren(int mergeLoc, Object key) throws IOException, ClassNotFoundException {
        ObjectBTree leftChild = this.getChild(mergeLoc);
        ObjectBTree rightChild = this.getChild(mergeLoc + 1);
        leftChild.addKeyValuePair(key, this.getValue(mergeLoc));
        leftChild.addTuples(rightChild.getKeys(), rightChild.getValues(), rightChild.getChildIds());
        this.removeKeyValuePairAt(mergeLoc);
        this.getChildIds().removeElementAt(mergeLoc + 1);
        rightChild.clearData();
    }

    private final void removeKeyValuePairAt(int index) {
        this.getKeys().remove(index);
        this.getValues().removeElementAt(index);
        this.getBTreeMetaData().setDirty(this);
    }

    private final void replaceIdInChild(int position, Object key, int oldRowId, int newRowId) throws IOException, ClassNotFoundException {
        ObjectBTree node = this.getChild(position);
        node.replaceId(key, oldRowId, newRowId);
    }

    private final void setKeys(List keys) {
        this._keys = keys;
    }

    private final void setKeyValuePairAt(int index, Object key, int value) {
        this.getKeys().set(index, key);
        this.getValues().set(index, value);
        this.getBTreeMetaData().setDirty(this);
    }

    private final void setTuples(List keys, IntList values, IntList fileIds) {
        this.setKeys(keys);
        this.setValues(values);
        if (null != fileIds) {
            this.setChildIds(fileIds);
        } else {
            this.getChildIds().clear();
        }
        this.getBTreeMetaData().setDirty(this);
    }

    private final void subdivideChild(int pivot, ObjectBTree child) throws IOException, ClassNotFoundException {
        ObjectBTree fetus = this.allocateNewNode();
        this.addFileId(pivot + 1, fetus.getFileId());
        fetus.addKeyValuePairs(child.getKeys().subList(this.getMinimizationFactor(), this.getKeyCapacity()), child.getValues().subList(this.getMinimizationFactor(), this.getKeyCapacity()));
        int i = 0;
        if (!child.isLeaf()) {
            IntList sub = child.getChildIds().subList(this.getMinimizationFactor(), this.getKeyCapacity() + 1);
            fetus.addFileIds(sub);
            for (i = this.getKeyCapacity(); i >= this.getMinimizationFactor(); --i) {
                child.getChildIds().removeElementAt(i);
            }
        }
        this.addKeyValuePair(pivot, child.getKey(this.getMinimizationFactor() - 1), child.getValue(this.getMinimizationFactor() - 1));
        for (i = this.getKeyCapacity() - 1; i > this.getMinimizationFactor() - 2; --i) {
            child.removeKeyValuePairAt(i);
        }
    }

    private final String toString(int space) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.space(space));
        buf.append(this.getFileId());
        buf.append(": ");
        buf.append(this.getKeys().toString());
        buf.append("/");
        buf.append(this.getValues().toString());
        buf.append("\n");
        if (!this.isLeaf()) {
            int I = this.size() + 1;
            for (int i = 0; i < I; ++i) {
                ObjectBTree child = null;
                try {
                    child = this.getChild(i);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (null != child) {
                    buf.append(child.toString(space + 1));
                    continue;
                }
                buf.append(this.space(space + 1));
                buf.append("null");
                buf.append("\n");
            }
        }
        return buf.toString();
    }
}

