/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.util;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import org.axiondb.engine.rowcollection.IntHashMap;
import org.axiondb.util.BaseBTree;
import org.axiondb.util.CounterFile;

class BTreeMetaData {
    private BaseBTree _root;
    private CounterFile _fileIdCounter;
    private String _name;
    private File _dataDirectory;
    private int _minimizationFactor = 1000;
    private IntHashMap _nodeCache;
    private IntHashMap _dirtyNodes;

    public BTreeMetaData(File dataDirectory, String name, int minimizationFactor, BaseBTree root) throws IOException, ClassNotFoundException {
        this._dataDirectory = dataDirectory;
        this._name = name.toUpperCase();
        this._minimizationFactor = minimizationFactor;
        this._root = root;
        this._fileIdCounter = new CounterFile();
        this._nodeCache = new IntHashMap();
        this._dirtyNodes = new IntHashMap();
    }

    public boolean isRoot(BaseBTree node) {
        return node == this._root;
    }

    public void assignFileId(BaseBTree node) {
        node.setFileId(this._fileIdCounter.increment());
    }

    public File getDataDirectory() {
        return this._dataDirectory;
    }

    public void setDataDirectory(File dir) {
        this._dataDirectory = dir;
    }

    public String getName() {
        return this._name;
    }

    public int getMinimizationFactor() {
        return this._minimizationFactor;
    }

    public int incrementCounter() {
        return this._fileIdCounter.increment();
    }

    public void saveCounter() throws IOException {
        this._fileIdCounter.save(this.getCounterFile());
    }

    public void loadCounter() throws IOException {
        this._fileIdCounter = CounterFile.load(this.getCounterFile());
    }

    public File getCounterFile() {
        return new File(this.getDataDirectory(), this.getName() + ".CTR");
    }

    public final File getFileById(int fileid) {
        return new File(this.getDataDirectory(), this.getName() + "." + fileid);
    }

    public void cacheNode(int fileId, BaseBTree tree) {
        this._nodeCache.put(fileId, new SoftReference<BaseBTree>(tree));
    }

    public BaseBTree getCachedNode(int fileId) {
        Reference ref = (Reference)this._nodeCache.get(fileId);
        if (null != ref) {
            BaseBTree node = (BaseBTree)ref.get();
            if (null == node) {
                this._nodeCache.remove(fileId);
            }
            return node;
        }
        return null;
    }

    public BaseBTree getCachedNode(Integer fileId) {
        return this.getCachedNode((int)fileId);
    }

    public void cacheNode(Integer fileId, BaseBTree tree) {
        this.cacheNode((int)fileId, tree);
    }

    public void setDirty(BaseBTree tree) {
        this.setDirty(tree.getFileId(), tree);
    }

    public void setDirty(int fileId, BaseBTree tree) {
        this._dirtyNodes.put(fileId, tree);
    }

    public void setDirty(Integer fileId, BaseBTree tree) {
        this.setDirty((int)fileId, tree);
    }

    public void setAllClean() {
        this._dirtyNodes.clear();
        this._nodeCache.clear();
        int I = this._fileIdCounter.current();
        for (int i = 0; i < I; ++i) {
            File file = this.getFileById(i);
            if (!file.exists()) continue;
            file.delete();
        }
        this._fileIdCounter = new CounterFile();
    }

    public IntHashMap.ValueIterator getDirtyNodes() {
        return this._dirtyNodes.valueIterator();
    }

    public int getDirtyNodeCount() {
        return this._dirtyNodes.size();
    }

    public boolean hasDirtyNodes() {
        return !this._dirtyNodes.isEmpty();
    }
}

