/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.types.BaseNumberDataType;

public class UnsignedShortType
extends BaseNumberDataType {
    static final int MIN_VALUE = 0;
    static final int MAX_VALUE = 65535;
    private static final long serialVersionUID = 310386379898195195L;

    public int getJdbcType() {
        return 4;
    }

    public String getPreferredValueClassName() {
        return "java.lang.Integer";
    }

    public String toString() {
        return "unsignedshort";
    }

    public int getPrecision() {
        return String.valueOf(65535).length();
    }

    public int getColumnDisplaySize() {
        return String.valueOf(65535).length();
    }

    public boolean accepts(Object value) {
        if (value instanceof Number) {
            int s = ((Number)value).intValue();
            return s >= 0 && s <= 65535;
        }
        return super.accepts(value);
    }

    public Object convert(Object value) throws AxionException {
        if (value instanceof Number) {
            int s = ((Number)value).intValue();
            this.assertValidUnsignedShort(s);
            return new Integer(s);
        }
        if (value instanceof String) {
            try {
                Integer ival = new Integer(new BigDecimal(value.toString().trim()).intValue());
                this.assertValidUnsignedShort(ival);
                return ival;
            }
            catch (NumberFormatException e) {
                throw new AxionException(22018);
            }
        }
        return super.convert(value);
    }

    public Object successor(Object value) throws IllegalArgumentException {
        int v = (Integer)value;
        try {
            this.assertValidUnsignedShort(v);
        }
        catch (AxionException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (v == 65535) {
            return value;
        }
        return new Integer(++v);
    }

    public Object read(DataInput in) throws IOException {
        int value = this.toInt(in.readShort());
        if (0 == value && !in.readBoolean()) {
            return null;
        }
        return new Integer(value);
    }

    public void write(Object value, DataOutput out) throws IOException {
        if (null == value) {
            out.writeShort(this.fromInt(0));
            out.writeBoolean(false);
        } else {
            try {
                int val = (Integer)this.convert(value);
                out.writeShort(this.fromInt(val));
                if (0 == val) {
                    out.writeBoolean(true);
                }
            }
            catch (AxionException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    public DataType makeNewInstance() {
        return new UnsignedShortType();
    }

    public boolean isUnsigned() {
        return true;
    }

    private final int toInt(short value) {
        return value & 0xFFFF;
    }

    private final short fromInt(int value) {
        return (short)(value & 0xFFFF);
    }

    private final void assertValidUnsignedShort(int value) throws AxionException {
        if (value > 65535 || value < 0) {
            throw new AxionException(22003);
        }
    }
}

