/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.axiondb.AxionCommand;
import org.axiondb.AxionException;
import org.axiondb.Database;
import org.axiondb.jdbc.AxionConnection;
import org.axiondb.jdbc.AxionResultSet;
import org.axiondb.parser.AxionSqlParser;
import org.axiondb.util.ExceptionConverter;

public abstract class BaseAxionStatement
implements Statement {
    protected ArrayList _batchContext;
    private AxionSqlParser _parser;
    protected SQLWarning _warning;
    private boolean _closed = false;
    protected AxionConnection _conn;
    private int _maxRows = 0;
    private AxionResultSet _rset;
    private int _updateCount = -1;

    protected BaseAxionStatement(AxionConnection conn) throws SQLException {
        this._conn = conn;
        this._parser = new AxionSqlParser();
    }

    public void close() throws SQLException {
        if (!this._closed) {
            this.closeCurrentResultSet();
            this.clearConnection();
            this.clearBatchContext();
            this._batchContext = null;
            this._closed = true;
        }
    }

    public Connection getConnection() throws SQLException {
        return this._conn;
    }

    public int getMaxRows() throws SQLException {
        return this._maxRows;
    }

    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("MaxRows should be non-negative");
        }
        this._maxRows = max;
    }

    protected final void assertOpen() throws SQLException {
        if (this._closed) {
            throw new SQLException("Already closed.");
        }
    }

    protected final void clearConnection() {
        this._conn = null;
    }

    public boolean isClosed() {
        return this._closed;
    }

    protected void clearCurrentResult() throws SQLException {
        this.clearCurrentUpdateCount();
        this.closeCurrentResultSet();
    }

    protected int clearCurrentUpdateCount() {
        int count = this.getCurrentUpdateCount();
        this.setCurrentUpdateCount(-1);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeCurrentResultSet() throws SQLException {
        try {
            if (null != this._rset) {
                this._rset.close();
            }
        }
        finally {
            this._rset = null;
        }
    }

    protected final AxionConnection getAxionConnection() throws SQLException {
        return (AxionConnection)this.getConnection();
    }

    protected final AxionResultSet getCurrentResultSet() {
        return this._rset;
    }

    protected final int getCurrentUpdateCount() {
        return this._updateCount;
    }

    protected final Database getDatabase() throws AxionException {
        return this._conn.getCurrentTransaction();
    }

    protected final boolean hasCurrentResultSet() {
        return null != this._rset;
    }

    public AxionCommand parseCommand(String sql) throws SQLException {
        try {
            return this._parser.parse(sql);
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
        catch (RuntimeException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    protected void setCurrentResult(boolean isrset, AxionCommand cmd) {
        if (isrset) {
            this.setCurrentResultSet((AxionResultSet)cmd.getResultSet());
        } else {
            this.setCurrentUpdateCount(cmd.getEffectedRowCount());
        }
    }

    protected void setCurrentResultSet(AxionResultSet rset) {
        rset.setMaxRows(this._maxRows);
        rset.setStatement(this);
        this._rset = rset;
    }

    protected final void setCurrentUpdateCount(int count) {
        this._updateCount = count;
    }

    protected final void addToBatchContext(Object obj) throws SQLException {
        if (this._batchContext == null) {
            this._batchContext = new ArrayList();
        }
        this._batchContext.add(obj);
    }

    protected final void clearBatchContext() {
        if (this._batchContext != null) {
            this._batchContext.clear();
        }
    }

    protected final Iterator getBatchContext() {
        if (this._batchContext != null) {
            return this._batchContext.iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    protected final int getBatchCount() {
        if (this._batchContext != null) {
            return this._batchContext.size();
        }
        return 0;
    }
}

