/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.Selectable;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.BooleanType;
import org.axiondb.types.StringType;
import org.axiondb.util.DateTimeUtils;

public class IsValidDateTimeFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType BOOLEAN_TYPE = new BooleanType();
    private static final DataType ARG1_TYPE = new StringType();
    private static final DataType ARG2_TYPE = new StringType();

    public IsValidDateTimeFunction() {
        super("ISVALIDDATETIME");
    }

    public DataType getDataType() {
        return BOOLEAN_TYPE;
    }

    public boolean isValid() {
        return this.getArgumentCount() == 2;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        String dateStr = null;
        String formatStr = null;
        Selectable sel = this.getArgument(1);
        Object arg2 = sel.evaluate(row);
        if (null == arg2) {
            throw new AxionException(22004);
        }
        formatStr = (String)ARG2_TYPE.convert(arg2);
        sel = this.getArgument(0);
        Object arg1 = sel.evaluate(row);
        if (null == arg1) {
            return null;
        }
        dateStr = (String)ARG1_TYPE.convert(arg1);
        try {
            DateTimeUtils.convertToTimestamp(dateStr, formatStr);
            return Boolean.TRUE;
        }
        catch (AxionException e) {
            if ("22007".equals(e.getSQLState())) {
                throw e;
            }
            return Boolean.FALSE;
        }
    }

    public ConcreteFunction makeNewInstance() {
        return new IsValidDateTimeFunction();
    }
}

