/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.RowDecorator;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.BooleanType;

public abstract class BaseBooleanBranchFunction
extends BaseFunction
implements ScalarFunction {
    private static final DataType BOOLEAN_TYPE = new BooleanType();

    public BaseBooleanBranchFunction(String name) {
        super(name);
    }

    public final DataType getDataType() {
        return BOOLEAN_TYPE;
    }

    public final Object evaluate(RowDecorator row) throws AxionException {
        boolean hasUnknown = false;
        int I = this.getArgumentCount();
        for (int i = 0; i < I; ++i) {
            Object rawVal = this.getArgument(i).evaluate(row);
            DataType type = this.getArgument(i).getDataType();
            Object val = type.convert(rawVal);
            if (null == val) {
                hasUnknown = true;
                continue;
            }
            if (this.exitOnValue() != type.toBoolean(val)) continue;
            return this.exitOnValue() ? Boolean.TRUE : Boolean.FALSE;
        }
        return hasUnknown ? null : (this.exitOnValue() ? Boolean.FALSE : Boolean.TRUE);
    }

    public final boolean isValid() {
        return true;
    }

    protected abstract boolean exitOnValue();
}

