/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.rowiterators;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.axiondb.AxionException;
import org.axiondb.Row;
import org.axiondb.engine.rowiterators.BaseRowIterator;

public class ListIteratorRowIterator
extends BaseRowIterator {
    private int _currentIndex = -1;
    private Row _currentRow = null;
    private boolean _currentRowSet = false;
    private ListIterator _iterator = null;

    public ListIteratorRowIterator(ListIterator iter) {
        this._iterator = iter;
    }

    public void add(Row row) throws AxionException {
        this._iterator.add(row);
    }

    public Row current() {
        if (this.hasCurrent()) {
            return this._currentRow;
        }
        throw new NoSuchElementException("No current row has been set.");
    }

    public int currentIndex() {
        return this._currentIndex;
    }

    public boolean hasCurrent() {
        return this._currentRowSet;
    }

    public boolean hasNext() {
        return this._iterator.hasNext();
    }

    public boolean hasPrevious() {
        return this._iterator.hasPrevious();
    }

    public Row next() {
        this._currentIndex = this._iterator.nextIndex();
        this._currentRow = (Row)this._iterator.next();
        this._currentRowSet = true;
        return this._currentRow;
    }

    public int nextIndex() {
        return this._iterator.nextIndex();
    }

    public Row previous() {
        this._currentRow = (Row)this._iterator.previous();
        this._currentRowSet = true;
        this._currentIndex = this._iterator.nextIndex();
        return this._currentRow;
    }

    public int previousIndex() {
        return this._iterator.previousIndex();
    }

    public void remove() {
        if (!this.hasCurrent()) {
            throw new IllegalStateException("No current row.");
        }
        this._iterator.remove();
        this._currentRow = null;
        this._currentRowSet = false;
        this._currentIndex = -1;
    }

    public void reset() {
        while (this._iterator.hasPrevious()) {
            this._iterator.previous();
        }
        this._currentRow = null;
        this._currentRowSet = false;
        this._currentIndex = -1;
    }

    public void set(Row row) {
        if (!this.hasCurrent()) {
            throw new IllegalStateException("No current row.");
        }
        this._iterator.set(row);
        this._currentRow = row;
    }

    public String toString() {
        return "ListIterator";
    }
}

