/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.rowiterators;

import java.util.NoSuchElementException;
import org.axiondb.AxionException;
import org.axiondb.Row;
import org.axiondb.RowIterator;
import org.axiondb.engine.rowiterators.BaseRowIterator;
import org.axiondb.engine.rows.JoinedRow;

public class JoinRowIterator
extends BaseRowIterator {
    private RowIterator _iterator = null;
    private Row _row = null;
    private boolean _rowOnRight = false;

    public JoinRowIterator(Row row, RowIterator iterator) {
        this(row, iterator, false);
    }

    public JoinRowIterator(Row row, RowIterator iterator, boolean rowOnRight) {
        this._row = row;
        this._iterator = iterator;
        this._rowOnRight = rowOnRight;
    }

    public Row current() {
        if (this._iterator.hasCurrent()) {
            return this.makeRow(this._row, this._iterator.current());
        }
        throw new NoSuchElementException("No current row has been set.");
    }

    public boolean hasCurrent() {
        return this._iterator.hasCurrent();
    }

    public boolean hasNext() {
        return this._iterator.hasNext();
    }

    public boolean hasPrevious() {
        return this._iterator.hasPrevious();
    }

    public Row next() throws AxionException {
        return this.makeRow(this._row, this._iterator.next());
    }

    public Row previous() throws AxionException {
        return this.makeRow(this._row, this._iterator.previous());
    }

    public int currentIndex() {
        return this._iterator.currentIndex();
    }

    public int nextIndex() {
        return this._iterator.nextIndex();
    }

    public int previousIndex() {
        return this._iterator.previousIndex();
    }

    public void reset() throws AxionException {
        this._iterator.reset();
    }

    private Row makeRow(Row fromRow, Row fromIter) {
        JoinedRow row = new JoinedRow();
        if (this._rowOnRight) {
            row.addRow(fromIter);
            row.addRow(fromRow);
        } else {
            row.addRow(fromRow);
            row.addRow(fromIter);
        }
        return row;
    }
}

