/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.metaupdaters;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.axiondb.AxionException;
import org.axiondb.ColumnIdentifier;
import org.axiondb.Database;
import org.axiondb.Literal;
import org.axiondb.Selectable;
import org.axiondb.TableIdentifier;
import org.axiondb.engine.commands.UpdateCommand;
import org.axiondb.engine.rows.SimpleRow;
import org.axiondb.event.BaseDatabaseModificationListener;
import org.axiondb.event.DatabaseModificationListener;
import org.axiondb.event.DatabaseSequenceEvent;
import org.axiondb.event.SequenceModificationListener;
import org.axiondb.functions.FunctionIdentifier;

public class AxionSequencesMetaTableUpdater
extends BaseDatabaseModificationListener
implements DatabaseModificationListener,
SequenceModificationListener {
    private static Logger _log = Logger.getLogger(AxionSequencesMetaTableUpdater.class.getName());
    private Database _db = null;

    public AxionSequencesMetaTableUpdater(Database db) {
        this._db = db;
    }

    public void sequenceAdded(DatabaseSequenceEvent e) {
        SimpleRow row = new SimpleRow(2);
        row.set(0, e.getName());
        row.set(1, e.getValue());
        try {
            this._db.getTable("AXION_SEQUENCES").addRow(row);
        }
        catch (AxionException ex) {
            _log.log(Level.SEVERE, "Unable to mention sequence in system tables", ex);
        }
    }

    public void sequenceIncremented(DatabaseSequenceEvent e) {
        ColumnIdentifier col = new ColumnIdentifier("SEQUENCE_NAME");
        Literal lit = new Literal(e.getName());
        UpdateCommand cmd = new UpdateCommand();
        cmd.setTable(new TableIdentifier("AXION_SEQUENCES"));
        cmd.setWhere(this.makeEqualFunction(col, lit));
        cmd.addColumn(new ColumnIdentifier("SEQUENCE_VALUE"));
        cmd.addValue(new Literal(e.getValue()));
        try {
            cmd.executeUpdate(this._db);
        }
        catch (AxionException ex) {
            _log.log(Level.SEVERE, "Unable to update sequence value in system tables", ex);
        }
    }

    private FunctionIdentifier makeEqualFunction(Selectable left, Selectable right) {
        FunctionIdentifier function = new FunctionIdentifier("=");
        function.addArgument(left);
        function.addArgument(right);
        return function;
    }
}

