/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.commands;

import java.util.Iterator;
import org.axiondb.AxionException;
import org.axiondb.Constraint;
import org.axiondb.Database;
import org.axiondb.Table;
import org.axiondb.constraints.ForeignKeyConstraint;
import org.axiondb.constraints.UniqueConstraint;
import org.axiondb.engine.commands.ConstraintCommand;

public class DropConstraintCommand
extends ConstraintCommand {
    private boolean _cascade = false;
    private String _constraintName;

    public DropConstraintCommand(String tableName, String constraintName, boolean cascade) {
        super(tableName);
        this._cascade = cascade;
        this.setConstraintName(constraintName);
    }

    public String getConstraintName() {
        return this._constraintName;
    }

    public void setConstraintName(String name) {
        this._constraintName = name;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ALTER TABLE ");
        buf.append(this.getTableName());
        buf.append(" DROP CONSTRAINT ");
        buf.append(this.getConstraintName());
        buf.append(this._cascade ? " CASCADE " : "");
        return buf.toString();
    }

    protected void execute(Database db, Table table) throws AxionException {
        if (null == this._constraintName) {
            throw new AxionException("Constraint name must not be null.");
        }
        Constraint constraint = table.removeConstraint(this.getConstraintName());
        if (constraint == null) {
            throw new AxionException("Constraint " + this._constraintName + " not found.");
        }
        if (constraint instanceof ForeignKeyConstraint) {
            this.handleForeignKeyConstraint(db, table, constraint);
        } else if (constraint instanceof UniqueConstraint) {
            this.handleUniqueConstraint(db, table, constraint);
        }
    }

    private void handleForeignKeyConstraint(Database db, Table table, Constraint constraint) throws AxionException {
        ForeignKeyConstraint fk = (ForeignKeyConstraint)constraint;
        if (!fk.getParentTableName().equals(fk.getChildTableName())) {
            if (table.getName().equals(fk.getChildTableName())) {
                Table parentTable = db.getTable(fk.getParentTableName());
                parentTable.removeConstraint(this.getConstraintName());
            } else {
                table.addConstraint(constraint);
                throw new AxionException("Constraint " + this._constraintName + " not found.");
            }
        }
    }

    private void handleUniqueConstraint(Database db, Table table, Constraint constraint) throws AxionException {
        UniqueConstraint uc = (UniqueConstraint)constraint;
        Iterator fks = uc.getFKs();
        while (fks.hasNext()) {
            String fkName = (String)fks.next();
            ForeignKeyConstraint fk = (ForeignKeyConstraint)table.getConstraint(fkName);
            if (fk.getParentTableName().equals(fk.getChildTableName())) {
                if (this._cascade) {
                    table.removeConstraint(fkName);
                    continue;
                }
                throw new AxionException("FK: " + fkName + " refering this PK, ca't drop constraint");
            }
            if (!table.getName().equals(fk.getParentTableName())) continue;
            if (this._cascade) {
                table.removeConstraint(fkName);
                Table childTable = db.getTable(fk.getChildTableName());
                childTable.removeConstraint(fkName);
                continue;
            }
            throw new AxionException("FK: " + fkName + " refering this PK, ca't drop constraint");
        }
    }
}

