/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.commands;

import java.util.List;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.ColumnIdentifier;
import org.axiondb.Constraint;
import org.axiondb.Database;
import org.axiondb.Index;
import org.axiondb.Table;
import org.axiondb.TableIdentifier;
import org.axiondb.constraints.ForeignKeyConstraint;
import org.axiondb.constraints.UniqueConstraint;
import org.axiondb.engine.commands.ConstraintCommand;
import org.axiondb.util.StringIdentifierGenerator;

public class AddConstraintCommand
extends ConstraintCommand {
    private Constraint _constraint;

    public AddConstraintCommand(String tableName, Constraint constraint) {
        super(tableName);
        this.setConstraint(constraint);
    }

    public Constraint getConstraint() {
        return this._constraint;
    }

    private void setConstraint(Constraint c) {
        this._constraint = c;
    }

    protected void execute(Database db, Table table) throws AxionException {
        this.assertNotReadOnly(db);
        if (null == this.getConstraint()) {
            throw new AxionException("Constraint must not be null.");
        }
        this.getConstraint().resolve(db, new TableIdentifier(this.getTableName()));
        table.addConstraint(this.getConstraint());
        if (this.getConstraint() instanceof UniqueConstraint) {
            UniqueConstraint pk = (UniqueConstraint)this.getConstraint();
            boolean isUnique = pk.getSelectableCount() == 1;
            this.buildIndexIfRequired(db, pk.getSelectableList(), table, isUnique);
        } else if (this.getConstraint() instanceof ForeignKeyConstraint) {
            ForeignKeyConstraint fk = (ForeignKeyConstraint)this.getConstraint();
            if (!fk.getParentTableName().equals(fk.getChildTableName())) {
                Table parentTable = db.getTable(fk.getParentTableName());
                parentTable.addConstraint(fk);
            }
            List childColumns = fk.getChildTableColumns();
            Table childTable = db.getTable(fk.getChildTableName());
            this.buildIndexIfRequired(db, childColumns, childTable, false);
        }
    }

    private void buildIndexIfRequired(Database db, List columns, Table table, boolean isUnique) throws AxionException {
        ColumnIdentifier columnId;
        Column column;
        Object sel;
        boolean foundIndex = false;
        int I = columns.size();
        for (int i = 0; i < I; ++i) {
            ColumnIdentifier columnId2;
            Column column2;
            Object sel2 = columns.get(i);
            if (!(sel2 instanceof ColumnIdentifier) || !table.isColumnIndexed(column2 = table.getColumn((columnId2 = (ColumnIdentifier)sel2).getName()))) continue;
            foundIndex = true;
            break;
        }
        if (!foundIndex && columns.size() >= 1 && (sel = columns.get(0)) instanceof ColumnIdentifier && !table.isColumnIndexed(column = table.getColumn((columnId = (ColumnIdentifier)sel).getName()))) {
            boolean isMemorydb = db.getDBDirectory() == null;
            String name = StringIdentifierGenerator.INSTANCE.next16DigitIdentifier("SYS");
            Index index = db.getIndexFactory("default").makeNewInstance(name, column, isUnique, isMemorydb);
            if (index != null) {
                db.addIndex(index, table, true);
            }
        }
    }
}

