/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.axiondb.AxionException;
import org.axiondb.Database;
import org.axiondb.Transaction;
import org.axiondb.TransactionConflictException;
import org.axiondb.TransactionManager;
import org.axiondb.engine.SnapshotIsolationTransaction;
import org.axiondb.util.Utils;

public class TransactionManagerImpl
implements TransactionManager {
    private List _committedTransactions = new ArrayList();
    private List _openTransactions = new ArrayList();
    private Database _database = null;
    public static final boolean NEVER_APPLY;
    private static Logger _log;

    public TransactionManagerImpl(Database db) {
        this._database = db;
    }

    public synchronized Transaction createTransaction() throws AxionException {
        this.assertNotShutdown();
        SnapshotIsolationTransaction t = new SnapshotIsolationTransaction(this.getLastCommittedTransaction());
        this._openTransactions.add(t);
        return t;
    }

    public synchronized void commitTransaction(Transaction t) throws AxionException {
        this.assertNotShutdown();
        if (t.getModifiedTables().isEmpty()) {
            t.commit();
            t.apply();
            this._openTransactions.remove(t);
        } else {
            Iterator iter = null;
            int index = this._committedTransactions.indexOf(t.getOpenOnTransaction());
            iter = -1 == index ? this._committedTransactions.iterator() : this._committedTransactions.subList(index + 1, this._committedTransactions.size()).iterator();
            while (iter.hasNext()) {
                Transaction c = (Transaction)iter.next();
                if (!this.inConflict(t, c)) continue;
                _log.log(Level.FINE, "commitTransaction(): conflict found.");
                throw new TransactionConflictException("Transaction conflict.");
            }
            t.commit();
            this._committedTransactions.add(t);
            this._openTransactions.remove(t);
        }
        this.tryToApply();
    }

    public synchronized void abortTransaction(Transaction t) throws AxionException {
        this.assertNotShutdown();
        t.rollback();
        this._openTransactions.remove(t);
        try {
            this.tryToApply();
        }
        catch (AxionException e) {
            _log.log(Level.FINE, e.getMessage(), e);
        }
    }

    public synchronized void shutdown() throws AxionException {
        for (int i = this._openTransactions.size() - 1; i >= 0; --i) {
            Transaction t = (Transaction)this._openTransactions.get(i);
            t.rollback();
        }
        this._openTransactions.clear();
        try {
            this.tryToApply();
        }
        catch (AxionException axionException) {
            // empty catch block
        }
        this._database.shutdown();
        this._database = null;
    }

    public synchronized boolean isShutdown() {
        return null == this._database;
    }

    private boolean inConflict(Transaction newT, Transaction oldT) {
        return !newT.getModifiedTables().isEmpty() && Utils.containsAny(newT.getReadTables(), oldT.getModifiedTables());
    }

    private void assertNotShutdown() throws AxionException {
        if (this.isShutdown()) {
            throw new AxionException("Already shutdown");
        }
    }

    private void tryToApply() throws AxionException {
        if (!NEVER_APPLY && this._openTransactions.isEmpty()) {
            Transaction last = null;
            try {
                Iterator iter = this._committedTransactions.iterator();
                while (iter.hasNext()) {
                    last = (Transaction)iter.next();
                    last.apply();
                    iter.remove();
                }
            }
            catch (Exception e) {
                this._committedTransactions.clear();
                throw new AxionException("Fail to apply transction", e);
            }
            if (null != last) {
                last.checkpoint();
            }
        }
    }

    private Database getLastCommittedTransaction() {
        if (this._committedTransactions.isEmpty()) {
            return this._database;
        }
        return (Database)this._committedTransactions.get(this._committedTransactions.size() - 1);
    }

    static {
        boolean neverApply = false;
        try {
            neverApply = Boolean.getBoolean("org.axiondb.engine.TransactionManagerImpl.NEVER_APPLY");
        }
        catch (Throwable t) {
            neverApply = false;
        }
        NEVER_APPLY = neverApply;
        _log = Logger.getLogger(TransactionManagerImpl.class.getName());
    }
}

